/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance.claim;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.SplitPane;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.AbstractBrowserListener;
import org.openvpms.web.component.im.query.BrowserListener;
import org.openvpms.web.component.im.query.DefaultActQuery;
import org.openvpms.web.component.im.query.DefaultIMObjectTableBrowser;
import org.openvpms.web.component.im.query.ListResultSet;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.component.im.table.act.AbstractActTableModel;
import org.openvpms.web.echo.button.CheckBox;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.SplitPaneFactory;
import org.openvpms.web.workspace.customer.credit.ChargeAllocationTableModel;
import org.openvpms.web.workspace.patient.insurance.claim.Charges;

public class ChargeBrowser {
    private final Party patient;
    private final Map<FinancialAct, Boolean> selected = new HashMap<FinancialAct, Boolean>();
    private final Charges charges;
    private final PagedIMTable<FinancialAct> table;
    private final SplitPane component;
    private final Column container = ColumnFactory.create((String)"Inset");
    private static final String[] STATUSES = new String[]{"POSTED"};
    private static final String[] ARCHETYPES = new String[]{"act.customerAccountChargesInvoice"};

    public ChargeBrowser(Party customer, Party patient, Charges charges, Date from, Date to, LayoutContext context) {
        this.patient = patient;
        this.charges = charges;
        DefaultActQuery query = new DefaultActQuery((Entity)customer, "customer", "participation.customer", ARCHETYPES, STATUSES);
        query.getComponent();
        query.setAllDates(false);
        query.setFrom(from);
        query.setTo(to);
        query.setConstraints((IConstraint)Constraints.exists((ArchetypeQuery)Constraints.subQuery((String)"act.customerAccountInvoiceItem", (String)"i").add((IConstraint)Constraints.join((String)"invoice").add((IConstraint)Constraints.idEq((String)"source", (String)"act"))).add((IConstraint)Constraints.join((String)"patient").add((IConstraint)Constraints.eq((String)"entity", (Object)patient)))));
        ChargeAllocationTableModel model = new ChargeAllocationTableModel(context);
        DefaultIMObjectTableBrowser browser = new DefaultIMObjectTableBrowser((Query)query, (IMTableModel)model, context);
        browser.addBrowserListener((BrowserListener)new AbstractBrowserListener<FinancialAct>(){

            public void selected(FinancialAct object) {
                ChargeBrowser.this.setSelectedInvoice(object);
            }
        });
        this.table = new PagedIMTable((IMTableModel)new ItemTableModel(this.selected, context));
        this.component = SplitPaneFactory.create((int)5, (String)"BrowserCRUDWorkspace.Layout", (Component[])new Component[]{browser.getComponent(), this.container});
        browser.query();
    }

    public List<FinancialAct> getSelectedInvoices() {
        HashSet<FinancialAct> invoices = new HashSet<FinancialAct>();
        for (Act act : this.getSelectedItems()) {
            FinancialAct invoice = this.charges.getInvoice(act);
            if (invoice == null) continue;
            invoices.add(invoice);
        }
        return new ArrayList<FinancialAct>(invoices);
    }

    public List<FinancialAct> getSelectedItems() {
        ArrayList<FinancialAct> result = new ArrayList<FinancialAct>();
        for (Map.Entry<FinancialAct, Boolean> entry : this.selected.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    public Component getComponent() {
        return this.component;
    }

    private void setSelectedInvoice(FinancialAct invoice) {
        Charges.Matches matches = this.charges.getMatches(invoice, this.patient);
        List<FinancialAct> items = matches.getItems();
        this.container.removeAll();
        if (!items.isEmpty()) {
            for (FinancialAct item : items) {
                this.selected.put(item, Boolean.TRUE);
            }
            this.table.setResultSet((ResultSet)new ListResultSet(items, 20));
            this.container.add(this.table.getComponent());
        } else {
            Label label = LabelFactory.create((boolean)true, (boolean)true);
            label.setStyleName("bold");
            label.setText(matches.getMessage());
            label.setLayoutData((LayoutData)ColumnFactory.layout((Alignment)Alignment.ALIGN_CENTER));
            Column wrapper = ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{label});
            wrapper.setLayoutData((LayoutData)ColumnFactory.layout((Alignment)Alignment.ALIGN_CENTER));
            this.container.add((Component)wrapper);
        }
    }

    private static class ItemTableModel
    extends AbstractActTableModel<FinancialAct> {
        private final Map<FinancialAct, Boolean> selected;
        private int selectedIndex;

        public ItemTableModel(Map<FinancialAct, Boolean> selected, LayoutContext context) {
            super("act.customerAccountInvoiceItem", context);
            this.selected = selected;
        }

        protected Object getValue(final FinancialAct object, TableColumn column, int row) {
            Object result;
            if (column.getModelIndex() == this.selectedIndex) {
                Boolean value = this.selected.get(object);
                final CheckBox box = new CheckBox();
                box.setSelected(value != null && value != false);
                box.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                    public void onAction(ActionEvent event) {
                        selected.put(object, box.isSelected());
                    }
                });
                result = box;
            } else {
                result = super.getValue((IMObject)object, column, row);
            }
            return result;
        }

        protected TableColumnModel createColumnModel(String[] shortNames, LayoutContext context) {
            DefaultTableColumnModel model = (DefaultTableColumnModel)super.createColumnModel(shortNames, context);
            this.selectedIndex = this.getNextModelIndex((TableColumnModel)model);
            model.addColumn(new TableColumn(this.selectedIndex));
            model.moveColumn(model.getColumnCount() - 1, 0);
            return model;
        }
    }
}

