/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance.claim;

import echopointng.ProgressBar;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.TaskQueueHandle;
import nextapp.echo2.webcontainer.ContainerContext;
import org.openvpms.insurance.claim.Claim;
import org.openvpms.insurance.claim.GapClaim;
import org.openvpms.insurance.internal.claim.GapClaimImpl;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.dialog.MessageDialog;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;

class BenefitDialog
extends MessageDialog {
    public static final String PAY_FULL_CLAIM_ID = "button.payfullclaim";
    public static final String STOP_WAITING_ID = "button.stopwaitingforbenefit";
    private final ProgressBar bar;
    private GapClaimImpl claim;
    private long lastReloaded;
    private TaskQueueHandle taskQueue;

    public BenefitDialog(GapClaimImpl claim, HelpContext help) {
        super(Messages.get((String)"patient.insurance.benefit.title"), Messages.format((String)"patient.insurance.benefit.message", (Object[])new Object[]{claim.getPolicy().getInsurer().getName()}), new String[]{PAY_FULL_CLAIM_ID, STOP_WAITING_ID}, help);
        this.claim = claim;
        this.bar = new ProgressBar();
        this.bar.setCompletedColor(Color.GREEN);
        this.bar.setNumberOfBlocks(10);
        this.bar.setMinimum(0);
        this.bar.setMaximum(10);
        this.lastReloaded = System.currentTimeMillis();
        this.enableFullClaim(claim);
    }

    public GapClaimImpl getClaim() {
        return this.claim;
    }

    public void show() {
        this.queueRefresh();
        super.show();
    }

    public void userClose() {
        this.removeTaskQueue();
        super.userClose();
    }

    protected void queueRefresh() {
        ApplicationInstance app = ApplicationInstance.getActive();
        app.enqueueTask(this.getTaskQueue(), this::refresh);
    }

    protected void doLayout() {
        Label content = LabelFactory.create((boolean)true, (boolean)true);
        content.setText(this.getMessage());
        Column column = ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{content, this.bar});
        this.getLayout().add((Component)ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{column}));
    }

    protected boolean reload(long now) {
        return now - this.lastReloaded > 4000L;
    }

    protected void refresh() {
        try {
            this.advance();
            if (!this.process()) {
                this.queueRefresh();
                this.enableFullClaim(this.claim);
            } else {
                this.claimUpdated();
            }
        }
        catch (Throwable throwable) {
            this.removeTaskQueue();
            ErrorHelper.show((Throwable)throwable);
        }
    }

    private void enableFullClaim(GapClaimImpl claim) {
        boolean accepted = claim.getStatus() == Claim.Status.ACCEPTED;
        this.getButtons().setEnabled(PAY_FULL_CLAIM_ID, accepted);
    }

    private void claimUpdated() {
        this.setAction("ok");
        this.userClose();
    }

    private boolean process() {
        boolean result = false;
        long now = System.currentTimeMillis();
        if (this.reload(now)) {
            this.lastReloaded = now;
            this.claim = this.claim.reload();
            Claim.Status status = this.claim.getStatus();
            GapClaim.GapStatus gapStatus = this.claim.getGapStatus();
            if (gapStatus == GapClaim.GapStatus.RECEIVED && status == Claim.Status.ACCEPTED || status == Claim.Status.CANCELLING || status == Claim.Status.CANCELLED || status == Claim.Status.DECLINED) {
                result = true;
            }
        }
        return result;
    }

    private void advance() {
        int value = this.bar.getValue() + 1;
        if (value > this.bar.getMaximum()) {
            value = this.bar.getMinimum();
        }
        this.bar.setValue(value);
    }

    private TaskQueueHandle getTaskQueue() {
        if (this.taskQueue == null) {
            ApplicationInstance app = ApplicationInstance.getActive();
            this.taskQueue = app.createTaskQueue();
            ContainerContext context = (ContainerContext)app.getContextProperty(ContainerContext.CONTEXT_PROPERTY_NAME);
            if (context != null) {
                context.setTaskQueueCallbackInterval(this.taskQueue, 500);
            }
        }
        return this.taskQueue;
    }

    private void removeTaskQueue() {
        if (this.taskQueue != null) {
            ApplicationInstance app = ApplicationInstance.getActive();
            app.removeTaskQueue(this.taskQueue);
            this.taskQueue = null;
        }
    }
}

