/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.info;

import java.util.List;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.IMObjectTabPaneModel;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.patient.info.PatientAppointmentQuery;
import org.openvpms.web.workspace.patient.info.PatientTaskQuery;
import org.openvpms.web.workspace.workflow.appointment.view.ParticipantAppointmentBrowser;
import org.openvpms.web.workspace.workflow.appointment.view.ParticipantAppointmentTableModel;
import org.openvpms.web.workspace.workflow.worklist.view.ParticipantTaskBrowser;
import org.openvpms.web.workspace.workflow.worklist.view.ParticipantTaskTableModel;

public class PatientViewLayoutStrategy
extends AbstractLayoutStrategy {
    protected void doTabLayout(IMObject object, List<Property> properties, IMObjectTabPaneModel model, LayoutContext context, boolean shortcuts) {
        super.doTabLayout(object, properties, model, context, shortcuts);
        Party patient = (Party)object;
        Browser<Act> appointments = this.getAppointments(patient, context);
        Browser<Act> tasks = this.getTasks(patient, context);
        this.addTab(Messages.get((String)"patient.information.appointments"), model, appointments.getComponent());
        this.addTab(Messages.get((String)"patient.information.tasks"), model, tasks.getComponent());
    }

    protected Browser<Act> getAppointments(Party patient, LayoutContext context) {
        ParticipantAppointmentTableModel model = new ParticipantAppointmentTableModel(false, context);
        return new ParticipantAppointmentBrowser(new PatientAppointmentQuery(patient), (IMTableModel<Act>)model, context);
    }

    protected Browser<Act> getTasks(Party patient, LayoutContext context) {
        ParticipantTaskTableModel model = new ParticipantTaskTableModel(false, context);
        return new ParticipantTaskBrowser(new PatientTaskQuery(patient), (IMTableModel<Act>)model, context);
    }
}

