/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.history;

import echopointng.BorderEx;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.bound.BoundTextComponentFactory;
import org.openvpms.web.component.im.query.ListResultSet;
import org.openvpms.web.component.im.query.QueryHelper;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.AbstractIMTableModel;
import org.openvpms.web.component.im.table.IMTable;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.button.CheckBox;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.CheckBoxFactory;
import org.openvpms.web.echo.popup.DropDown;
import org.openvpms.web.echo.table.DefaultTableCellRenderer;
import org.openvpms.web.echo.table.TableNavigator;
import org.openvpms.web.resource.i18n.Messages;

public class ProductTypeSelector
extends DropDown {
    private final Property text = new SimpleProperty("productType", String.class);
    private final ModifiableListener textListener = modifiable -> this.updateSelection();
    private final CheckBox all;
    private final PropertyChangeListener allListener = evt -> this.onAllChanged();
    private final PropertyChangeListener typeListener = evt -> this.onProductTypeChanged();
    private final List<Type> types;
    private final PagedIMTable<Type> pagedTable;
    private Runnable listener;
    private static final int SELECTED_INDEX = 0;
    private static final int PRODUCT_TYPE_INDEX = 1;

    public ProductTypeSelector() {
        Model model = new Model();
        this.pagedTable = new PagedIMTable((IMTableModel)model);
        this.setTarget((Component)BoundTextComponentFactory.create((Property)this.text, (int)20));
        this.setBorder((Border)BorderEx.NONE);
        this.setRolloverBorder((Border)BorderEx.NONE);
        this.setPopUpAlwaysOnTop(true);
        this.setFocusOnExpand(true);
        ArchetypeQuery query = new ArchetypeQuery("entity.productType");
        List productTypes = QueryHelper.query((ArchetypeQuery)query);
        this.all = CheckBoxFactory.create((boolean)true);
        ActionListener actionListener = new ActionListener(){

            public void onAction(ActionEvent event) {
            }
        };
        this.all.addActionListener((nextapp.echo2.app.event.ActionListener)actionListener);
        this.all.addPropertyChangeListener("selected", this.allListener);
        this.types = new ArrayList<Type>();
        this.types.add(new Type(Messages.get((String)"list.all"), this.all));
        for (Entity productType : productTypes) {
            CheckBox checkbox = CheckBoxFactory.create((boolean)false);
            checkbox.addPropertyChangeListener("selected", this.typeListener);
            checkbox.addActionListener((nextapp.echo2.app.event.ActionListener)actionListener);
            this.types.add(new Type(productType, checkbox));
        }
        IMTable table = this.pagedTable.getTable();
        table.setBorder(new Border(0, Color.WHITE, 0));
        table.setSelectionEnabled(true);
        table.setRolloverEnabled(false);
        table.setHeaderVisible(false);
        table.setDefaultRenderer(Object.class, DefaultTableCellRenderer.INSTANCE);
        table.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                ProductTypeSelector.this.onTableSelected();
            }
        });
        this.pagedTable.setResultSet((ResultSet)new ListResultSet(this.types, 20));
        this.setPopUp(this.pagedTable.getComponent());
        this.text.addModifiableListener(this.textListener);
    }

    public void setListener(Runnable listener) {
        this.listener = listener;
    }

    public boolean isAll() {
        return this.all.isSelected();
    }

    public List<Entity> getSelected() {
        return this.getProductTypes(this.isAll());
    }

    public void setSelected(Set<Reference> types) {
        Runnable runnable = this.listener;
        this.listener = null;
        if (types.isEmpty()) {
            this.all.setSelected(true);
        } else {
            for (int i = 1; i < this.types.size(); ++i) {
                Type type = this.types.get(i);
                boolean selected = types.contains(type.productType.getObjectReference());
                type.checkBox.setSelected(selected);
            }
        }
        this.listener = runnable;
    }

    private List<Entity> getProductTypes(boolean all) {
        ArrayList<Entity> result = new ArrayList<Entity>();
        for (Type productType : this.types) {
            if (productType.productType == null || !all && !productType.checkBox.isSelected()) continue;
            result.add(productType.productType);
        }
        return result;
    }

    private void onProductTypeChanged() {
        List<Entity> selected;
        int size;
        boolean selectAll;
        boolean bl = selectAll = !this.haveSelections();
        if (this.all.isSelected() != selectAll) {
            this.all.removePropertyChangeListener("selected", this.allListener);
            this.all.setSelected(selectAll);
            this.all.addPropertyChangeListener("selected", this.allListener);
        }
        if ((size = (selected = this.getProductTypes(false)).size()) == 1) {
            this.setText(selected.get(0).getName());
        } else if (size > 1) {
            this.setText(Messages.get((String)"patient.record.query.multipleproductype"));
        } else {
            this.setText(null);
        }
        this.notifyListener();
    }

    private boolean haveSelections() {
        for (Type productType : this.types) {
            if (productType.productType == null || !productType.checkBox.isSelected()) continue;
            return true;
        }
        return false;
    }

    private void onTableSelected() {
        this.setExpanded(false);
        IMTable table = this.pagedTable.getTable();
        int index = table.getSelectionModel().getMinSelectedIndex();
        if (index >= 0 && index < this.types.size()) {
            Type type = this.types.get(index);
            if (type.productType == null) {
                this.onAllChanged();
            } else {
                CheckBox checkBox = type.checkBox;
                if (!checkBox.isSelected()) {
                    checkBox.setSelected(true);
                    this.notifyListener();
                }
            }
        }
        table.getSelectionModel().clearSelection();
    }

    private void onAllChanged() {
        boolean changed = this.deselect();
        if (!this.all.isSelected()) {
            this.all.setSelected(true);
            changed = true;
        }
        this.setText(null);
        if (changed) {
            this.notifyListener();
        }
    }

    private void notifyListener() {
        if (this.listener != null) {
            try {
                this.listener.run();
            }
            catch (Throwable exception) {
                ErrorHelper.show((Throwable)exception);
            }
        }
    }

    private void setText(String value) {
        this.text.removeModifiableListener(this.textListener);
        this.text.setValue((Object)value);
        this.text.addModifiableListener(this.textListener);
    }

    private boolean setSelected(CheckBox checkbox, boolean selected) {
        boolean changed = false;
        if (checkbox.isSelected() != selected) {
            checkbox.removePropertyChangeListener("selected", this.typeListener);
            checkbox.setSelected(selected);
            checkbox.addPropertyChangeListener("selected", this.typeListener);
            changed = true;
        }
        return changed;
    }

    private boolean deselect() {
        boolean changed = false;
        List<Type> objects = this.types;
        for (int i = 1; i < objects.size(); ++i) {
            CheckBox checkBox = objects.get(i).checkBox;
            if (!this.setSelected(checkBox, false)) continue;
            changed = true;
        }
        return changed;
    }

    private void updateSelection() {
        String value = this.text.getString();
        String full = null;
        if (StringUtils.isBlank((CharSequence)value)) {
            this.onAllChanged();
        } else {
            boolean haveSelection;
            boolean changed = false;
            int selected = 0;
            value = value.toLowerCase();
            List<Type> objects = this.types;
            for (int i = 1; i < objects.size(); ++i) {
                boolean select;
                Type entry = objects.get(i);
                Entity type = entry.productType;
                if (type.getName() != null && type.getName().toLowerCase().contains(value)) {
                    select = true;
                    ++selected;
                    full = type.getName();
                } else {
                    select = false;
                }
                CheckBox checkBox = entry.checkBox;
                if (!this.setSelected(checkBox, select)) continue;
                changed = true;
            }
            boolean bl = haveSelection = selected != 0;
            if (this.all.isSelected() == haveSelection) {
                this.all.removePropertyChangeListener("selected", this.allListener);
                this.all.setSelected(!haveSelection);
                this.all.addPropertyChangeListener("selected", this.allListener);
            }
            if (selected == 1) {
                this.setText(full);
            } else if (selected > 1) {
                this.setText(Messages.get((String)"patient.record.query.multipleproductype"));
            }
            if (changed) {
                TableNavigator navigator = this.pagedTable.getNavigator();
                if (navigator != null) {
                    navigator.first();
                }
                this.notifyListener();
            }
        }
    }

    private static class Model
    extends AbstractIMTableModel<Type> {
        Model() {
            DefaultTableColumnModel model = new DefaultTableColumnModel();
            TableColumn selected = new TableColumn(0);
            selected.setWidth(new Extent(20));
            model.addColumn(selected);
            model.addColumn(new TableColumn(1));
            this.setTableColumnModel((TableColumnModel)model);
        }

        public SortConstraint[] getSortConstraints(int column, boolean ascending) {
            return null;
        }

        protected Object getValue(Type object, TableColumn column, int row) {
            if (column.getModelIndex() == 0) {
                return object.checkBox;
            }
            if (column.getModelIndex() == 1) {
                return object.name;
            }
            return null;
        }
    }

    private static class Type {
        private final Entity productType;
        private final CheckBox checkBox;
        private final String name;

        Type(Entity productType, CheckBox checkBox) {
            this.productType = productType;
            this.checkBox = checkBox;
            this.name = productType.getName();
        }

        Type(String name, CheckBox checkBox) {
            this.productType = null;
            this.checkBox = checkBox;
            this.name = name;
        }
    }
}

