/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.history;

import java.util.Date;
import java.util.Objects;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.patient.MedicalRecordRules;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.hl7.patient.PatientContext;
import org.openvpms.hl7.patient.PatientContextFactory;
import org.openvpms.hl7.patient.PatientInformationService;
import org.openvpms.smartflow.client.FlowSheetServiceFactory;
import org.openvpms.smartflow.client.HospitalizationService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.print.IMObjectReportPrinter;
import org.openvpms.web.component.im.print.IMPrinter;
import org.openvpms.web.component.im.print.IMPrinterFactory;
import org.openvpms.web.component.im.print.InteractiveIMPrinter;
import org.openvpms.web.component.im.report.ContextDocumentTemplateLocator;
import org.openvpms.web.component.im.report.DocumentTemplateLocator;
import org.openvpms.web.component.im.util.IMObjectCreator;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.print.Printer;
import org.openvpms.web.component.retry.Retryable;
import org.openvpms.web.component.retry.Retryer;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.communication.AbstractCommunicationEditor;
import org.openvpms.web.workspace.patient.PatientMedicalRecordLinker;
import org.openvpms.web.workspace.patient.history.AbstractPatientHistoryCRUDWindow;
import org.openvpms.web.workspace.patient.history.FlowSheetReportsDialog;
import org.openvpms.web.workspace.patient.history.PatientHistoryActions;
import org.openvpms.web.workspace.patient.history.PatientHistoryFilter;
import org.openvpms.web.workspace.patient.history.PatientHistoryIterator;
import org.openvpms.web.workspace.patient.history.PatientHistoryQuery;
import org.openvpms.web.workspace.patient.history.TextSearch;
import org.openvpms.web.workspace.patient.info.PatientContextHelper;
import org.openvpms.web.workspace.patient.mr.PatientVisitNoteEditDialog;
import org.openvpms.web.workspace.patient.mr.PatientVisitNoteEditor;

public class PatientHistoryCRUDWindow
extends AbstractPatientHistoryCRUDWindow {
    public static final Archetypes<Act> LOG_ARCHETYPES = Archetypes.create((String)"act.customerCommunication*", Act.class, (String)Messages.get((String)"customer.communication.createtype"));
    private final MedicalRecordRules rules = (MedicalRecordRules)ServiceHelper.getBean(MedicalRecordRules.class);
    private final FlowSheetServiceFactory flowSheetServiceFactory = (FlowSheetServiceFactory)ServiceHelper.getBean(FlowSheetServiceFactory.class);
    private PatientHistoryQuery query;
    private static final String LOG_ID = "button.log";
    private static final String IMPORT_FLOWSHEET_ID = "button.importFlowSheet";

    public PatientHistoryCRUDWindow(Context context, HelpContext help) {
        this((Archetypes<Act>)Archetypes.create((String)"act.patientClinicalEvent", Act.class, (String)Messages.get((String)"patient.record.createtype")), context, help);
    }

    public PatientHistoryCRUDWindow(Archetypes<Act> archetypes, Context context, HelpContext help) {
        super(archetypes, PatientHistoryActions.INSTANCE, context, help);
    }

    protected PatientHistoryCRUDWindow(Context context, PatientHistoryActions actions, HelpContext help) {
        super((Archetypes<Act>)Archetypes.create((String)"act.patientClinicalEvent", Act.class, (String)Messages.get((String)"patient.record.createtype")), actions, context, help);
    }

    @Override
    public void setEvent(Act event) {
        super.setEvent(event);
        this.getContext().setObject("act.patientClinicalEvent", (IMObject)event);
    }

    public void setQuery(PatientHistoryQuery query) {
        this.query = query;
    }

    public void addVisitAndNote() {
        Act existing = this.rules.getEvent(this.getContext().getPatient());
        if (existing == null || !"IN_PROGRESS".equals(existing.getStatus())) {
            Act event = (Act)IMObjectCreator.create((String)"act.patientClinicalEvent");
            event.setStatus("COMPLETED");
            event.setActivityEndTime(new Date());
            HelpContext help = this.getHelpContext().subtopic("visitnote");
            LayoutContext layoutContext = this.createLayoutContext(help);
            PatientVisitNoteEditor editor = new PatientVisitNoteEditor(event, layoutContext);
            this.edit((IMObjectEditor)editor, null);
        } else {
            this.notifyVisitExists(existing);
        }
    }

    @Override
    protected void layoutButtons(ButtonSet buttons) {
        super.layoutButtons(buttons);
        buttons.add(this.createAddNoteButton());
        Preferences preferences = ServiceHelper.getPreferences();
        if (preferences.getBoolean("entity.preferenceGroupHistory", "showCommunications", false)) {
            buttons.add(LOG_ID, () -> this.onCreate(LOG_ARCHETYPES));
        }
        buttons.add(this.createMarkReviewedButton());
        buttons.add(this.createUnmarkReviewedButton());
        buttons.add(this.createExternalEditButton());
        buttons.add(this.createImportFlowSheetButton());
    }

    @Override
    protected void enableButtons(ButtonSet buttons, boolean enable) {
        super.enableButtons(buttons, enable);
        this.enablePrintPreview(buttons, enable);
        Act event = this.getEvent();
        Party location = this.getContext().getLocation();
        boolean importFlowSheet = enable && this.getActions().canImportFlowSheet(event, location, this.flowSheetServiceFactory);
        buttons.setEnabled(IMPORT_FLOWSHEET_ID, importFlowSheet);
    }

    protected void onCreate(Archetypes<Act> archetypes) {
        if (archetypes != LOG_ARCHETYPES && this.getEvent() != null) {
            boolean includeAddendum = false;
            String defaultShortName = "act.patientClinicalNote";
            Act selected = (Act)this.getObject();
            if (TypeHelper.isA((IMObject)selected, (String[])new String[]{"act.patientClinicalNote", "act.patientMedication"})) {
                includeAddendum = true;
                if (this.getActions().isLocked(selected)) {
                    defaultShortName = "act.patientClinicalAddendum";
                }
            }
            String[] shortNames = this.getShortNames("actRelationship.patientClinicalEventItem", includeAddendum, "act.patientClinicalEvent");
            archetypes = new Archetypes(shortNames, archetypes.getType(), defaultShortName, archetypes.getDisplayName());
        }
        super.onCreate(archetypes);
    }

    @Override
    protected void onCreated(Act object) {
        if (object.isA("act.patientClinicalEvent")) {
            Act existing = this.rules.getEvent(this.getContext().getPatient());
            if (existing == null || !"IN_PROGRESS".equals(existing.getStatus())) {
                super.onCreated(object);
            } else {
                this.notifyVisitExists(existing);
            }
        } else {
            super.onCreated(object);
        }
    }

    protected IMObjectEditor createEditor(Act object, LayoutContext context) {
        IMObjectEditor editor = super.createEditor((IMObject)object, context);
        if (editor instanceof AbstractCommunicationEditor) {
            ((AbstractCommunicationEditor)editor).setShowPatient(false);
        }
        return editor;
    }

    protected void onSaved(Act act, boolean isNew) {
        if (act.isA("act.patientClinicalEvent")) {
            this.setEvent(act);
        } else if (act.isA("act.patientWeight")) {
            this.onWeightChanged(act);
        }
        super.onSaved((IMObject)act, isNew);
    }

    protected void onDeleted(Act object) {
        if (object.isA("act.patientClinicalEvent")) {
            this.setEvent(null);
        }
        super.onDeleted((IMObject)object);
        if (object.isA("act.patientWeight")) {
            this.onWeightChanged(object);
        }
    }

    protected void onPrint() {
        if (this.query != null) {
            Context context = this.getContext();
            IMObjectReportPrinter<Act> printer = this.createPrinter(context);
            String title = Messages.get((String)"patient.record.summary.print");
            HelpContext help = this.getHelpContext().topic("act.patientClinicalEvent/print");
            InteractiveIMPrinter iPrinter = new InteractiveIMPrinter(title, printer, context, help);
            iPrinter.setMailContext(this.getMailContext());
            iPrinter.print();
        }
    }

    protected void onPreview() {
        if (this.query != null) {
            Context context = this.getContext();
            IMObjectReportPrinter<Act> printer = this.createPrinter(context);
            this.preview((Printer)printer);
        }
    }

    protected void onMail() {
        if (this.query != null) {
            Context context = this.getContext();
            IMObjectReportPrinter<Act> printer = this.createPrinter(context);
            this.mail((IMPrinter)printer);
        }
    }

    protected EditDialog createEditDialog(IMObjectEditor editor) {
        EditDialog dialog = editor instanceof PatientVisitNoteEditor ? new PatientVisitNoteEditDialog((PatientVisitNoteEditor)editor, this.getContext()) : super.createEditDialog(editor);
        if (!editor.getObject().isA("act.customerCommunication*")) {
            dialog.setPostSaveCallback(e -> this.linkRecords((Act)e.getObject()));
        }
        return dialog;
    }

    protected void linkRecords(Act act) {
        if (!act.isA("act.patientClinicalEvent")) {
            Act event = this.getEvent();
            if (event == null) {
                event = this.createEvent();
            }
            Act selected = (Act)this.getObject();
            PatientMedicalRecordLinker linker = act.isA("act.patientClinicalAddendum") ? (selected != null && !selected.isA("act.patientClinicalAddendum") ? this.createMedicalRecordLinker(event, null, selected, act) : this.createMedicalRecordLinker(event, null, null, act)) : this.createMedicalRecordLinker(event, act);
            Retryer.run((Retryable)linker);
        }
    }

    protected void onWeightChanged(Act act) {
        Act event = this.getEvent();
        PatientContext context = PatientContextHelper.getPatientContext(act, this.getContext());
        if (context != null && Objects.equals(event, context.getVisit())) {
            PatientInformationService service = (PatientInformationService)ServiceHelper.getBean(PatientInformationService.class);
            service.updated(context);
        }
    }

    private void notifyVisitExists(Act existing) {
        String date = DateFormatter.formatDate((Date)existing.getActivityStartTime(), (boolean)false);
        InformationDialog.show((String)Messages.get((String)"patient.record.summary.visitexists.title"), (String)Messages.format((String)"patient.record.summary.visitexists.message", (Object[])new Object[]{date}));
    }

    private Button createAddNoteButton() {
        return ButtonFactory.create((String)"addNote", this::addVisitAndNote);
    }

    private Button createImportFlowSheetButton() {
        return ButtonFactory.create((String)IMPORT_FLOWSHEET_ID, this::onImportFlowSheet);
    }

    private IMObjectReportPrinter<Act> createPrinter(Context context) {
        String value = this.query.getValue();
        TextSearch search = null;
        Preferences preferences = ServiceHelper.getPreferences();
        if (!StringUtils.isEmpty((CharSequence)value)) {
            boolean showClinician = preferences.getBoolean("entity.preferenceGroupHistory", "showClinician", false);
            boolean showBatches = preferences.getBoolean("entity.preferenceGroupHistory", "showBatches", false);
            search = new TextSearch(value, showClinician, showBatches, (IArchetypeService)ServiceHelper.getArchetypeService());
        }
        PatientHistoryQuery reportQuery = new PatientHistoryQuery(context.getPatient(), this.query.getIncludeCharges(), false, this.query.getSortHistoryAscending());
        reportQuery.getComponent();
        reportQuery.setAvailableArchetypes(this.query.getAvailableArchetypes());
        reportQuery.setSelectedArchetypes(this.query.getSelectedArchetypes());
        reportQuery.setSortAscending(this.query.isSortAscending());
        reportQuery.setProductTypes(this.query.getProductTypes());
        reportQuery.setAllDates(this.query.getAllDates());
        reportQuery.setFrom(this.query.getFrom());
        reportQuery.setTo(this.query.getTo());
        PatientHistoryFilter filter = new PatientHistoryFilter(reportQuery.getSelectedArchetypes(), search, true, (ArchetypeService)this.getService());
        PatientHistoryIterator summary = new PatientHistoryIterator((Iterable<Act>)((Object)reportQuery), filter, 3);
        ContextDocumentTemplateLocator locator = new ContextDocumentTemplateLocator("act.patientClinicalEvent", context);
        IMPrinterFactory printerFactory = (IMPrinterFactory)ServiceHelper.getBean(IMPrinterFactory.class);
        return printerFactory.createIMObjectReportPrinter((Iterable)((Object)summary), (DocumentTemplateLocator)locator, context);
    }

    private void onImportFlowSheet() {
        final Act visit = (Act)IMObjectHelper.reload((IMObject)this.getEvent());
        if (visit != null) {
            Party location = this.getContext().getLocation();
            PatientContext context = ((PatientContextFactory)ServiceHelper.getBean(PatientContextFactory.class)).createContext(visit, location);
            if (context != null) {
                FlowSheetServiceFactory factory = (FlowSheetServiceFactory)ServiceHelper.getBean(FlowSheetServiceFactory.class);
                HospitalizationService service = factory.getHospitalizationService(location);
                if (service.exists(context)) {
                    FlowSheetReportsDialog dialog = new FlowSheetReportsDialog(context);
                    dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

                        public void onClose(WindowPaneEvent event) {
                            PatientHistoryCRUDWindow.this.onRefresh((IMObject)visit);
                        }
                    });
                    dialog.show();
                } else {
                    InformationDialog.show((String)Messages.format((String)"patient.record.flowsheet.import.nohospitalisation", (Object[])new Object[]{context.getPatient().getName()}));
                }
            }
        }
    }
}

