/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.history;

import org.joda.time.Period;
import org.openvpms.archetype.rules.patient.MedicalRecordRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.smartflow.client.FlowSheetServiceFactory;
import org.openvpms.web.component.im.edit.ActActions;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.system.ServiceHelper;

public class PatientHistoryActions
extends ActActions<Act> {
    public static final PatientHistoryActions INSTANCE = new PatientHistoryActions();
    private final String[] DOCUMENTS = new String[]{"act.patientDocumentAttachment", "act.patientDocumentAttachmentVersion", "act.patientDocumentForm", "act.patientDocumentLetter", "act.patientDocumentLetterVersion", "act.patientDocumentImage", "act.patientDocumentImageVersion"};

    protected PatientHistoryActions() {
    }

    public boolean canEdit(Act act) {
        return !TypeHelper.isA((IMObject)act, (String)"act.customerAccountInvoiceItem") && (super.canEdit(act) || TypeHelper.isA((IMObject)act, (String)"act.patientInvestigation"));
    }

    public boolean canDelete(Act act) {
        if (!super.canDelete(act)) {
            return false;
        }
        if (TypeHelper.isA((IMObject)act, (String)"act.customerAccountInvoiceItem")) {
            return false;
        }
        if (TypeHelper.isA((IMObject)act, (String[])new String[]{"act.patientClinicalEvent", "act.patientClinicalProblem", "act.patientClinicalNote"})) {
            return act.getSourceActRelationships().isEmpty();
        }
        if (TypeHelper.isA((IMObject)act, (String[])this.DOCUMENTS)) {
            return true;
        }
        for (Relationship rel : act.getTargetActRelationships()) {
            if (!rel.getSource().isA("act.customerAccountInvoiceItem")) continue;
            return false;
        }
        return true;
    }

    public boolean canPost(Act act) {
        return !TypeHelper.isA((IMObject)act, (String)"act.customerAccountInvoiceItem") && super.canPost(act);
    }

    public boolean canReview(Act object) {
        boolean result = false;
        if (object.isA("act.patientInvestigation")) {
            String orderStatus = object.getStatus2();
            result = "RECEIVED".equals(orderStatus) || "PARTIAL_RESULTS".equals(orderStatus);
        }
        return result;
    }

    public boolean review(Act object) {
        boolean result = false;
        if (this.canReview(object)) {
            object.setStatus2("REVIEWED");
            SaveHelper.save((IMObject)object);
            result = true;
        }
        return result;
    }

    public boolean canUnreview(Act object) {
        boolean result = false;
        if (object.isA("act.patientInvestigation")) {
            String orderStatus = object.getStatus2();
            result = "REVIEWED".equals(orderStatus);
        }
        return result;
    }

    public boolean unreview(Act object) {
        boolean result = false;
        if (this.canUnreview(object)) {
            object.setStatus2("RECEIVED");
            SaveHelper.save((IMObject)object);
            result = true;
        }
        return result;
    }

    public boolean canImportFlowSheet(Act event, Party location, FlowSheetServiceFactory factory) {
        return event != null && factory.isSmartFlowSheetEnabled(location);
    }

    public boolean isLocked(Act act) {
        return super.isLocked(act) || PatientHistoryActions.needsLock(act);
    }

    public static boolean needsLock(Act act) {
        MedicalRecordRules recordRules = (MedicalRecordRules)ServiceHelper.getBean(MedicalRecordRules.class);
        PracticeService practiceService = (PracticeService)ServiceHelper.getBean(PracticeService.class);
        Period period = practiceService.getRecordLockPeriod();
        return period != null && recordRules.needsLock(act, period);
    }
}

