/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.history;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.event.ActionEvent;
import org.apache.commons.lang.StringUtils;
import org.openvpms.hl7.patient.PatientContext;
import org.openvpms.smartflow.client.FlowSheetException;
import org.openvpms.smartflow.client.FlowSheetServiceFactory;
import org.openvpms.smartflow.client.HospitalizationService;
import org.openvpms.smartflow.i18n.FlowSheetMessages;
import org.openvpms.smartflow.model.Anesthetic;
import org.openvpms.smartflow.model.Anesthetics;
import org.openvpms.smartflow.model.DentalChart;
import org.openvpms.smartflow.model.DentalCharts;
import org.openvpms.smartflow.model.Form;
import org.openvpms.web.echo.button.CheckBox;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.error.ErrorHandler;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.CheckBoxFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class FlowSheetReportsDialog
extends PopupDialog {
    private final PatientContext context;
    private final List<Form> forms;
    private final List<Anesthetic> anesthetics;
    private final List<DentalChart> dentalCharts;
    private final CheckBox medicalRecordsCheckBox;
    private final CheckBox billingCheckBox;
    private final CheckBox notesCheckBox;
    private final CheckBox flowSheetCheckBox;
    private final CheckBox formsCheckBox;
    private final CheckBox anestheticsCheckBox;
    private final CheckBox dentalCheckBox;
    private HospitalizationService service;

    public FlowSheetReportsDialog(PatientContext context) {
        this(context, false);
    }

    public FlowSheetReportsDialog(PatientContext context, boolean skip) {
        super(Messages.get((String)"patient.record.flowsheet.import.title"), "MessageDialog", skip ? OK_SKIP : OK_CANCEL);
        this.setModal(true);
        this.context = context;
        FlowSheetServiceFactory factory = (FlowSheetServiceFactory)ServiceHelper.getBean(FlowSheetServiceFactory.class);
        this.service = factory.getHospitalizationService(context.getLocation());
        this.forms = this.getForms(context);
        this.anesthetics = this.getAnesthetics(context);
        this.dentalCharts = this.getDentalCharts(context);
        ActionListener listener = new ActionListener(){

            public void onAction(ActionEvent event) {
                boolean enable = FlowSheetReportsDialog.this.medicalRecordsCheckBox.isSelected() || FlowSheetReportsDialog.this.billingCheckBox.isSelected() || FlowSheetReportsDialog.this.notesCheckBox.isSelected() || FlowSheetReportsDialog.this.flowSheetCheckBox.isSelected() || FlowSheetReportsDialog.this.formsCheckBox.isSelected() || FlowSheetReportsDialog.this.anestheticsCheckBox.isSelected() || FlowSheetReportsDialog.this.dentalCheckBox.isSelected();
                FlowSheetReportsDialog.this.getButtons().setEnabled("ok", enable);
            }
        };
        this.medicalRecordsCheckBox = this.createCheckBox(FlowSheetMessages.medicalRecordsReportName(), listener);
        this.billingCheckBox = this.createCheckBox(FlowSheetMessages.billingReportName(), listener);
        this.notesCheckBox = this.createCheckBox(FlowSheetMessages.notesReportName(), listener);
        this.flowSheetCheckBox = this.createCheckBox(FlowSheetMessages.flowSheetReportName(), listener);
        this.formsCheckBox = this.createCheckBox(Messages.get((String)"patient.record.flowsheet.import.forms"), listener);
        if (this.forms.isEmpty()) {
            this.formsCheckBox.setSelected(false);
            this.formsCheckBox.setEnabled(false);
        }
        this.anestheticsCheckBox = this.createCheckBox(FlowSheetMessages.anaestheticReportName(), listener);
        if (this.anesthetics.isEmpty()) {
            this.anestheticsCheckBox.setSelected(false);
            this.anestheticsCheckBox.setEnabled(false);
        }
        this.dentalCheckBox = this.createCheckBox(FlowSheetMessages.dentalReportName(), listener);
        if (this.dentalCharts.isEmpty()) {
            this.dentalCheckBox.setSelected(false);
            this.dentalCheckBox.setEnabled(false);
        }
        this.resize();
    }

    protected void resize() {
        this.resize("FlowSheetReportsDialog.size");
    }

    protected void onOK() {
        try {
            if (this.medicalRecordsCheckBox.isSelected()) {
                this.service.saveMedicalRecords(this.context);
            }
            if (this.billingCheckBox.isSelected()) {
                this.service.saveBillingReport(this.context);
            }
            if (this.notesCheckBox.isSelected()) {
                this.service.saveNotesReport(this.context);
            }
            if (this.flowSheetCheckBox.isSelected()) {
                this.service.saveFlowSheetReport(this.context);
            }
            if (this.formsCheckBox.isSelected()) {
                for (Form form : this.forms) {
                    this.service.saveFormReport(this.context, form);
                }
            }
            if (this.anestheticsCheckBox.isSelected()) {
                for (Anesthetic anesthetic : this.anesthetics) {
                    this.service.saveAnestheticReports(this.context, anesthetic);
                }
            }
            if (this.dentalCheckBox.isSelected()) {
                for (DentalChart chart : this.dentalCharts) {
                    this.service.saveDentalReport(this.context, chart);
                }
            }
            super.onOK();
        }
        catch (FlowSheetException exception) {
            ErrorHandler.getInstance().error(exception.getMessage(), (Throwable)exception);
        }
    }

    protected void doLayout() {
        Label label = LabelFactory.create((String)"patient.record.flowsheet.import.message", (String)"bold");
        Column column = ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{label, this.medicalRecordsCheckBox, this.billingCheckBox, this.notesCheckBox, this.flowSheetCheckBox, this.formsCheckBox, this.anestheticsCheckBox, this.dentalCheckBox});
        this.getLayout().add((Component)ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{column}));
    }

    private List<Anesthetic> getAnesthetics(PatientContext context) {
        List result = Collections.emptyList();
        Anesthetics anesthetics = this.service.getAnesthetics(context.getPatient(), context.getVisit());
        if (anesthetics.getAnesthetics() != null) {
            result = anesthetics.getAnesthetics();
        }
        return result;
    }

    private List<DentalChart> getDentalCharts(PatientContext context) {
        List<DentalChart> result = Collections.emptyList();
        DentalCharts charts = this.service.getDentalCharts(context.getPatient(), context.getVisit());
        if (charts.getDentalCharts() != null) {
            result = new ArrayList<DentalChart>();
            for (DentalChart chart : charts.getDentalCharts()) {
                if (StringUtils.isEmpty((String)chart.getReportPath())) continue;
                result.add(chart);
            }
        }
        return result;
    }

    private List<Form> getForms(PatientContext context) {
        ArrayList<Form> result = new ArrayList<Form>();
        List forms = this.service.getForms(context.getPatient(), context.getVisit());
        for (Form form : forms) {
            if (form.isDeleted() || !form.isFinalized()) continue;
            result.add(form);
        }
        return result;
    }

    private CheckBox createCheckBox(String text, ActionListener listener) {
        CheckBox checkBox = CheckBoxFactory.create((boolean)true);
        checkBox.setText(text);
        checkBox.addActionListener((nextapp.echo2.app.event.ActionListener)listener);
        return checkBox;
    }
}

