/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.history;

import echopointng.LabelEx;
import echopointng.xhtml.XhtmlFragment;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Command;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.HttpImageReference;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.layout.RowLayoutData;
import nextapp.echo2.app.layout.TableLayoutData;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import nextapp.echo2.webcontainer.command.BrowserOpenWindowCommand;
import org.apache.commons.jxpath.FunctionLibrary;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openvpms.archetype.function.factory.ArchetypeFunctionsFactory;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.business.service.archetype.CachingReadOnlyArchetypeService;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.cache.IMObjectCache;
import org.openvpms.component.system.common.cache.LRUIMObjectCache;
import org.openvpms.component.system.common.jxpath.JXPathHelper;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ContextSwitchListener;
import org.openvpms.web.component.im.doc.DocumentViewer;
import org.openvpms.web.component.im.doc.DocumentViewerFactory;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.table.AbstractIMObjectTableModel;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.im.util.IMObjectNames;
import org.openvpms.web.component.im.util.LookupNameHelper;
import org.openvpms.web.component.im.view.IMObjectReferenceViewer;
import org.openvpms.web.component.im.view.IMObjectViewerDialog;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.util.StyleSheetHelper;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public abstract class AbstractPatientHistoryTableModel
extends AbstractIMObjectTableModel<Act> {
    protected static final int DEFAULT_CACHE_SIZE = 100;
    protected static final String SELECTED_ICON = "../images/navigation/next.png";
    private final String parentArchetype;
    private final LayoutContext context;
    private final PatientRules patientRules;
    private final boolean showClinician;
    private final boolean showBatches;
    private final IArchetypeService service;
    private final FunctionLibrary functions;
    private final IMObjectCache cache;
    private final IMObjectNames names;
    private final DocumentViewerFactory viewerFactory;
    private int selectedParent;
    private Map<String, String> expressions = new HashMap<String, String>();
    private int typePadding = -1;
    private int typeWidth = -1;
    private int clinicianWidth = -1;
    private ContextSwitchListener batchViewer;
    private static final int DEFAULT_WIDTH = 150;
    private static final int SELECTION_COLUMN = 0;
    private static final int SUMMARY_COLUMN = 1;
    private static final int SPACER_COLUMN = 2;
    private static final Log log = LogFactory.getLog(AbstractPatientHistoryTableModel.class);

    public AbstractPatientHistoryTableModel(String parentArchetype, LayoutContext context, int cacheSize) {
        this.parentArchetype = parentArchetype;
        this.context = context;
        this.patientRules = (PatientRules)ServiceHelper.getBean(PatientRules.class);
        DefaultTableColumnModel model = new DefaultTableColumnModel();
        model.addColumn(new TableColumn(0, new Extent(16)));
        model.addColumn(new TableColumn(1));
        model.addColumn(new TableColumn(2));
        this.setTableColumnModel((TableColumnModel)model);
        Preferences preferences = context.getPreferences();
        this.showClinician = preferences.getBoolean("entity.preferenceGroupHistory", "showClinician", false);
        this.showBatches = preferences.getBoolean("entity.preferenceGroupHistory", "showBatches", false);
        ArchetypeFunctionsFactory factory = (ArchetypeFunctionsFactory)ServiceHelper.getBean(ArchetypeFunctionsFactory.class);
        IArchetypeRuleService archetypeService = ServiceHelper.getArchetypeService();
        this.cache = new LRUIMObjectCache(cacheSize, (ArchetypeService)archetypeService);
        this.names = new IMObjectNames(this.cache, (IArchetypeService)archetypeService, cacheSize);
        this.service = new CachingReadOnlyArchetypeService(this.cache, (IArchetypeService)archetypeService);
        this.functions = factory.create(this.service, true);
        this.viewerFactory = (DocumentViewerFactory)ServiceHelper.getBean(DocumentViewerFactory.class);
        this.initStyles();
    }

    public void setObjects(List<Act> objects) {
        this.selectedParent = -1;
        super.setObjects(objects);
    }

    public String getParentArchetype() {
        return this.parentArchetype;
    }

    public void setSelectedParent(int row) {
        if (this.selectedParent != row) {
            if (this.selectedParent != -1) {
                this.fireTableCellUpdated(0, this.selectedParent);
            }
            this.selectedParent = row;
            this.fireTableCellUpdated(0, row);
        }
    }

    public int getSelectedParent() {
        return this.selectedParent;
    }

    public void setExpressions(Map<String, String> expressions) {
        this.expressions = expressions;
    }

    public Map<String, String> getExpressions() {
        return this.expressions;
    }

    public SortConstraint[] getSortConstraints(int column, boolean ascending) {
        return null;
    }

    public Act getParent(Act act) {
        return act != null ? this.getParent(act, this.parentArchetype) : null;
    }

    public Act getParent(Act act, String archetype) {
        List acts = this.getObjects();
        int index = acts.indexOf(act);
        return this.getParent(archetype, index);
    }

    public boolean showClinician() {
        return this.showClinician;
    }

    public boolean showBatches() {
        return this.showBatches;
    }

    public void postRender() {
        super.postRender();
        this.cache.clear();
        this.names.clear();
    }

    protected LayoutContext getContext() {
        return this.context;
    }

    protected Object getValue(Act act, TableColumn column, int row) {
        Component result = null;
        IMObjectBean bean = this.service.getBean((IMObject)act);
        switch (column.getModelIndex()) {
            case 0: {
                if (row != this.selectedParent) break;
                result = this.getSelectionIndicator();
                break;
            }
            case 1: {
                try {
                    if (act.isA(this.parentArchetype)) {
                        result = this.formatParent(bean);
                        break;
                    }
                    if (act.isA(new String[]{"act.customerCommunication*", "act.smsMessage", "act.smsReply"})) {
                        result = this.formatCommunication(bean, row);
                        break;
                    }
                    result = this.formatItem(bean, row, this.showClinician);
                    break;
                }
                catch (OpenVPMSException exception) {
                    ErrorHelper.show((Throwable)exception);
                }
            }
        }
        return result;
    }

    protected abstract Component formatParent(IMObjectBean var1);

    protected String formatDateRange(IMObjectBean bean) {
        Date startTime = bean.getDate("startTime");
        Date endTime = bean.getDate("endTime");
        String text = endTime == null ? Messages.format((String)"patient.record.summary.singleDate", (Object[])new Object[]{startTime}) : (DateRules.dateEquals((Date)startTime, (Date)endTime) ? Messages.format((String)"patient.record.summary.dateRangeSameDay", (Object[])new Object[]{startTime, endTime}) : Messages.format((String)"patient.record.summary.dateRange", (Object[])new Object[]{startTime, endTime}));
        return text;
    }

    protected String formatParentText(IMObjectBean bean, String reason) {
        Act act = (Act)bean.getObject(Act.class);
        if (StringUtils.isEmpty((CharSequence)reason)) {
            reason = Messages.get((String)"patient.record.summary.reason.none");
        }
        String status = LookupNameHelper.getName((IMObject)act, (String)"status");
        String clinician = this.getClinician(bean);
        String age = this.getAge(bean);
        return Messages.format((String)"patient.record.summary.title", (Object[])new Object[]{reason, clinician, status, age});
    }

    protected String formatEventText(IMObjectBean bean) {
        Act act = (Act)bean.getObject(Act.class);
        String reason = this.getReason(act);
        String title = act.getTitle();
        if (!StringUtils.isEmpty((CharSequence)reason) && !StringUtils.isEmpty((CharSequence)title)) {
            String text = reason + " - " + title;
            return this.formatParentText(bean, text);
        }
        if (!StringUtils.isEmpty((CharSequence)reason)) {
            return this.formatParentText(bean, reason);
        }
        if (!StringUtils.isEmpty((CharSequence)title)) {
            return this.formatParentText(bean, title);
        }
        return this.formatParentText(bean, null);
    }

    protected String getReason(Act act) {
        return LookupNameHelper.getName((IMObject)act, (String)"reason");
    }

    protected Component formatItem(IMObjectBean bean, int row, boolean showClinician) {
        Act act = (Act)bean.getObject(Act.class);
        Component date = this.getDate(act, row);
        Component type = this.getType(bean);
        Component clinician = showClinician ? this.getClinicianLabel(bean, row) : null;
        RowLayoutData layout = new RowLayoutData();
        layout.setAlignment(new Alignment(0, 6));
        date.setLayoutData((LayoutData)layout);
        type.setLayoutData((LayoutData)layout);
        if (clinician != null) {
            clinician.setLayoutData((LayoutData)layout);
        }
        Component detail = this.formatItem(bean);
        Row padding = RowFactory.create((String)"Inset", (Component[])new Component[]{new Label("")});
        Row item = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{padding, date, type});
        if (clinician != null) {
            item.add(clinician);
        }
        item.add(detail);
        return item;
    }

    protected Component formatItem(IMObjectBean bean) {
        if (bean.isA(new String[]{"act.patientMedication"})) {
            return this.getMedicationDetail(bean, this.showBatches);
        }
        if (bean.isA(new String[]{"act.patientInvestigation*"}) || bean.isA(new String[]{"act.patientDocument*"})) {
            return this.getDocumentDetail((DocumentAct)bean.getObject(DocumentAct.class));
        }
        if (bean.isA(new String[]{"act.patientClinicalLink"})) {
            return this.getLink(bean);
        }
        return this.getTextDetail((Act)bean.getObject(Act.class));
    }

    protected Component getType(IMObjectBean bean) {
        String text = this.getTypeName(bean);
        LabelEx label = new LabelEx(text);
        label.setStyleName("MedicalRecordSummary.type");
        int depth = this.getDepth(bean);
        LabelEx result = label;
        if (depth > 0) {
            int inset = depth * this.typePadding;
            label.setInsets(new Insets(inset, 0, 0, 0));
            label.setWidth(new Extent(this.typeWidth - inset));
        }
        return result;
    }

    protected Component getHyperlinkedType(IMObjectBean bean) {
        LayoutContext context = this.getContext();
        IMObjectReferenceViewer viewer = new IMObjectReferenceViewer(bean.getObject().getObjectReference(), this.getTypeName(bean), context.getContextSwitchListener(), context.getContext());
        viewer.setWidth(this.typeWidth);
        return viewer.getComponent();
    }

    protected String getTypeName(IMObjectBean bean) {
        return bean.getDisplayName();
    }

    protected int getDepth(IMObjectBean bean) {
        int depth = 0;
        if (bean.isA(new String[]{"act.patientDocument*Version"}) || bean.isA(new String[]{"act.patientInvestigationVersion"})) {
            ++depth;
        }
        if (bean.hasNode("problem") && !bean.getSourceRefs("problem").isEmpty()) {
            ++depth;
        }
        return depth;
    }

    protected String getAge(IMObjectBean bean) {
        Act act = (Act)bean.getObject(Act.class);
        Party patient = (Party)IMObjectHelper.getObject((Reference)bean.getTargetRef("patient"), (Context)this.context.getContext());
        return patient != null ? this.patientRules.getPatientAge(patient, act.getActivityStartTime()) : "";
    }

    protected Component getClinicianLabel(IMObjectBean bean, int row) {
        String clinician = this.getClinician(bean);
        String content = "<div xmlns='http://www.w3.org/1999/xhtml' style='width:" + this.clinicianWidth + "px; overflow:hidden'>" + clinician + "</div>";
        LabelEx label = new LabelEx(new XhtmlFragment(content));
        label.setStyleName("MedicalRecordSummary.clinician");
        return label;
    }

    protected String getName(Reference reference) {
        return this.names.getName(reference);
    }

    protected String getClinician(IMObjectBean bean) {
        String clinician = this.getName(bean.getTargetRef("clinician"));
        if (StringUtils.isEmpty((CharSequence)clinician)) {
            clinician = Messages.get((String)"patient.record.summary.clinician.none");
        }
        return clinician;
    }

    protected Component getMedicationDetail(IMObjectBean bean, boolean showBatches) {
        Label component = this.getTextDetail((Act)bean.getObject(Act.class));
        if (showBatches) {
            component = this.addBatch(bean, (Component)component);
        }
        return component;
    }

    protected Component addBatch(IMObjectBean bean, Component medication) {
        Component batch;
        Object result = this.showBatches ? ((batch = this.getBatch(bean)) != null ? ColumnFactory.create((String)"CellSpacing", (Component[])new Component[]{medication, batch}) : medication) : medication;
        return result;
    }

    protected Component getBatch(IMObjectBean bean) {
        Row result = null;
        Reference reference = bean.getTargetRef("batch");
        if (reference != null) {
            if (this.batchViewer == null) {
                this.batchViewer = new ContextSwitchListener(){

                    public void switchTo(IMObject object) {
                        AbstractPatientHistoryTableModel.this.onShowBatch(object);
                    }

                    public void switchTo(String shortName) {
                    }
                };
            }
            IMObjectReferenceViewer viewer = new IMObjectReferenceViewer(reference, this.batchViewer, this.getContext().getContext());
            result = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{LabelFactory.create((String)"patient.record.summary.batch"), viewer.getComponent()});
        }
        return result;
    }

    protected Component getDocumentDetail(DocumentAct act) {
        Label label = this.getTextDetail((Act)act);
        DocumentViewer viewer = this.viewerFactory.create(act, true, this.getContext());
        viewer.setShowNoDocument(false);
        Object result = StringUtils.isEmpty((CharSequence)label.getText()) ? viewer.getComponent() : RowFactory.create((String)"CellSpacing", (Component[])new Component[]{label, viewer.getComponent()});
        return result;
    }

    protected Component getLink(IMObjectBean bean) {
        String description = StringUtils.trimToNull((String)bean.getString("description"));
        String url = bean.getString("url");
        String text = description != null ? description : url;
        Button button = ButtonFactory.create(null, (String)"externallink", () -> ApplicationInstance.getActive().enqueueCommand((Command)new BrowserOpenWindowCommand(url, "", "")));
        return RowFactory.create((String)"CellSpacing", (Component[])new Component[]{LabelFactory.text((String)text), button});
    }

    protected Label getTextDetail(Act act) {
        String text = this.getText(act, true);
        return this.getTextDetail(text);
    }

    protected Label getTextDetail(String text) {
        return LabelFactory.preformatted((String)text, (boolean)true);
    }

    protected String getText(Act act, boolean useDescription) {
        String text = null;
        String expr = this.getExpression(act.getArchetype());
        if (!StringUtils.isEmpty((CharSequence)expr)) {
            try {
                JXPathContext context = JXPathHelper.newContext((Object)act, (Functions)this.functions);
                Object value = context.getValue(expr);
                if (value != null) {
                    text = value.toString();
                }
            }
            catch (Throwable exception) {
                log.error((Object)exception, exception);
                text = exception.getMessage();
            }
        } else if (useDescription) {
            text = act.getDescription();
        }
        return text;
    }

    protected String getValue(IMObjectBean bean, String node, String message) {
        String value = bean.getString(node);
        return !StringUtils.isEmpty((CharSequence)value) ? value : Messages.get((String)message);
    }

    protected Component getSelectionIndicator() {
        Label label = new Label((ImageReference)new HttpImageReference(SELECTED_ICON));
        TableLayoutData layout = new TableLayoutData();
        layout.setAlignment(Alignment.ALIGN_TOP);
        label.setLayoutData((LayoutData)layout);
        return label;
    }

    protected IArchetypeService getService() {
        return this.service;
    }

    protected Component getDateSpacer() {
        LabelEx result = new LabelEx("");
        result.setStyleName("MedicalRecordSummary.date");
        return result;
    }

    private Act getParent(String archetype, int row) {
        List acts = this.getObjects();
        Act act = null;
        boolean found = false;
        if (row >= 0 && row < acts.size()) {
            act = (Act)acts.get(row);
            while (!(found = act.isA(archetype)) && row > 0) {
                act = (Act)acts.get(--row);
            }
        }
        return found ? act : null;
    }

    private Component formatCommunication(IMObjectBean bean, int row) {
        Component date;
        Act act = (Act)bean.getObject(Act.class);
        Act parent = this.getParent(this.parentArchetype, row);
        Date startTime = act.getActivityStartTime();
        boolean topLevel = false;
        if (parent == null || startTime == null || !DateRules.between((Date)startTime, (Date)parent.getActivityStartTime(), (Date)parent.getActivityEndTime())) {
            date = this.formatDate(startTime, true);
            topLevel = true;
        } else {
            date = this.getDate(act, row);
        }
        Component type = this.getType(bean);
        RowLayoutData layout = new RowLayoutData();
        layout.setAlignment(new Alignment(0, 6));
        date.setLayoutData((LayoutData)layout);
        type.setLayoutData((LayoutData)layout);
        Component detail = this.formatItem(bean);
        Row padding = RowFactory.create((String)"Inset", (Component[])new Component[]{new Label("")});
        Row item = RowFactory.create((String)"CellSpacing", (Component[])new Component[0]);
        if (topLevel) {
            item.add(date);
            item.add((Component)padding);
        } else {
            item.add((Component)padding);
            item.add(date);
        }
        item.add(type);
        item.add(detail);
        return item;
    }

    private void onShowBatch(IMObject object) {
        HelpContext help = this.context.getHelpContext().topic(object, "view");
        IMObjectViewerDialog dialog = new IMObjectViewerDialog(object, this.context.getContext(), help);
        dialog.show();
    }

    private String getExpression(String shortName) {
        String result = this.expressions.get(shortName);
        if (result == null) {
            for (Map.Entry<String, String> entry : this.expressions.entrySet()) {
                if (!TypeHelper.matches((String)shortName, (String)entry.getKey())) continue;
                result = entry.getValue();
                break;
            }
        }
        return result;
    }

    private Component getDate(Act act, int row) {
        Act prev;
        boolean showDate = true;
        Date startTime = act.getActivityStartTime();
        if (row > 0 && !TypeHelper.isA((IMObject)(prev = (Act)this.getObject(row - 1)), (String)this.parentArchetype) && DateRules.dateEquals((Date)startTime, (Date)prev.getActivityStartTime())) {
            showDate = false;
        }
        Component date = showDate ? this.formatDate(startTime, false) : this.formatTime(startTime);
        return date;
    }

    private Component formatDate(Date date, boolean bold) {
        LabelEx result = new LabelEx(Messages.format((String)"patient.record.summary.singleDate", (Object[])new Object[]{date}));
        result.setStyleName(bold ? "MedicalRecordSummary.date.bold" : "MedicalRecordSummary.date");
        return result;
    }

    private Component formatTime(Date time) {
        LabelEx result = new LabelEx(Messages.format((String)"patient.record.summary.time", (Object[])new Object[]{time}));
        result.setStyleName("MedicalRecordSummary.date");
        return result;
    }

    private void initStyles() {
        this.typePadding = StyleSheetHelper.getProperty((String)"padding.large", (int)10);
        this.typeWidth = StyleSheetHelper.getProperty((String)"history.type.width", (int)150);
        this.clinicianWidth = StyleSheetHelper.getProperty((String)"history.clinician.width", (int)150);
        if (this.typePadding <= 0) {
            this.typePadding = 10;
        }
        if (this.typeWidth <= 0) {
            this.typeWidth = 150;
        }
        if (this.clinicianWidth <= 0) {
            this.clinicianWidth = 150;
        }
    }
}

