/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.history;

import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.list.ListCellRenderer;
import nextapp.echo2.app.list.ListModel;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.im.list.ShortNameListCellRenderer;
import org.openvpms.web.component.im.list.ShortNameListModel;
import org.openvpms.web.component.im.query.DateRangeActQuery;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.SelectFieldFactory;
import org.openvpms.web.echo.focus.FocusHelper;
import org.openvpms.web.resource.i18n.Messages;

public abstract class AbstractPatientHistoryQuery
extends DateRangeActQuery<Act> {
    private final Preferences preferences;
    private String[] selectedArchetypes;
    private boolean sortAscending = true;
    private ShortNameListModel model;
    private SelectField archetypeSelector;
    private Button sort;

    public AbstractPatientHistoryQuery(Party patient, String[] archetypes, Preferences preferences) {
        super((Entity)patient, "patient", "participation.patient", archetypes, Act.class);
        this.preferences = preferences;
        this.setAuto(true);
        boolean ascending = preferences == null || this.getSortAscending(preferences);
        this.setSortAscending(ascending);
    }

    public void setAvailableArchetypes(String[] archetypes) {
        if (this.model == null) {
            this.model = new ShortNameListModel(archetypes, true, false);
            this.archetypeSelector = SelectFieldFactory.create((ListModel)this.model);
            ActionListener listener = new ActionListener(){

                public void onAction(ActionEvent event) {
                    AbstractPatientHistoryQuery.this.updateSelectedArchetypes(AbstractPatientHistoryQuery.this.model, AbstractPatientHistoryQuery.this.archetypeSelector.getSelectedIndex());
                    AbstractPatientHistoryQuery.this.onQuery();
                }
            };
            this.archetypeSelector.addActionListener((nextapp.echo2.app.event.ActionListener)listener);
            this.archetypeSelector.setCellRenderer((ListCellRenderer)new ShortNameListCellRenderer());
        } else {
            this.archetypeSelector.setModel((ListModel)new ShortNameListModel(archetypes, true, false));
        }
    }

    public String[] getAvailableArchetypes() {
        return this.model != null ? this.model.getShortNames() : new String[]{};
    }

    public void setSelectedArchetypes(String[] archetypes) {
        this.selectedArchetypes = archetypes;
    }

    public String[] getSelectedArchetypes() {
        return this.selectedArchetypes != null ? this.selectedArchetypes : new String[]{};
    }

    public void setSortAscending(boolean ascending) {
        this.sortAscending = ascending;
        if (this.sort != null) {
            this.setSortIcon();
        }
        if (this.preferences != null) {
            this.preferences.setPreference("entity.preferenceGroupHistory", "sort", (Object)(ascending ? "ASC" : "DESC"));
        }
    }

    public boolean isSortAscending() {
        return this.sortAscending;
    }

    public String getValue() {
        return StringUtils.trimToNull((String)this.getSearchField().getText());
    }

    protected void onSearchFieldChanged() {
        super.onSearchFieldChanged();
        FocusHelper.setFocus((Component)this.getSearchField());
    }

    protected Preferences getPreferences() {
        return this.preferences;
    }

    protected SelectField getArchetypeSelector() {
        return this.archetypeSelector;
    }

    protected Button getSort() {
        if (this.sort == null) {
            this.sort = ButtonFactory.create(() -> {
                this.sortAscending = !this.sortAscending;
                this.setSortIcon();
                this.onQuery();
                FocusHelper.setFocus((Component)this.sort);
            });
            this.setSortIcon();
        }
        return this.sort;
    }

    protected void updateSelectedArchetypes() {
        this.updateSelectedArchetypes(this.model, this.archetypeSelector.getSelectedIndex());
    }

    protected abstract void updateSelectedArchetypes(ShortNameListModel var1, int var2);

    protected boolean getSortAscending(Preferences preferences) {
        String sort = preferences.getString("entity.preferenceGroupHistory", "sort", "ASC");
        return "ASC".equals(sort);
    }

    ShortNameListModel getAvailableArchetypesModel() {
        return this.model;
    }

    private void setSortIcon() {
        String toolTip;
        String style;
        if (this.sortAscending) {
            style = "sort.ascending";
            toolTip = Messages.get((String)"patient.record.query.sortAscending");
        } else {
            style = "sort.descending";
            toolTip = Messages.get((String)"patient.record.query.sortDescending");
        }
        this.sort.setStyleName(style);
        this.sort.setToolTipText(toolTip);
    }
}

