/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.history;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.collections4.CollectionUtils;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.act.ActHierarchyIterator;

public abstract class AbstractPatientHistoryFlattener {
    private final String archetype;
    private final boolean includeCommunications;
    private final ArchetypeService service;
    private static final String REASON = "reason";

    public AbstractPatientHistoryFlattener(String archetype, boolean includeCommunications, ArchetypeService service) {
        this.archetype = archetype;
        this.includeCommunications = includeCommunications;
        this.service = service;
    }

    public List<Act> flatten(List<Act> objects, String[] archetypes, Predicate<Act> search, boolean parentSortAscending, boolean childSortAscending) {
        ArrayList<Act> events = new ArrayList<Act>();
        ArrayList<Act> communications = new ArrayList<Act>();
        for (Act object : objects) {
            if (object.isA(this.archetype)) {
                events.add(object);
                continue;
            }
            if (!this.includeCommunication(object, search)) continue;
            communications.add(object);
        }
        ActHierarchyIterator<Act> iterator = this.createIterator(events, archetypes, search, childSortAscending, communications, this.service);
        ArrayList<Act> list = new ArrayList<Act>();
        CollectionUtils.addAll(list, iterator);
        if (!communications.isEmpty()) {
            Comparator comparator = (o1, o2) -> {
                int result = DateRules.compareTo((Date)o1.getActivityStartTime(), (Date)o2.getActivityStartTime());
                if (result == 0) {
                    result = Long.compare(o1.getId(), o2.getId());
                }
                if (!parentSortAscending) {
                    result = -result;
                }
                return result;
            };
            for (Act communication : communications) {
                int index = Collections.binarySearch(events, communication, comparator);
                if (index < 0) {
                    index = -index - 1;
                }
                int insert = -1;
                if (index < events.size()) {
                    Act event = (Act)events.get(index);
                    insert = list.indexOf(event);
                }
                if (insert == -1) {
                    list.add(communication);
                    continue;
                }
                list.add(insert, communication);
            }
        }
        return list;
    }

    protected abstract ActHierarchyIterator<Act> createIterator(List<Act> var1, String[] var2, Predicate<Act> var3, boolean var4, List<Act> var5, ArchetypeService var6);

    private boolean includeCommunication(Act object, Predicate<Act> search) {
        boolean result = this.includeCommunications;
        if (result) {
            Lookup lookup;
            IMObjectBean bean = this.service.getBean((IMObject)object);
            if (bean.hasNode(REASON) && (lookup = bean.getLookup(REASON)) != null) {
                result = this.showInPatientHistory(lookup);
            }
            if (result) {
                result = search == null || search.test(object);
            }
        }
        return result;
    }

    private boolean showInPatientHistory(Lookup reason) {
        IMObjectBean bean = this.service.getBean((IMObject)reason);
        boolean result = bean.getBoolean("showInPatientHistory");
        return result;
    }
}

