/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.payment;

import java.util.List;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.contact.ContactHelper;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.mail.EditableAddressSelector;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.workspace.customer.payment.TransactionPaymentLayoutStrategy;

public class PaymentProcessorPaymentItemLayoutStrategy
extends TransactionPaymentLayoutStrategy {
    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        if (context.isEdit()) {
            Party customer;
            Property email = properties.get("email");
            if (email.isEditable() && (customer = (Party)context.getCache().get(this.getBean(parent).getTargetRef("customer"), Party.class)) != null) {
                List contacts = ContactHelper.getEmailContacts((Party)customer, (ArchetypeService)this.getService());
                EditableAddressSelector selector = new EditableAddressSelector(email, contacts);
                if (email.getString() == null && contacts.size() == 1) {
                    selector.setSelected((Contact)contacts.get(0));
                }
                this.addComponent(new ComponentState(selector.getComponent(), email));
            }
            this.getArchetypeNodes().exclude(new String[]{"paymentProcessor"});
        } else {
            this.getArchetypeNodes().excludeIfEmpty(new String[]{"description", "email"});
        }
        return super.apply(object, properties, parent, context);
    }
}

