/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.payment;

import java.math.BigDecimal;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.system.common.util.Variables;
import org.openvpms.paymentprocessor.internal.service.PaymentProcessorServiceAdapter;
import org.openvpms.paymentprocessor.internal.service.PaymentProcessors;
import org.openvpms.paymentprocessor.internal.transaction.PaymentProcessorTransactionFactory;
import org.openvpms.paymentprocessor.processor.TransactionMode;
import org.openvpms.paymentprocessor.service.PaymentProcessorService;
import org.openvpms.paymentprocessor.service.PaymentRequirements;
import org.openvpms.paymentprocessor.service.RefundRequirements;
import org.openvpms.paymentprocessor.service.TransactionRequirements;
import org.openvpms.paymentprocessor.service.ValidationStatus;
import org.openvpms.paymentprocessor.transaction.Transaction;
import org.openvpms.web.component.im.delete.Deletable;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.MutableProperty;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.PropertySetBuilder;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ConfirmationDialogBuilder;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.NumberFormatter;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.payment.AbstractCustomerPaymentEditor;
import org.openvpms.web.workspace.customer.payment.PaymentProcessorPaymentItemLayoutStrategy;
import org.openvpms.web.workspace.customer.payment.PaymentProcessorStatusDialog;
import org.openvpms.web.workspace.customer.payment.TransactionPaymentItemEditor;

public class PaymentProcessorPaymentItemEditor
extends TransactionPaymentItemEditor {
    private final PaymentProcessorTransactionFactory transactionFactory = (PaymentProcessorTransactionFactory)ServiceHelper.getBean(PaymentProcessorTransactionFactory.class);
    private final BigDecimal reversalAmount;
    private AbstractCustomerPaymentEditor paymentEditor;
    private boolean refreshRequirements = true;
    private PaymentRequirements paymentRequirements;
    private RefundRequirements refundRequirements;
    private boolean readOnly;
    private static final String PAYMENT_PROCESSOR = "paymentProcessor";
    private static final String DESCRIPTION = "description";
    private static final String EMAIL = "email";
    private static final String TRANSACTION_MODE = "transactionMode";

    public PaymentProcessorPaymentItemEditor(FinancialAct act, FinancialAct parent, LayoutContext context) {
        super(act, parent, context);
        FinancialAct reversal;
        this.reversalAmount = act.isA("act.customerAccountRefundPP") ? ((reversal = (FinancialAct)this.getBean((IMObject)act).getSource("reverses", FinancialAct.class)) != null ? reversal.getTotal() : null) : null;
        if (this.getTransactionMode() == null) {
            this.setTransactionMode(TransactionMode.LINK);
        }
        this.updateTransactionStatus();
    }

    public void setPaymentEditor(AbstractCustomerPaymentEditor paymentEditor) {
        this.paymentEditor = paymentEditor;
    }

    public Entity getPaymentProcessor() {
        return this.getParticipant(PAYMENT_PROCESSOR);
    }

    public void setPaymentProcessor(Entity paymentProcessor) {
        this.setParticipant(PAYMENT_PROCESSOR, paymentProcessor);
        this.paymentRequirements = null;
        this.refundRequirements = null;
        this.refreshRequirements = true;
    }

    public String getDisplayName() {
        Entity paymentProcessor = this.getPaymentProcessor();
        return paymentProcessor != null ? paymentProcessor.getName() : super.getDisplayName();
    }

    public boolean supportsSplitTransactions() {
        return false;
    }

    @Override
    public boolean canCancelTransaction() {
        boolean result = false;
        if (!this.isComplete()) {
            FinancialAct transaction = this.getLastTransaction();
            result = transaction != null && this.canCancel(transaction);
        }
        return result;
    }

    @Override
    public void cancelTransaction() {
        FinancialAct transaction = this.getLastTransaction();
        if (transaction != null && this.canCancel(transaction)) {
            this.cancel(transaction);
        }
        this.onLayout();
    }

    public TransactionMode getTransactionMode() {
        String result = this.getProperty(TRANSACTION_MODE).getString();
        return result != null ? TransactionMode.valueOf((String)result) : null;
    }

    public void setTransactionMode(TransactionMode mode) {
        this.getProperty(TRANSACTION_MODE).setValue((Object)(mode != null ? mode.toString() : null));
    }

    public Component getComponent() {
        if (this.refreshRequirements() && this.getView().hasComponent()) {
            this.onLayout();
        }
        return super.getComponent();
    }

    @Override
    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && this.validateUnmatchedRefund(validator) && this.validateReversalAmount(validator);
    }

    @Override
    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return new PaymentProcessorPaymentItemLayoutStrategy();
    }

    protected PropertySet createPropertySet(IMObject object, ArchetypeDescriptor archetype, Variables variables) {
        return new PropertySetBuilder(object, archetype, variables).mutable(TRANSACTION_MODE).mutable("amount").mutable(DESCRIPTION).mutable(EMAIL).build();
    }

    @Override
    protected boolean updateTransactionStatus(FinancialAct transaction, boolean complete) {
        String status;
        boolean changed = super.updateTransactionStatus(transaction, complete);
        boolean mark = this.readOnly;
        this.readOnly = transaction != null ? "IN_PROGRESS".equals(status = transaction.getStatus()) || "SUBMITTED".equals(status) || "COMPLETED".equals(status) : complete;
        boolean reversal = this.isReversal();
        changed |= mark != this.readOnly;
        changed |= this.updateReadOnly(TRANSACTION_MODE, this.readOnly);
        changed |= this.updateReadOnly("amount", this.readOnly || reversal);
        changed |= this.updateReadOnly(DESCRIPTION, this.readOnly || reversal);
        return changed |= this.updateReadOnly(EMAIL, this.readOnly);
    }

    @Override
    protected Deletable getDeletable(FinancialAct transaction) {
        Deletable result;
        Transaction.Status status = Transaction.Status.valueOf((String)transaction.getStatus());
        if (status == Transaction.Status.PENDING || status == Transaction.Status.IN_PROGRESS || status == Transaction.Status.SUBMITTED || status == Transaction.Status.COMPLETED) {
            String reason = status == Transaction.Status.COMPLETED ? Messages.format((String)"customer.payment.delete.completedPP", (Object[])new Object[]{this.getDisplayName()}) : Messages.format((String)"customer.payment.delete.outstandingPP", (Object[])new Object[]{this.getDisplayName()});
            result = Deletable.no((String)reason);
        } else {
            result = Deletable.yes();
        }
        return result;
    }

    @Override
    protected String getTransactionDisplayName() {
        Entity paymentProcessor = this.getPaymentProcessor();
        return paymentProcessor != null ? paymentProcessor.getName() : "<unknown>";
    }

    @Override
    protected void performTransaction(TransactionPaymentItemEditor.TransactionState state, Runnable listener) {
        Transaction transaction;
        Entity paymentProcessor = this.getPaymentProcessor();
        PaymentProcessorServiceAdapter service = this.getServiceAdapter(paymentProcessor);
        FinancialAct act = state.getAct();
        if (act == null) {
            act = this.createTransactionAct(paymentProcessor, state.getSequence());
        }
        if ((transaction = this.transactionFactory.getTransaction(act)).getStatus() == Transaction.Status.PENDING || transaction.getStatus() == Transaction.Status.IN_PROGRESS) {
            this.prepareAndSubmit(transaction, act, service, listener);
        } else if (transaction.getStatus() == Transaction.Status.SUBMITTED) {
            this.check(transaction, act, service, listener);
        } else {
            throw new IllegalStateException("Cannot call performTransaction with transaction status=" + transaction.getStatus());
        }
    }

    @Override
    protected boolean isNewTransactionRequired(Act transaction) {
        Transaction.Status status = Transaction.Status.valueOf((String)transaction.getStatus());
        return status == Transaction.Status.ERROR || status == Transaction.Status.CANCELLED;
    }

    @Override
    protected boolean isComplete(FinancialAct transaction) {
        Transaction.Status status = Transaction.Status.valueOf((String)transaction.getStatus());
        return status == Transaction.Status.COMPLETED;
    }

    protected PaymentProcessorService getPaymentProcessorService(Entity config) {
        PaymentProcessors paymentProcessors = (PaymentProcessors)ServiceHelper.getBean(PaymentProcessors.class);
        return paymentProcessors.getPaymentProcessor(config);
    }

    @Override
    protected boolean markPropertiesReadOnly() {
        return this.readOnly;
    }

    @Override
    protected void refreshLayout() {
        this.updateTransactionStatus();
        this.refreshRequirements();
        this.onLayout();
    }

    private boolean refreshRequirements() {
        boolean needsLayout = false;
        if (this.refreshRequirements) {
            Entity paymentProcessor = this.getPaymentProcessor();
            if (paymentProcessor != null) {
                try {
                    PaymentProcessorServiceAdapter adapter = this.getServiceAdapter(paymentProcessor);
                    boolean readOnly = this.markPropertiesReadOnly();
                    boolean payment = this.getObject().isA("act.customerAccountPaymentPP");
                    TransactionMode mode = this.getTransactionMode();
                    if (mode != null) {
                        this.paymentRequirements = payment ? adapter.getPaymentRequirements(mode) : null;
                        this.refundRequirements = !payment ? adapter.getRefundRequirements(mode) : null;
                        PaymentRequirements requirements = payment ? this.paymentRequirements : this.refundRequirements;
                        needsLayout |= this.updateProperty(DESCRIPTION, requirements.getDescription(), readOnly || this.isReversal());
                        needsLayout |= this.updateProperty(EMAIL, requirements.getEmail(), readOnly);
                    } else {
                        this.paymentRequirements = null;
                        this.refundRequirements = null;
                    }
                    this.refreshRequirements = false;
                }
                catch (Exception exception) {
                    ErrorHelper.show((Throwable)exception);
                }
            } else {
                this.refreshRequirements = false;
            }
        }
        return needsLayout;
    }

    private boolean updateProperty(String name, TransactionRequirements.Field requirement, boolean readOnly) {
        MutableProperty property = (MutableProperty)this.getProperty(name);
        boolean changed = !readOnly ? (requirement == TransactionRequirements.Field.MANDATORY ? property.setEditable(true) : (requirement == TransactionRequirements.Field.OPTIONAL ? property.setEditable(false) : property.setUnsupported())) : (requirement == TransactionRequirements.Field.MANDATORY || requirement == TransactionRequirements.Field.OPTIONAL ? property.setViewable() : property.setUnsupported());
        return changed;
    }

    private boolean isReversal() {
        return this.reversalAmount != null;
    }

    private void prepareAndSubmit(Transaction transaction, FinancialAct act, PaymentProcessorServiceAdapter service, Runnable listener) {
        boolean isNew;
        ValidationStatus status = service.prepare(transaction);
        boolean bl = isNew = Transaction.Status.PENDING == transaction.getStatus();
        if (status.getStatus() == ValidationStatus.Status.VALID) {
            this.submit(transaction, act, isNew, service, listener);
        } else if (status.getStatus() == ValidationStatus.Status.WARNING) {
            ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().message(status.getMessage())).yesNo()).yes(() -> this.submit(transaction, act, isNew, service, listener))).show();
        } else {
            Entity paymentProcessor = this.getPaymentProcessor();
            ErrorHelper.show((String)paymentProcessor.getName(), (String)status.getMessage());
        }
    }

    private void check(Transaction transaction, FinancialAct act, PaymentProcessorServiceAdapter service, Runnable listener) {
        if (service.check(transaction)) {
            this.transactionUpdated(transaction, act, listener);
        } else {
            listener.run();
        }
    }

    private void transactionUpdated(Transaction transaction, FinancialAct act, final Runnable listener) {
        boolean complete = this.isComplete(act);
        if (this.updateTransactionStatus(act, complete)) {
            this.onLayout();
        }
        Entity paymentProcessor = this.getPaymentProcessor();
        if (transaction.getStatus() == Transaction.Status.COMPLETED) {
            listener.run();
        } else {
            if (transaction.getStatus() != Transaction.Status.CANCELLED && transaction.getStatus() != Transaction.Status.ERROR && this.paymentEditor != null && (this.paymentEditor.isPosted() || this.paymentEditor.postOnCompletion())) {
                this.paymentEditor.makeSaveable();
            }
            PaymentProcessorStatusDialog dialog = PaymentProcessorStatusDialog.create(paymentProcessor, transaction, act, this.getLayoutContext(), false);
            dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

                public void onClose(WindowPaneEvent event) {
                    listener.run();
                }
            });
            dialog.show();
        }
    }

    private boolean canCancel(FinancialAct act) {
        Transaction.Status status = Transaction.Status.valueOf((String)act.getStatus());
        return status == Transaction.Status.PENDING || status == Transaction.Status.IN_PROGRESS || status == Transaction.Status.SUBMITTED;
    }

    private void cancel(FinancialAct act) {
        Transaction transaction = this.transactionFactory.getTransaction(act);
        PaymentProcessorServiceAdapter service = this.getServiceAdapter((Entity)transaction.getPaymentProcessor());
        service.cancel(transaction);
    }

    private boolean validateUnmatchedRefund(Validator validator) {
        if (this.getObject().isA("act.customerAccountRefundPP") && !this.supportsUnmatchedRefunds() && this.getBean((IMObject)this.getObject()).getSourceRef("reverses") == null) {
            Entity processor = this.getPaymentProcessor();
            String name = processor != null ? processor.getName() : null;
            String message = Messages.format((String)"customer.payment.pp.unmatchedRefundsUnsupported", (Object[])new Object[]{name});
            validator.add((Modifiable)this, message);
        }
        return validator.isValid();
    }

    private boolean supportsUnmatchedRefunds() {
        this.refreshRequirements();
        return this.refundRequirements != null && this.refundRequirements.supportsUnmatchedRefunds();
    }

    private boolean validateReversalAmount(Validator validator) {
        Property property;
        BigDecimal amount;
        if (this.reversalAmount != null && (amount = (property = this.getProperty("amount")).getBigDecimal(BigDecimal.ZERO)).compareTo(this.reversalAmount) != 0) {
            validator.add((Modifiable)property, Messages.format((String)"customer.payment.amountMismatch", (Object[])new Object[]{NumberFormatter.formatCurrency((Number)this.reversalAmount)}));
        }
        return validator.isValid();
    }

    private void submit(Transaction transaction, FinancialAct act, boolean isNew, PaymentProcessorServiceAdapter adapter, Runnable listener) {
        if (transaction.getStatus() == Transaction.Status.PENDING) {
            transaction.setStatus(Transaction.Status.IN_PROGRESS);
            this.onLayout();
        }
        adapter.submit(transaction, isNew);
        this.transactionUpdated(transaction, act, listener);
    }

    private FinancialAct createTransactionAct(Entity paymentProcessor, int sequence) {
        boolean isPayment = this.getObject().isA("act.customerAccountPaymentPP");
        FinancialAct parent = (FinancialAct)this.getParent();
        BigDecimal amount = this.getAmount();
        TransactionMode mode = this.getTransactionMode();
        String email = this.getProperty(EMAIL).getString();
        String description = this.getProperty(DESCRIPTION).getString();
        FinancialAct act = isPayment ? this.transactionFactory.createPayment(parent, amount, paymentProcessor, mode, email, description) : this.transactionFactory.createRefund(parent, amount, paymentProcessor, mode, email, description);
        this.addTransaction(act, sequence);
        return act;
    }

    private PaymentProcessorServiceAdapter getServiceAdapter(Entity config) {
        return new PaymentProcessorServiceAdapter(this.getPaymentProcessorService(config));
    }
}

