/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.payment;

import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.finance.reminder.AccountReminderRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.service.object.DomainObjectService;
import org.openvpms.paymentprocessor.transaction.Transaction;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.CustomerActCRUDWindow;
import org.openvpms.web.workspace.customer.account.AccountActActions;
import org.openvpms.web.workspace.customer.payment.PaymentProcessorStatusDialog;
import org.openvpms.web.workspace.workflow.payment.OpenDrawerTask;

public class PaymentCRUDWindow
extends CustomerActCRUDWindow<FinancialAct> {
    private static final String SEND_LINK = "button.sendLink";

    public PaymentCRUDWindow(Archetypes<FinancialAct> archetypes, Context context, HelpContext help) {
        super(archetypes, new PaymentActions(context), context, help);
    }

    @Override
    protected void onPosted(FinancialAct act) {
        super.onPosted(act);
        OpenDrawerTask task = new OpenDrawerTask();
        task.open((Act)act);
    }

    protected void layoutButtons(ButtonSet buttons) {
        super.layoutButtons(buttons);
        buttons.add(this.createPostButton());
        buttons.add(this.createPrintButton());
        buttons.add(this.createMailButton());
        buttons.add(ButtonFactory.create((String)SEND_LINK, (Runnable)this.action(this::sendLink)));
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
        super.enableButtons(buttons, enable);
        buttons.setEnabled("button.post", enable);
        this.enablePrintPreview(buttons, enable);
        buttons.setEnabled(SEND_LINK, enable && this.getActions().canSendLink((FinancialAct)this.getObject()));
    }

    protected PaymentActions getActions() {
        return (PaymentActions)super.getActions();
    }

    private void sendLink(FinancialAct act) {
        PaymentActions actions = this.getActions();
        FinancialAct transactionAct = actions.getPaymentProcessorTransaction(act);
        if (transactionAct != null && actions.canSendLinkForTransaction(transactionAct)) {
            DomainObjectService service = (DomainObjectService)ServiceHelper.getBean(DomainObjectService.class);
            Transaction transaction = (Transaction)service.create((IMObject)transactionAct, Transaction.class);
            PaymentProcessorStatusDialog dialog = PaymentProcessorStatusDialog.create((Entity)transaction.getPaymentProcessor(), transaction, transactionAct, this.createLayoutContext(this.getHelpContext()), true);
            dialog.show();
        } else {
            this.onRefresh((IMObject)act);
        }
    }

    private static class PaymentActions
    extends AccountActActions {
        private final Context context;

        public PaymentActions(Context context) {
            super((CustomerAccountRules)ServiceHelper.getBean(CustomerAccountRules.class), (AccountReminderRules)ServiceHelper.getBean(AccountReminderRules.class), (PracticeService)ServiceHelper.getBean(PracticeService.class), (ArchetypeService)ServiceHelper.getArchetypeService());
            this.context = context;
        }

        public boolean canCreate() {
            Party customer = this.context.getCustomer();
            return customer != null && customer.isA("party.customerperson");
        }

        public boolean canSendLink(FinancialAct act) {
            FinancialAct transaction = this.getPaymentProcessorTransaction(act);
            return this.canSendLinkForTransaction(transaction);
        }

        public boolean canSendLinkForTransaction(FinancialAct transaction) {
            boolean result = false;
            if (this.isSubmitted(transaction)) {
                String url = this.getBean((IMObject)transaction).getString("url");
                result = url != null;
            }
            return result;
        }

        public boolean isSubmitted(FinancialAct transaction) {
            return transaction != null && "SUBMITTED".equals(transaction.getStatus());
        }

        public FinancialAct getPaymentProcessorTransaction(FinancialAct act) {
            return this.getCustomerAccountRules().getPaymentProcessorTransaction(act);
        }
    }
}

