/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.payment;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import nextapp.echo2.app.Component;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.im.edit.IMObjectCollectionEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.act.ActRelationshipCollectionEditor;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.ComponentSet;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.payment.AbstractCustomerPaymentEditor;
import org.openvpms.web.workspace.customer.payment.CustomerPaymentLayoutStrategy;
import org.openvpms.web.workspace.customer.payment.PaymentStatus;

public class CustomerPaymentEditor
extends AbstractCustomerPaymentEditor {
    private final SimpleProperty previousBalance;
    private final SimpleProperty overdueAmount;
    private final SimpleProperty totalBalance;
    private final CustomerAccountRules rules;

    public CustomerPaymentEditor(FinancialAct act, IMObject parent, LayoutContext context) {
        this(act, parent, context, BigDecimal.ZERO);
    }

    public CustomerPaymentEditor(FinancialAct act, IMObject parent, LayoutContext context, BigDecimal invoice) {
        super(act, parent, context);
        if (!act.isA(new String[]{"act.customerAccountPayment", "act.customerAccountRefund"})) {
            throw new IllegalArgumentException("Invalid archetype" + act.getArchetype() + " for argument 'act'");
        }
        this.rules = (CustomerAccountRules)ServiceHelper.getBean(CustomerAccountRules.class);
        this.setInvoiceAmount(invoice);
        this.previousBalance = this.createProperty("previousBalance", "customer.payment.previousBalance");
        this.overdueAmount = this.createProperty("overdueAmount", "customer.payment.overdue");
        this.totalBalance = this.createProperty("totalBalance", "customer.payment.totalBalance");
        this.updateSummary();
        this.getProperty("customer").addModifiableListener(modifiable -> this.updateSummary());
    }

    public IMObjectEditor newInstance() {
        return new CustomerPaymentEditor(this.reloadPayment(), this.getParent(), this.getLayoutContext(), this.getInvoiceAmount());
    }

    public ActRelationshipCollectionEditor getItems() {
        return super.getItems();
    }

    protected FinancialAct reloadPayment() {
        FinancialAct object = (FinancialAct)this.reload((IMObject)this.getObject());
        if (object.isNew()) {
            object.setTotal(BigDecimal.ZERO);
            object.setTaxAmount(BigDecimal.ZERO);
            object.setAllocatedAmount(BigDecimal.ZERO);
            object.getParticipations().clear();
            object.getSourceActRelationships().clear();
            object.getTargetActRelationships().clear();
        }
        return object;
    }

    @Override
    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return new LayoutStrategy((IMObjectCollectionEditor)this.getItems(), this.getPaymentStatus());
    }

    protected void updateSummary() {
        Party customer = this.getCustomer();
        BigDecimal overdue = BigDecimal.ZERO;
        BigDecimal previous = BigDecimal.ZERO;
        BigDecimal total = BigDecimal.ZERO;
        if (customer != null) {
            total = this.getBalance(customer);
            overdue = this.rules.getOverdueBalance(customer, new Date());
            BigDecimal invoice = this.getInvoiceAmount();
            previous = total.subtract(overdue).subtract(invoice);
        }
        this.previousBalance.setValue((Object)previous);
        this.overdueAmount.setValue((Object)overdue);
        this.totalBalance.setValue((Object)total);
    }

    protected BigDecimal getBalance(Party customer) {
        return this.rules.getBalance(customer);
    }

    protected CustomerAccountRules getRules() {
        return this.rules;
    }

    protected class LayoutStrategy
    extends CustomerPaymentLayoutStrategy {
        public LayoutStrategy(IMObjectCollectionEditor editor, PaymentStatus status) {
            super(editor, status);
        }

        @Override
        protected void doSimpleLayout(IMObject object, IMObject parent, List<Property> properties, Component container, LayoutContext context) {
            ComponentSet set = this.createComponentSet(object, properties, context);
            ComponentGrid grid = new ComponentGrid();
            grid.set(0, 0, this.createComponent(CustomerPaymentEditor.this.getInvoiceAmountProperty(), object, context));
            grid.set(0, 2, this.createComponent((Property)CustomerPaymentEditor.this.previousBalance, object, context));
            grid.set(1, 0, this.createComponent((Property)CustomerPaymentEditor.this.overdueAmount, object, context));
            grid.set(1, 2, this.createComponent((Property)CustomerPaymentEditor.this.totalBalance, object, context));
            grid.add(set);
            this.addAuditInfo(object, grid, context);
            this.doGridLayout(grid, container);
        }
    }
}

