/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.order;

import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.finance.order.OrderRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.workspace.customer.order.OrderCharger;

public class OrderChargerFactory {
    private final OrderRules orderRules;
    private final CustomerAccountRules customerAccountRules;
    private final IArchetypeService service;
    private final IArchetypeRuleService ruleService;

    public OrderChargerFactory(OrderRules orderRules, CustomerAccountRules customerAccountRules, IArchetypeService service, IArchetypeRuleService ruleService) {
        this.orderRules = orderRules;
        this.customerAccountRules = customerAccountRules;
        this.service = service;
        this.ruleService = ruleService;
    }

    public OrderCharger create(Party customer, Context context, HelpContext help) {
        return new OrderCharger(customer, this.orderRules, this.customerAccountRules, this.service, this.ruleService, context, help);
    }

    public OrderCharger create(Party customer, Party patient, Context context, HelpContext help) {
        return new OrderCharger(customer, patient, this.orderRules, this.customerAccountRules, this.service, this.ruleService, context, help);
    }
}

