/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.order;

import java.util.ArrayList;
import java.util.List;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.RadioButton;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.button.ButtonGroup;
import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.finance.order.OrderRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryHelper;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.property.DefaultValidator;
import org.openvpms.web.component.property.ValidationHelper;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.dialog.OptionDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActEditDialog;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActEditor;
import org.openvpms.web.workspace.customer.order.InvestigationOrderInvoicer;
import org.openvpms.web.workspace.customer.order.OrderInvoicer;
import org.openvpms.web.workspace.customer.order.PendingOrderBrowser;
import org.openvpms.web.workspace.customer.order.PendingOrderDialog;
import org.openvpms.web.workspace.customer.order.PendingOrderQuery;
import org.openvpms.web.workspace.customer.order.PharmacyOrderInvoicer;

public class OrderCharger {
    private final Party customer;
    private final Party patient;
    private final OrderRules rules;
    private final CustomerAccountRules accountRules;
    private final IArchetypeService service;
    private final IArchetypeRuleService ruleService;
    private final Context context;
    private final HelpContext help;
    private final List<Act> charged = new ArrayList<Act>();

    OrderCharger(Party customer, OrderRules rules, CustomerAccountRules accountRules, IArchetypeService service, IArchetypeRuleService ruleService, Context context, HelpContext help) {
        this(customer, null, rules, accountRules, service, ruleService, context, help);
    }

    OrderCharger(Party customer, Party patient, OrderRules rules, CustomerAccountRules accountRules, IArchetypeService service, IArchetypeRuleService ruleService, Context context, HelpContext help) {
        if (service instanceof IArchetypeRuleService) {
            throw new IllegalArgumentException("Argument 'service' must not implement IArchetypeRuleService");
        }
        this.customer = customer;
        this.patient = patient;
        this.rules = rules;
        this.accountRules = accountRules;
        this.service = service;
        this.ruleService = ruleService;
        LocalContext copy = LocalContext.copy((Context)context);
        copy.setCustomer(customer);
        copy.setPatient(patient);
        this.context = copy;
        this.help = help;
    }

    public Party getCustomer() {
        return this.customer;
    }

    public boolean hasOrders() {
        if (this.charged.isEmpty()) {
            return this.rules.hasOrders(this.customer, this.patient);
        }
        PendingOrderQuery query = new PendingOrderQuery(this.customer, this.patient, this.charged);
        List orders = QueryHelper.query((Query)query);
        return !orders.isEmpty();
    }

    public void save() {
        if (!this.charged.isEmpty()) {
            this.ruleService.save(this.charged);
        }
    }

    public void clear() {
        this.charged.clear();
    }

    public int getChargedOrders() {
        int result = 0;
        for (Act act : this.charged) {
            if (!act.isA("act.customerOrder*")) continue;
            ++result;
        }
        return result;
    }

    public int getChargedReturns() {
        int result = this.charged.size();
        if (result != 0) {
            result -= this.getChargedOrders();
        }
        return result;
    }

    public void charge(FinancialAct act, Runnable listener) {
        OrderInvoicer invoicer = this.createInvoicer((Act)act);
        DefaultValidator validator = new DefaultValidator();
        if (invoicer != null && invoicer.validate((Validator)validator)) {
            FinancialAct invoice = invoicer.getInvoice();
            if (invoice == null || "POSTED".equals(invoice.getStatus())) {
                if (invoicer.notFromInvoice()) {
                    this.invoiceOrCredit(act, invoicer, listener);
                } else if (invoicer.canInvoice()) {
                    this.invoice(act, invoicer, listener);
                } else if (invoicer.canCredit()) {
                    this.credit(act, invoicer, listener);
                } else {
                    this.show(Messages.format((String)"customer.order.invoice.unsupported", (Object[])new Object[]{DescriptorHelper.getDisplayName((IMObject)act, (ArchetypeService)this.service)}), listener);
                }
            } else if (invoicer.canInvoice()) {
                this.doCharge(act, invoicer, invoice, new DefaultLayoutContext(this.context, this.help), listener);
            } else if (invoicer.canCredit()) {
                this.credit(act, invoicer, listener);
            } else {
                this.show(Messages.format((String)"customer.order.invoice.unsupported", (Object[])new Object[]{DescriptorHelper.getDisplayName((IMObject)act, (ArchetypeService)this.service)}), listener);
            }
        } else {
            String title = Messages.format((String)"customer.order.invalid", (Object[])new Object[]{DescriptorHelper.getDisplayName((IMObject)act, (ArchetypeService)this.service)});
            ValidationHelper.showError((String)title, (Validator)validator, (Runnable)listener);
        }
    }

    public void charge(final CustomerChargeActEditor editor, final Runnable listener) {
        PendingOrderQuery query = new PendingOrderQuery(this.customer, null, this.charged);
        ResultSet set = query.query();
        if (!set.hasNext()) {
            if (this.charged.isEmpty()) {
                this.show(Messages.format((String)"customer.order.none", (Object[])new Object[]{this.customer.getName()}), listener);
            } else {
                this.show(Messages.format((String)"customer.order.unsaved", (Object[])new Object[]{this.customer.getName()}), listener);
            }
        } else {
            final PendingOrderBrowser browser = new PendingOrderBrowser(query, (LayoutContext)new DefaultLayoutContext(this.context, this.help));
            browser.query();
            PendingOrderDialog dialog = new PendingOrderDialog(Messages.get((String)"customer.order.invoice.title"), browser, (Context)new LocalContext(this.context), this.help);
            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onOK() {
                    List<Act> orders = browser.getOrders();
                    OrderCharger.this.charge(orders, editor, listener);
                }
            });
            dialog.show();
        }
    }

    public void chargeComplete(CustomerChargeActEditor editor) {
        PendingOrderQuery query = new PendingOrderQuery(this.customer, null, this.charged);
        List orders = QueryHelper.query((Query)query);
        for (Act order : orders) {
            OrderInvoicer invoicer = this.createInvoicer(order);
            if (invoicer == null || !invoicer.isValid() || !invoicer.canCharge(editor) || this.patient != null && !invoicer.canCharge(this.patient)) continue;
            invoicer.charge(editor);
            this.charged.add(order);
        }
    }

    private OrderInvoicer createInvoicer(Act act) {
        if (TypeHelper.isA((IMObject)act, (String[])new String[]{"act.customerOrderPharmacy", "act.customerReturnPharmacy"})) {
            return new PharmacyOrderInvoicer((FinancialAct)act, this.context.getClinician(), this.rules, this.service);
        }
        if (TypeHelper.isA((IMObject)act, (String)"act.customerReturnInvestigation")) {
            return new InvestigationOrderInvoicer((FinancialAct)act, this.context.getClinician(), this.rules, this.service);
        }
        return null;
    }

    private void charge(List<Act> orders, CustomerChargeActEditor editor, Runnable listener) {
        StringBuilder messages = new StringBuilder();
        for (Act order : orders) {
            OrderInvoicer invoicer = this.createInvoicer(order);
            if (invoicer == null) continue;
            if (!invoicer.isValid()) {
                this.append(messages, Messages.format((String)"customer.order.incomplete", (Object[])new Object[]{order.getId(), DescriptorHelper.getDisplayName((IMObject)order, (ArchetypeService)this.service)}));
                continue;
            }
            if (this.patient != null && !invoicer.canCharge(this.patient)) {
                this.append(messages, Messages.format((String)"customer.order.multiplePatient", (Object[])new Object[]{order.getId(), DescriptorHelper.getDisplayName((IMObject)order, (ArchetypeService)this.service)}));
                continue;
            }
            OrderInvoicer.Status status = invoicer.getChargeStatus(editor);
            if (!status.canCharge()) {
                this.append(messages, status.getReason());
                continue;
            }
            invoicer.charge(editor);
            this.charged.add(order);
        }
        if (messages.length() != 0) {
            this.show(messages.toString(), listener);
        } else {
            listener.run();
        }
    }

    private void invoice(FinancialAct act, OrderInvoicer invoicer, Runnable listener) {
        if (invoicer.requiresEdit()) {
            FinancialAct current = this.accountRules.getInvoice(invoicer.getCustomer());
            this.charge(act, current, invoicer, listener);
        } else {
            invoicer.charge();
            listener.run();
        }
    }

    private void credit(FinancialAct act, OrderInvoicer invoicer, Runnable listener) {
        FinancialAct current = this.accountRules.getCredit(invoicer.getCustomer());
        this.charge(act, current, invoicer, listener);
    }

    private void invoiceOrCredit(final FinancialAct act, final OrderInvoicer invoicer, final Runnable listener) {
        if (invoicer.isOrder()) {
            this.invoice(act, invoicer, listener);
        } else {
            String displayName = DescriptorHelper.getDisplayName((IMObject)act, (ArchetypeService)this.service);
            String title = Messages.format((String)"customer.order.return.credit.title", (Object[])new Object[]{displayName});
            String message = Messages.format((String)"customer.order.return.credit.message", (Object[])new Object[]{displayName});
            String[] options = new String[]{DescriptorHelper.getDisplayName((String)"act.customerAccountChargesCredit", (ArchetypeService)this.service), DescriptorHelper.getDisplayName((String)"act.customerAccountChargesInvoice", (ArchetypeService)this.service)};
            final OptionDialog dialog = new OptionDialog(title, message, options);
            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onOK() {
                    boolean credit = dialog.getSelected() == 0;
                    OrderCharger.this.applyReturn(act, credit, invoicer, listener);
                }
            });
            dialog.show();
        }
    }

    private void applyReturn(final FinancialAct act, boolean credit, final OrderInvoicer invoicer, final Runnable listener) {
        if (credit) {
            this.credit(act, invoicer, listener);
        } else {
            final FinancialAct current = this.accountRules.getInvoice(invoicer.getCustomer());
            if (current == null) {
                FinancialAct invoice = invoicer.createInvoice(this.customer);
                this.returnItems(act, invoice, invoicer, listener);
            } else {
                final SelectChargeDialog dialog = this.createSelectChargeDialog(act, current, invoicer);
                dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                    public void onOK() {
                        FinancialAct invoice = dialog.createCharge() ? invoicer.createInvoice(OrderCharger.this.customer) : current;
                        OrderCharger.this.returnItems(act, invoice, invoicer, listener);
                    }
                });
                dialog.show();
            }
        }
    }

    private void returnItems(FinancialAct act, FinancialAct invoice, OrderInvoicer invoicer, final Runnable listener) {
        DefaultLayoutContext context = new DefaultLayoutContext(this.context, this.help);
        CustomerChargeActEditDialog dialog = invoicer.returnItems(invoice, this, (LayoutContext)context);
        if (dialog != null) {
            dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

                public void onClose(WindowPaneEvent event) {
                    listener.run();
                }
            });
            if ("POSTED".equals(act.getStatus())) {
                this.charged.add((Act)act);
                dialog.checkOrders();
            }
        }
    }

    private void charge(final FinancialAct act, final FinancialAct current, final OrderInvoicer invoicer, final Runnable listener) {
        final DefaultLayoutContext context = new DefaultLayoutContext(this.context, this.help);
        context.setEdit(true);
        if (current == null) {
            this.doCharge(act, invoicer, null, context, listener);
        } else {
            final SelectChargeDialog dialog = this.createSelectChargeDialog(act, current, invoicer);
            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onOK() {
                    if (dialog.createCharge()) {
                        OrderCharger.this.doCharge(act, invoicer, null, context, listener);
                    } else {
                        OrderCharger.this.doCharge(act, invoicer, current, context, listener);
                    }
                }
            });
            dialog.show();
        }
    }

    private SelectChargeDialog createSelectChargeDialog(FinancialAct act, FinancialAct current, OrderInvoicer invoicer) {
        String displayName = DescriptorHelper.getDisplayName((IMObject)current, (ArchetypeService)this.service);
        String title = Messages.format((String)"customer.order.currentcharge.title", (Object[])new Object[]{displayName});
        String message = invoicer.getInvoice() != null && "POSTED".equals(invoicer.getInvoice().getStatus()) ? Messages.format((String)"customer.order.currentcharge.original", (Object[])new Object[]{DescriptorHelper.getDisplayName((IMObject)act, (ArchetypeService)this.service), displayName}) : Messages.format((String)"customer.order.currentcharge.current", (Object[])new Object[]{displayName});
        return new SelectChargeDialog(title, message, displayName);
    }

    private void doCharge(FinancialAct act, OrderInvoicer invoicer, FinancialAct current, DefaultLayoutContext context, final Runnable listener) {
        CustomerChargeActEditDialog dialog = invoicer.charge(current, this, (LayoutContext)context);
        dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

            public void onClose(WindowPaneEvent event) {
                listener.run();
            }
        });
        if ("POSTED".equals(act.getStatus())) {
            this.charged.add((Act)act);
            dialog.checkOrders();
        }
    }

    private void show(String message, final Runnable listener) {
        InformationDialog dialog = new InformationDialog(message);
        dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

            public void onClose(WindowPaneEvent event) {
                listener.run();
            }
        });
        dialog.show();
    }

    private void append(StringBuilder buffer, String message) {
        if (buffer.length() != 0) {
            buffer.append("\n");
        }
        buffer.append(message);
    }

    private static class SelectChargeDialog
    extends ConfirmationDialog {
        private final RadioButton currentInvoice;
        private final RadioButton newInvoice;

        SelectChargeDialog(String title, String message, String displayName) {
            super(title, message);
            ButtonGroup group = new ButtonGroup();
            this.currentInvoice = this.create(Messages.format((String)"customer.order.currentcharge", (Object[])new Object[]{displayName}), group);
            this.newInvoice = this.create(Messages.format((String)"customer.order.newcharge", (Object[])new Object[]{displayName}), group);
            this.currentInvoice.setSelected(true);
        }

        protected void doLayout() {
            Label message = LabelFactory.create((boolean)true, (boolean)true);
            message.setText(this.getMessage());
            Column column = ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{message, ColumnFactory.create((String)"CellSpacing", (Component[])new Component[]{this.currentInvoice, this.newInvoice})});
            Row row = RowFactory.create((String)"Inset.Large", (Component[])new Component[]{column});
            this.getLayout().add((Component)row);
        }

        boolean createCharge() {
            return this.newInvoice.isSelected();
        }

        private RadioButton create(String label, ButtonGroup group) {
            RadioButton button = ButtonFactory.create(null, (ButtonGroup)group);
            button.setText(label);
            return button;
        }
    }
}

