/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.info;

import java.util.List;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.im.layout.IMObjectTabPaneModel;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.customer.info.CustomerAppointmentQuery;
import org.openvpms.web.workspace.customer.info.CustomerLayoutStrategy;
import org.openvpms.web.workspace.customer.info.CustomerTaskQuery;
import org.openvpms.web.workspace.workflow.appointment.view.ParticipantAppointmentBrowser;
import org.openvpms.web.workspace.workflow.appointment.view.ParticipantAppointmentTableModel;
import org.openvpms.web.workspace.workflow.worklist.view.ParticipantTaskBrowser;
import org.openvpms.web.workspace.workflow.worklist.view.ParticipantTaskTableModel;

public class CustomerViewLayoutStrategy
extends CustomerLayoutStrategy {
    protected void doTabLayout(IMObject object, List<Property> properties, IMObjectTabPaneModel model, LayoutContext context, boolean shortcuts) {
        super.doTabLayout(object, properties, model, context, shortcuts);
        Party customer = (Party)object;
        Browser<Act> appointments = this.getAppointments(customer, context);
        Browser<Act> tasks = this.getTasks(customer, context);
        this.addTab(Messages.get((String)"customer.information.appointments"), model, appointments.getComponent());
        this.addTab(Messages.get((String)"customer.information.tasks"), model, tasks.getComponent());
    }

    protected Browser<Act> getAppointments(Party customer, LayoutContext context) {
        ParticipantAppointmentTableModel model = new ParticipantAppointmentTableModel(true, context);
        return new ParticipantAppointmentBrowser(new CustomerAppointmentQuery(customer), (IMTableModel<Act>)model, context);
    }

    protected Browser<Act> getTasks(Party customer, LayoutContext context) {
        ParticipantTaskTableModel model = new ParticipantTaskTableModel(true, context);
        return new ParticipantTaskBrowser(new CustomerTaskQuery(customer), (IMTableModel<Act>)model, context);
    }
}

