/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.info;

import org.openvpms.archetype.rules.party.CustomerRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.ObjectRefConstraint;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.customer.CustomerQuery;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.workflow.SelectIMObjectTask;
import org.openvpms.web.component.workflow.SynchronousTask;
import org.openvpms.web.component.workflow.Task;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.merge.MergeWorkflow;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

class CustomerMergeWorkflow
extends MergeWorkflow<Party> {
    public CustomerMergeWorkflow(Party customer, HelpContext help) {
        super(customer, help);
        this.init();
    }

    @Override
    protected SelectIMObjectTask<Party> createSelectTask(Context context) {
        Party customer = (Party)this.getObject();
        String shortName = customer.getArchetype();
        CustomerQuery query = new CustomerQuery(new String[]{shortName});
        query.setConstraints((IConstraint)Constraints.not((IConstraint)new ObjectRefConstraint("customer", customer.getObjectReference())));
        return new SelectIMObjectTask((Query)query, this.getHelpContext().topic("customer"));
    }

    @Override
    protected String getConfirmationMessage() {
        Party customerTo = (Party)this.getObject();
        Party customerFrom = this.getContext().getCustomer();
        return Messages.format((String)"workflow.merge.message", (Object[])new Object[]{customerTo.getName(), customerTo.getId(), customerFrom.getName(), customerFrom.getId()});
    }

    @Override
    protected Task createMergeTask() {
        return new SynchronousTask(){

            public void execute(TaskContext context) {
                Party from = context.getCustomer();
                CustomerMergeWorkflow.this.merge(from);
            }
        };
    }

    private void merge(final Party from) {
        TransactionTemplate template = new TransactionTemplate(ServiceHelper.getTransactionManager());
        template.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                CustomerRules rules = new CustomerRules((IArchetypeService)ServiceHelper.getArchetypeService(), ServiceHelper.getLookupService());
                rules.mergeCustomers(from, (Party)CustomerMergeWorkflow.this.getObject());
                return true;
            }
        });
    }
}

