/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.estimate;

import java.util.Date;
import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.finance.estimate.EstimateRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.im.util.UserHelper;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.component.workspace.CRUDWindowListener;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.CustomerActCRUDWindow;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActEditDialog;
import org.openvpms.web.workspace.customer.estimate.EstimateActions;
import org.openvpms.web.workspace.customer.estimate.EstimateInvoiceClinicianSelectionDialog;
import org.openvpms.web.workspace.customer.estimate.EstimateInvoicer;

public class EstimateCRUDWindow
extends CustomerActCRUDWindow<Act> {
    private final EstimateRules rules = (EstimateRules)ServiceHelper.getBean(EstimateRules.class);
    private static final String COPY_ID = "copy";
    private static final String INVOICE_ID = "invoice";

    public EstimateCRUDWindow(Archetypes<Act> archetypes, Context context, HelpContext help) {
        super(archetypes, new EstimateActions(), context, help);
    }

    protected EstimateActions getActions() {
        return (EstimateActions)super.getActions();
    }

    protected void layoutButtons(ButtonSet buttons) {
        super.layoutButtons(buttons);
        buttons.add(this.createPostButton());
        buttons.add(this.createPrintButton());
        buttons.add(this.createMailButton());
        buttons.add(COPY_ID, this::onCopy);
        buttons.add(INVOICE_ID, this::onInvoice);
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
        super.enableButtons(buttons, enable);
        boolean enablePost = false;
        boolean enableInvoice = false;
        if (enable) {
            Act act = (Act)this.getObject();
            EstimateActions ops = this.getActions();
            enablePost = ops.canPost(act);
            enableInvoice = ops.canInvoice(act);
        }
        buttons.setEnabled("button.post", enablePost);
        this.enablePrintPreview(buttons, enable);
        buttons.setEnabled(COPY_ID, enable);
        buttons.setEnabled(INVOICE_ID, enableInvoice);
    }

    protected void onCopy() {
        Act object = (Act)this.getObject();
        try {
            String title = Messages.format((String)"customer.estimate.copy.title", (Object[])new Object[]{object.getTitle()});
            Act copy = this.rules.copy(object, title);
            this.setObject(copy);
            CRUDWindowListener listener = this.getListener();
            if (listener != null) {
                listener.saved((IMObject)copy, true);
            }
        }
        catch (OpenVPMSException exception) {
            String title = Messages.get((String)"customer.estimate.copy.failed");
            ErrorHelper.show((String)title, (Throwable)exception);
        }
    }

    protected void onInvoice() {
        final Act act = (Act)IMObjectHelper.reload((IMObject)this.getObject());
        if (act != null) {
            if (this.canInvoice(act)) {
                EstimateInvoiceClinicianSelectionDialog dialog;
                Context context = this.getContext();
                HelpContext help = this.getHelpContext().subtopic(INVOICE_ID);
                if (UserHelper.useLoggedInClinician((Context)context)) {
                    String title = Messages.get((String)"customer.estimate.invoice.title");
                    String message = Messages.get((String)"customer.estimate.invoice");
                    dialog = new ConfirmationDialog(title, message, help);
                } else {
                    dialog = new EstimateInvoiceClinicianSelectionDialog(context, help);
                }
                dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                    public void onOK() {
                        EstimateCRUDWindow.this.invoice(act);
                    }
                });
                dialog.show();
            }
        } else {
            ErrorDialog.show((String)Messages.format((String)"imobject.noexist", (Object[])new Object[]{this.getArchetypes().getDisplayName()}));
        }
    }

    protected boolean canInvoice(Act act) {
        boolean result = false;
        String status = act.getStatus();
        if ("CANCELLED".equals(status) || "INVOICED".equals(status)) {
            this.showStatusError(act, "customer.estimate.noinvoice.title", "customer.estimate.noinvoice.message");
        } else if (this.expired(act)) {
            this.showStatusError(act, "customer.estimate.expired.title", "customer.estimate.expired.message");
        } else {
            result = true;
        }
        return result;
    }

    protected EstimateRules getRules() {
        return this.rules;
    }

    protected void invoice(final Act estimate) {
        try {
            final FinancialAct invoice = this.getInvoice(estimate);
            if (invoice != null) {
                String title = Messages.get((String)"customer.estimate.existinginvoice.title");
                String message = Messages.get((String)"customer.estimate.existinginvoice.message");
                ConfirmationDialog dialog = new ConfirmationDialog(title, message);
                dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                    public void onOK() {
                        EstimateCRUDWindow.this.invoice(estimate, invoice);
                    }
                });
                dialog.show();
            } else {
                this.invoice(estimate, invoice);
            }
        }
        catch (OpenVPMSException exception) {
            String title = Messages.get((String)"customer.estimate.invoice.failed");
            ErrorHelper.show((String)title, (Throwable)exception);
        }
    }

    protected EstimateInvoicer createEstimateInvoicer() {
        return new EstimateInvoicer();
    }

    private boolean expired(Act act) {
        boolean result = false;
        Date endTime = DateRules.getDate((Date)act.getActivityEndTime());
        if (endTime != null) {
            result = endTime.before(DateRules.getToday());
        }
        return result;
    }

    private void invoice(final Act estimate, FinancialAct invoice) {
        try {
            EstimateInvoicer invoicer = this.createEstimateInvoicer();
            HelpContext edit = this.getHelpContext().topic("act.customerAccountChargesInvoice/edit");
            CustomerChargeActEditDialog editor = invoicer.invoice(estimate, invoice, (LayoutContext)new DefaultLayoutContext(true, this.getContext(), edit));
            editor.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

                public void onClose(WindowPaneEvent event) {
                    EstimateCRUDWindow.this.onRefresh((IMObject)estimate);
                }
            });
        }
        catch (OpenVPMSException exception) {
            String title = Messages.get((String)"customer.estimate.invoice.failed");
            ErrorHelper.show((String)title, (Throwable)exception);
        }
    }

    private FinancialAct getInvoice(Act estimate) {
        FinancialAct result = null;
        IMObjectBean bean = this.getBean((IMObject)estimate);
        Party customer = (Party)bean.getTarget("customer", Party.class);
        if (customer != null) {
            CustomerAccountRules rules = (CustomerAccountRules)ServiceHelper.getBean(CustomerAccountRules.class);
            result = rules.getInvoice(customer);
        }
        return result;
    }
}

