/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.document;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.CheckBox;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.archetype.rules.doc.TemporaryDocumentHandler;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.laboratory.resource.Content;
import org.openvpms.laboratory.resource.Resource;
import org.openvpms.laboratory.resource.Resources;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.AbstractIMTableModel;
import org.openvpms.web.component.im.table.DefaultListMarkModel;
import org.openvpms.web.component.im.table.IMTable;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.ListMarkModel;
import org.openvpms.web.component.im.table.MapBasedMarkablePagedIMTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.echo.dialog.ModalDialog;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.image.ThumbnailImageReference;
import org.openvpms.web.echo.servlet.DownloadServlet;
import org.openvpms.web.echo.util.StyleSheetHelper;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.document.ResourceIteratorResultSet;

public class ExternalDocumentsDialog
extends ModalDialog {
    public static final int NAME_INDEX = 1;
    private final int pageSize;
    private final Row navigation;
    private final MapBasedMarkablePagedIMTableModel<String, Resource> pagedModel;
    private final PagedIMTable<Resource> table;

    public ExternalDocumentsDialog(ResourceIteratorResultSet set, HelpContext help) {
        super(Messages.get((String)"document.attachexternal.title"), "BrowserDialog", OK_CANCEL, help);
        this.pageSize = set.getPageSize();
        ExternalDocumentTableModel model = new ExternalDocumentTableModel();
        this.pagedModel = new MapBasedMarkablePagedIMTableModel((IMTableModel)model, Resource::getId);
        this.table = new PagedIMTable(this.pagedModel);
        this.table.setResultSet((ResultSet)set);
        final IMTable child = this.table.getTable();
        this.navigation = RowFactory.create((String)"CellSpacing", (Component[])new Component[0]);
        child.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                Resource selected = (Resource)child.getSelected();
                if (selected != null) {
                    if (selected instanceof Resources) {
                        ExternalDocumentsDialog.this.select((Resources)selected);
                    } else {
                        ExternalDocumentsDialog.this.pagedModel.setMarked((Object)selected, true);
                        ExternalDocumentsDialog.this.onOK();
                    }
                }
            }
        });
        this.showNavigation(set.getResources());
        this.getLayout().add((Component)ColumnFactory.create((String)"Inset", (Component[])new Component[]{this.navigation, this.table.getComponent()}));
        this.resize();
    }

    public Collection<Resource> getSelected() {
        return this.pagedModel.getMarked();
    }

    protected void resize() {
        this.resize("ExternalDocumentsDialog.size");
    }

    private void select(Resources resources) {
        ResourceIteratorResultSet child = new ResourceIteratorResultSet(resources, this.pageSize);
        this.showNavigation(resources);
        this.table.setResultSet((ResultSet)child);
    }

    private void showNavigation(Resources resources) {
        this.navigation.removeAll();
        for (Resources resource : this.getTree(resources)) {
            Button button = ButtonFactory.text((String)resource.getName(), () -> this.select(resource));
            this.navigation.add((Component)button);
        }
    }

    private List<Resources> getTree(Resources resources) {
        ArrayList<Resources> result = new ArrayList<Resources>();
        while (resources != null) {
            result.add(0, resources);
            resources = resources.getParent();
        }
        return result;
    }

    private static class ExternalDocumentTableModel
    extends AbstractIMTableModel<Resource> {
        public ExternalDocumentTableModel() {
            DefaultTableColumnModel model = new DefaultTableColumnModel();
            model.addColumn(new TableColumn(0));
            model.addColumn(ExternalDocumentTableModel.createTableColumn((int)1, (String)"table.imobject.name"));
            this.setTableColumnModel((TableColumnModel)model);
            this.setRowMarkModel((ListMarkModel)new DefaultListMarkModel());
        }

        public SortConstraint[] getSortConstraints(int column, boolean ascending) {
            return new SortConstraint[0];
        }

        protected Object getValue(Resource object, TableColumn column, int row) {
            String result = null;
            switch (column.getModelIndex()) {
                case 0: {
                    CheckBox mark = this.getRowMark(row);
                    if (!(object instanceof Content)) {
                        mark.setEnabled(false);
                    }
                    result = mark;
                    break;
                }
                case 1: {
                    if (object instanceof Content) {
                        Content content = (Content)object;
                        try {
                            if (content.canScale()) {
                                result = this.getImageAndLabel(content);
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    if (result != null) break;
                    result = object.getName();
                }
            }
            return result;
        }

        private Component getImageAndLabel(Content content) {
            ThumbnailImageReference reference;
            Row result = null;
            int size = StyleSheetHelper.getProperty((String)"thumbnail.size", (int)64);
            if (size < 10) {
                size = 10;
            }
            if ((reference = ThumbnailImageReference.create((InputStream)content.getContent(size, size), (String)content.getMimeType())) != null) {
                Button button = ButtonFactory.create(null, (String)null, () -> {
                    TemporaryDocumentHandler handler = new TemporaryDocumentHandler((ArchetypeService)ServiceHelper.getArchetypeService());
                    Document document = handler.create(content.getName(), content.getContent(), content.getMimeType(), -1);
                    DownloadServlet.startDownload((org.openvpms.component.model.document.Document)document);
                });
                button.setIcon((ImageReference)reference);
                button.setToolTipText(Messages.get((String)"document.fullsize"));
                result = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{button, LabelFactory.text((String)content.getName())});
            }
            return result;
        }
    }
}

