/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.credit;

import java.math.BigDecimal;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.insurance.internal.claim.GapClaimImpl;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.edit.PropertyEditor;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.DefaultValidator;
import org.openvpms.web.component.property.ValidationHelper;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.echo.dialog.ModalDialog;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.customer.credit.GapClaimAllocation;
import org.openvpms.web.workspace.customer.credit.GapPaymentTillReferenceEditor;
import org.openvpms.web.workspace.patient.insurance.claim.GapClaimSummary;

public class GapClaimAllocationDialog
extends ModalDialog {
    private final GapClaimAllocation allocation;
    private final String message;
    private GapPaymentTillReferenceEditor tillEditor;

    public GapClaimAllocationDialog(GapClaimAllocation allocation, HelpContext help) {
        super(Messages.get((String)"patient.insurance.pay.title"), "MediumWidthHeightDialog", OK_CANCEL, help);
        this.allocation = allocation;
        this.message = this.getMessage(allocation);
        Label content = LabelFactory.text((String)this.message, (boolean)true);
        if (allocation.getTill() == null && allocation.isTillRequired()) {
            Party location = allocation.getClaim().getLocationParty();
            DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), help);
            this.tillEditor = new GapPaymentTillReferenceEditor(location, (LayoutContext)context);
            this.tillEditor.addModifiableListener(modifiable -> allocation.setTill((Entity)this.tillEditor.getObject()));
        }
        Component summary = new AllocationSummary(allocation).getComponent();
        Column column = ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{summary, content});
        this.getLayout().add((Component)ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{column}));
        if (allocation.isPresettledAndAllocationIsGreaterThanGap()) {
            this.setTitleBackground(Color.RED);
            this.getButtons().setEnabled("ok", false);
        }
    }

    public GapClaimAllocation getAllocation() {
        return this.allocation;
    }

    public String getMessage() {
        return this.message;
    }

    protected void onOK() {
        if (this.validateTill() && !this.allocation.isPresettledAndAllocationIsGreaterThanGap()) {
            super.onOK();
        }
    }

    protected String getMessage(GapClaimAllocation allocation) {
        StringBuilder result = new StringBuilder();
        GapClaimAllocation.Status status = allocation.getStatus();
        if (allocation.benefitPending()) {
            result.append(Messages.format((String)"customer.credit.allocate.gap.nobenefit", (Object[])new Object[0]));
            if (status == GapClaimAllocation.Status.NO_BENEFIT_PARTIAL_PAYMENT) {
                result.append(Messages.get((String)"customer.credit.allocate.gap.nobenefit.partial"));
            } else {
                result.append(Messages.get((String)"customer.credit.allocate.gap.nobenefit.full"));
            }
        } else if (status == GapClaimAllocation.Status.ALLOCATION_LESS_THAN_GAP) {
            result.append(Messages.format((String)"customer.credit.allocate.gap.less", (Object[])new Object[]{allocation.getGapAmount().subtract(allocation.getAllocation())}));
        } else if (status == GapClaimAllocation.Status.ALLOCATION_EQUAL_TO_GAP) {
            result.append(Messages.get((String)"customer.credit.allocate.gap.equal"));
        } else if (status == GapClaimAllocation.Status.ALLOCATION_GREATER_THAN_GAP) {
            result.append(Messages.format((String)"customer.credit.allocate.gap.partial", (Object[])new Object[]{allocation.getTotal().subtract(allocation.getAllocation())}));
        } else if (status == GapClaimAllocation.Status.PRE_SETTLED_AND_ALLOCATION_GREATER_THAN_GAP) {
            BigDecimal unpaid = allocation.getUnpaidGap();
            result.append(Messages.format((String)"customer.credit.allocate.gap.presettled", (Object[])new Object[]{unpaid}));
        } else {
            result.append(Messages.get((String)"customer.credit.allocate.gap.full"));
        }
        return result.toString();
    }

    private boolean validateTill() {
        DefaultValidator validator;
        boolean valid = true;
        if (this.tillEditor != null && !this.tillEditor.validate((Validator)(validator = new DefaultValidator()))) {
            valid = false;
            ValidationHelper.showError((Validator)validator);
        }
        return valid;
    }

    void setTill(Entity till) {
        this.tillEditor.setObject(till);
    }

    private class AllocationSummary
    extends GapClaimSummary {
        AllocationSummary(GapClaimAllocation allocation) {
            super(allocation.getClaim(), allocation.getExistingAllocation());
        }

        @Override
        protected void doLayout(GapClaimImpl claim, ComponentGrid grid) {
            super.doLayout(claim, grid);
            grid.add(new Component[]{LabelFactory.create((String)"customer.credit.allocate.gap.currentpayment"), this.createAmount(GapClaimAllocationDialog.this.allocation.getNewAllocation())});
            if (GapClaimAllocationDialog.this.tillEditor != null) {
                grid.add(new ComponentState[]{new ComponentState((PropertyEditor)GapClaimAllocationDialog.this.tillEditor)});
            }
        }
    }
}

