/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.credit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.rules.finance.credit.CreditActAllocator;
import org.openvpms.archetype.rules.finance.credit.CreditAllocation;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.insurance.claim.Claim;
import org.openvpms.insurance.claim.GapClaim;
import org.openvpms.insurance.internal.claim.GapClaimImpl;
import org.openvpms.insurance.service.GapInsuranceService;
import org.openvpms.insurance.service.InsuranceService;
import org.openvpms.insurance.service.InsuranceServices;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.act.ActEditDialog;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.property.DefaultValidator;
import org.openvpms.web.component.property.ValidationHelper;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.credit.AllocationDialog;
import org.openvpms.web.workspace.customer.credit.GapClaimAllocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreditActEditDialog
extends ActEditDialog {
    private final CreditActAllocator allocator;
    private final IArchetypeRuleService service;
    private final List<FinancialAct> debits;
    private List<FinancialAct> allocation;
    private List<GapClaimAllocation> claimAllocations;
    private final List<FinancialAct> adjustments = new ArrayList<FinancialAct>();
    private static final Logger log = LoggerFactory.getLogger(CreditActEditDialog.class);

    public CreditActEditDialog(IMObjectEditor editor, Context context) {
        this(editor, Collections.emptyList(), context);
    }

    public CreditActEditDialog(IMObjectEditor editor, List<FinancialAct> debits, Context context) {
        super(editor, context);
        this.debits = debits;
        this.service = ServiceHelper.getArchetypeService();
        this.allocator = (CreditActAllocator)ServiceHelper.getBean(CreditActAllocator.class);
    }

    public boolean save() {
        this.allocation = null;
        this.claimAllocations = null;
        this.adjustments.clear();
        boolean save = false;
        if (this.canSave() && this.isValid()) {
            final FinancialAct object = (FinancialAct)this.getEditor().getObject();
            if (object.isCredit()) {
                CreditAllocation allocation = this.allocator.allocate(object, this.debits, false);
                if (!allocation.overrideDefaultAllocation()) {
                    this.allocation = allocation.getModified();
                    save = super.save();
                } else {
                    final AllocationDialog dialog = this.createAllocationDialog(allocation);
                    dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                        public void onOK() {
                            CreditActEditDialog.this.onAllocated(object, dialog.getDebits(), dialog.getGapClaimAllocations());
                        }
                    });
                    dialog.show();
                }
            } else {
                save = super.save();
            }
        }
        return save;
    }

    protected boolean isValid() {
        DefaultValidator validator = new DefaultValidator();
        boolean valid = this.getEditor().validate((Validator)validator);
        if (!valid) {
            ValidationHelper.showError((Validator)validator);
        }
        return valid;
    }

    protected AllocationDialog createAllocationDialog(CreditAllocation allocation) {
        return new AllocationDialog(allocation, this.getContext(), this.getHelpContext().subtopic("allocation"));
    }

    protected void doSave(IMObjectEditor editor) {
        if (this.allocation != null && !this.allocation.isEmpty()) {
            this.service.save(this.allocation);
            this.allocation = null;
        }
        if (this.claimAllocations != null) {
            for (GapClaimAllocation claimAllocation : this.claimAllocations) {
                GapClaimAllocation.Status status = claimAllocation.getStatus();
                if (status == GapClaimAllocation.Status.ALLOCATION_EQUAL_TO_GAP) {
                    Context context = this.getContext();
                    FinancialAct adjustment = claimAllocation.gapPaid(context.getLocation());
                    if (adjustment == null) continue;
                    this.adjustments.add(adjustment);
                    continue;
                }
                if (status == GapClaimAllocation.Status.FULL_PAYMENT || status == GapClaimAllocation.Status.NO_BENEFIT_FULL_PAYMENT) {
                    claimAllocation.fullyPaid();
                    continue;
                }
                if (!claimAllocation.isPresettledAndAllocationIsGreaterThanGap()) continue;
                throw new IllegalStateException("Claim is pre-settled but the allocation is greater than the gap");
            }
        }
        super.doSave(editor);
    }

    protected InsuranceServices getInsuranceServices() {
        return (InsuranceServices)ServiceHelper.getBean(InsuranceServices.class);
    }

    protected void preSaveAllocation(List<FinancialAct> allocation) {
    }

    protected void postSaveAllocation(List<GapClaimAllocation> claimAllocations) {
        if (!claimAllocations.isEmpty()) {
            this.notifyPayment(claimAllocations);
        }
    }

    protected boolean reload(IMObjectEditor editor) {
        boolean result = false;
        this.allocation = null;
        this.claimAllocations = null;
        this.adjustments.clear();
        if (super.reload(editor)) {
            try {
                for (int i = 0; i < this.debits.size(); ++i) {
                    FinancialAct debit = this.debits.get(i);
                    FinancialAct reloaded = (FinancialAct)IMObjectHelper.reload((IMObject)debit);
                    if (reloaded == null) {
                        throw new IllegalStateException("Failed to reload debit=" + debit.getId());
                    }
                    this.debits.set(i, reloaded);
                }
                result = true;
            }
            catch (Throwable exception) {
                log.error("Failed to reload editor", exception);
            }
        }
        return result;
    }

    List<FinancialAct> getAdjustments() {
        return this.adjustments;
    }

    private void onAllocated(FinancialAct credit, List<FinancialAct> debits, List<GapClaimAllocation> claimAllocations) {
        this.allocation = this.allocator.allocate(credit, debits);
        this.claimAllocations = claimAllocations;
        this.preSaveAllocation(this.allocation);
        if (super.save()) {
            this.close("ok");
            this.postSaveAllocation(claimAllocations);
        }
    }

    private void notifyPayment(List<GapClaimAllocation> allocations) {
        InsuranceServices insuranceServices = this.getInsuranceServices();
        for (GapClaimAllocation allocation : allocations) {
            GapClaimImpl claim = allocation.getClaim();
            Claim.Status status = claim.getStatus();
            if (claim.getGapStatus() != GapClaim.GapStatus.PAID || status != Claim.Status.ACCEPTED && status != Claim.Status.SUBMITTED && status != Claim.Status.PRE_SETTLED) continue;
            Party insurer = allocation.getInsurer();
            try {
                InsuranceService service = insuranceServices.getService(insurer);
                if (service instanceof GapInsuranceService) {
                    ((GapInsuranceService)service).notifyPayment((GapClaim)claim);
                    continue;
                }
                ErrorDialog.show((String)Messages.get((String)"patient.insurance.pay.title"), (String)Messages.format((String)"customer.credit.gap.notificationfailed", (Object[])new Object[]{insurer.getName()}));
            }
            catch (Throwable exception) {
                log.error("Failed to notify {} of gap payment", (Object)insurer.getName(), (Object)exception);
                ErrorDialog.show((String)Messages.get((String)"patient.insurance.pay.title"), (String)Messages.format((String)"customer.credit.gap.notificationfailed", (Object[])new Object[]{insurer.getName()}));
            }
        }
    }
}

