/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.credit;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.List;
import java.util.Map;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.archetype.rules.finance.credit.AllocationBlock;
import org.openvpms.archetype.rules.finance.credit.CreditAllocation;
import org.openvpms.archetype.rules.finance.credit.GapClaimAllocationBlock;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.archetype.ArchetypeDescriptor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.button.CheckBox;
import org.openvpms.web.echo.factory.CheckBoxFactory;
import org.openvpms.web.echo.table.TableHelper;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.NumberFormatter;
import org.openvpms.web.workspace.customer.credit.ChargeAllocationTableModel;

public class BlockedDebitAllocationTableModel
extends ChargeAllocationTableModel {
    private final Map<FinancialAct, AllocationBlock> blocked;
    private final Map<FinancialAct, BigDecimal> allocations;
    private int orderIndex;
    private int allocationIndex;
    private int claimIndex;

    public BlockedDebitAllocationTableModel(CreditAllocation allocation, Map<FinancialAct, BigDecimal> allocations, LayoutContext context) {
        super(context);
        this.allocations = allocations;
        this.blocked = allocation.getBlocked();
    }

    @Override
    protected Object getValue(FinancialAct object, TableColumn column, int row) {
        Object result;
        if (column.getModelIndex() == this.orderIndex) {
            String value = NumberFormatter.format((Number)(row + 1));
            result = TableHelper.rightAlign((String)value);
        } else if (column.getModelIndex() == this.allocationIndex) {
            BigDecimal amount = this.getAllocation(object);
            String value = NumberFormatter.format((Number)amount, (NumberFormat)NumberFormatter.getCurrencyFormat());
            result = TableHelper.rightAlign((String)value);
        } else if (column.getModelIndex() == this.claimIndex) {
            AllocationBlock block = this.getAllocationBlock(object);
            CheckBox box = CheckBoxFactory.create((boolean)(block instanceof GapClaimAllocationBlock));
            box.setEnabled(false);
            result = box;
        } else {
            result = super.getValue(object, column, row);
        }
        return result;
    }

    protected AllocationBlock getAllocationBlock(FinancialAct object) {
        return this.blocked.get(object);
    }

    @Override
    protected TableColumnModel createColumnModel(List<ArchetypeDescriptor> archetypes, LayoutContext context) {
        DefaultTableColumnModel model = (DefaultTableColumnModel)super.createColumnModel(archetypes, context);
        this.orderIndex = this.getNextModelIndex((TableColumnModel)model);
        this.allocationIndex = this.orderIndex + 1;
        this.claimIndex = this.allocationIndex + 1;
        TableColumn order = new TableColumn(this.orderIndex);
        TableColumn allocation = new TableColumn(this.allocationIndex);
        TableColumn plan = new TableColumn(this.claimIndex);
        model.addColumn(order);
        model.moveColumn(model.getColumnCount() - 1, 0);
        allocation.setHeaderValue((Object)Messages.get((String)"customer.credit.allocation"));
        model.addColumn(allocation);
        model.moveColumn(model.getColumnCount() - 1, this.getColumnOffset((TableColumnModel)model, "notes"));
        plan.setHeaderValue((Object)Messages.get((String)"customer.credit.claim"));
        model.addColumn(plan);
        return model;
    }

    private BigDecimal getAllocation(FinancialAct debit) {
        return this.allocations.get(debit);
    }
}

