/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.credit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.SplitPane;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.archetype.rules.finance.account.BalanceCalculator;
import org.openvpms.archetype.rules.finance.credit.AllocationBlock;
import org.openvpms.archetype.rules.finance.credit.CreditAllocation;
import org.openvpms.archetype.rules.finance.credit.GapClaimAllocationBlock;
import org.openvpms.archetype.rules.insurance.InsuranceRules;
import org.openvpms.archetype.rules.practice.LocationRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.insurance.internal.InsuranceFactory;
import org.openvpms.insurance.internal.claim.GapClaimImpl;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.ListResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.relationship.SequencedTable;
import org.openvpms.web.component.im.table.DescriptorTableModel;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.SplitPaneFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.table.TableHelper;
import org.openvpms.web.echo.util.StyleSheetHelper;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.NumberFormatter;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.credit.BlockedDebitAllocationTableModel;
import org.openvpms.web.workspace.customer.credit.GapClaimAllocation;
import org.openvpms.web.workspace.customer.credit.GapClaimAllocationDialog;

public class AllocationDialog
extends PopupDialog {
    private final List<FinancialAct> objects;
    private final Map<FinancialAct, AllocationBlock> blocked;
    private final BalanceCalculator calculator;
    private final BigDecimal total;
    private final Map<FinancialAct, BigDecimal> allocations = new HashMap<FinancialAct, BigDecimal>();
    private final LayoutContext layout;
    private final SplitPane pane;
    private final Extent separator;
    private final Map<FinancialAct, Set<FinancialAct>> claimsToInvoices;
    private final Map<FinancialAct, ClaimState> claimsToState = new HashMap<FinancialAct, ClaimState>();
    private final Component container;
    private List<GapClaimAllocation> gapClaimAllocations;
    private SequencedTable<FinancialAct> sequenced;

    public AllocationDialog(CreditAllocation allocation, Context context, HelpContext help) {
        super(Messages.format((String)"customer.credit.allocate.title", (Object[])new Object[]{allocation.getDisplayName()}), "ChildEditDialog", OK_CANCEL, help);
        this.setModal(true);
        List debits = allocation.getDebits();
        this.objects = new ArrayList<FinancialAct>(debits);
        this.calculator = new BalanceCalculator((IArchetypeService)ServiceHelper.getArchetypeService());
        this.total = this.calculator.getAllocatable(allocation.getCredit());
        this.layout = new DefaultLayoutContext(context, help);
        this.calculateAllocation();
        this.blocked = allocation.getBlocked();
        this.claimsToInvoices = new HashMap<FinancialAct, Set<FinancialAct>>();
        InsuranceFactory factory = (InsuranceFactory)ServiceHelper.getBean(InsuranceFactory.class);
        LocationRules rules = (LocationRules)ServiceHelper.getBean(LocationRules.class);
        for (Map.Entry<FinancialAct, AllocationBlock> entry : this.blocked.entrySet()) {
            FinancialAct invoice = entry.getKey();
            if (!(entry.getValue() instanceof GapClaimAllocationBlock)) continue;
            List claims = ((GapClaimAllocationBlock)entry.getValue()).getGapClaims();
            for (FinancialAct claim : claims) {
                Set invoices = this.claimsToInvoices.computeIfAbsent(claim, k -> new HashSet());
                invoices.add(invoice);
                this.claimsToState.computeIfAbsent(claim, k -> new ClaimState(claim, factory, rules));
            }
        }
        IMTableModel<FinancialAct> model = this.createBlockedTableModel(allocation, this.allocations, this.layout);
        final PagedIMTable table = new PagedIMTable(model);
        table.getTable().addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                AllocationDialog.this.onSelected((FinancialAct)table.getSelected());
            }
        });
        table.setResultSet((ResultSet)new ListResultSet(this.objects, 20));
        Label label = LabelFactory.create((boolean)true, (boolean)true);
        label.setStyleName("bold");
        String reason = this.getAllocationReason(allocation);
        label.setText(Messages.format((String)"customer.credit.allocate.message", (Object[])new Object[]{allocation.getDisplayName(), reason}));
        Column column = ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{label});
        if (this.objects.size() > 1) {
            this.sequenced = new SequencedTable<FinancialAct>(table){

                public List<FinancialAct> getObjects() {
                    return AllocationDialog.this.objects;
                }

                public void swap(FinancialAct object1, FinancialAct object2) {
                    int index1 = AllocationDialog.this.objects.indexOf(object1);
                    int index2 = AllocationDialog.this.objects.indexOf(object2);
                    if (index1 != -1 && index2 != -1) {
                        AllocationDialog.this.objects.set(index2, object1);
                        AllocationDialog.this.objects.set(index1, object2);
                        AllocationDialog.this.calculateAllocation();
                        table.setResultSet(AllocationDialog.this.createResultSet());
                        table.setSelected((Object)object1);
                        this.enableNavigation(true);
                    }
                }
            };
            this.sequenced.layout((Component)column, this.getFocusGroup());
        } else {
            column.add(table.getComponent());
            this.getFocusGroup().add(table.getFocusGroup());
        }
        this.container = ColumnFactory.create((String)"Inset.Large");
        this.pane = SplitPaneFactory.create((int)6, (String)"BrowserCRUDWorkspace.Layout", (Component[])new Component[]{this.container, ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{column})});
        this.separator = StyleSheetHelper.getExtent(SplitPane.class, (String)this.pane.getStyleName(), (String)"separatorPosition");
        this.getLayout().add((Component)this.pane);
        if (!this.objects.isEmpty()) {
            table.setSelected((Object)this.objects.get(0));
            this.onSelected((FinancialAct)table.getSelected());
        } else {
            this.onSelected(null);
        }
    }

    public List<FinancialAct> getDebits() {
        return this.objects;
    }

    public void swap(FinancialAct debit1, FinancialAct debit2) {
        this.sequenced.swap((Object)debit1, (Object)debit2);
    }

    public List<GapClaimAllocation> getGapClaimAllocations() {
        if (this.gapClaimAllocations == null) {
            this.gapClaimAllocations = new ArrayList<GapClaimAllocation>();
            for (Map.Entry<FinancialAct, Set<FinancialAct>> entry : this.claimsToInvoices.entrySet()) {
                FinancialAct claim = entry.getKey();
                Set<FinancialAct> invoices = entry.getValue();
                this.gapClaimAllocations.add(this.createGapClaimAllocation(claim, invoices));
            }
        }
        return this.gapClaimAllocations;
    }

    protected String getAllocationReason(AllocationBlock block) {
        return block instanceof GapClaimAllocationBlock ? Messages.get((String)"customer.credit.allocate.claim") : null;
    }

    protected IMTableModel<FinancialAct> createBlockedTableModel(CreditAllocation allocation, Map<FinancialAct, BigDecimal> allocations, LayoutContext layout) {
        return new BlockedDebitAllocationTableModel(allocation, allocations, layout);
    }

    protected Component getAllocationBlock(FinancialAct charge, AllocationBlock block) {
        if (block instanceof GapClaimAllocationBlock) {
            List claims = ((GapClaimAllocationBlock)block).getGapClaims();
            PagedIMTable table = new PagedIMTable((IMTableModel)new ClaimTableModel(this.layout));
            table.setResultSet((ResultSet)new ListResultSet(claims, 20));
            Label label = LabelFactory.create(null, (String)"bold");
            String displayName = DescriptorHelper.getDisplayName((IMObject)charge, (ArchetypeService)ServiceHelper.getArchetypeService());
            label.setText(Messages.format((String)"customer.credit.allocate.claimedby", (Object[])new Object[]{displayName, claims.size()}));
            return ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{label, table.getComponent()});
        }
        return null;
    }

    protected void onOK() {
        List<GapClaimAllocation> gapClaims = this.getGapClaimAllocations();
        Iterator<GapClaimAllocation> iterator = gapClaims.iterator();
        if (iterator.hasNext()) {
            this.checkGapClaims(iterator, () -> AllocationDialog.super.onOK());
        } else {
            super.onOK();
        }
    }

    private String getAllocationReason(CreditAllocation allocation) {
        String result = null;
        Collection blocks = allocation.getBlocked().values();
        if (!blocks.isEmpty()) {
            result = this.getAllocationReason((AllocationBlock)blocks.iterator().next());
        }
        if (result == null) {
            result = "blocked for an unknown reason";
        }
        return result;
    }

    private GapClaimAllocation createGapClaimAllocation(FinancialAct claim, Set<FinancialAct> invoices) {
        BigDecimal existingAllocation = BigDecimal.ZERO;
        BigDecimal newAllocation = BigDecimal.ZERO;
        for (FinancialAct invoice : invoices) {
            existingAllocation = existingAllocation.add(invoice.getAllocatedAmount());
            newAllocation = newAllocation.add(this.allocations.get(invoice));
        }
        ClaimState state = this.claimsToState.get(claim);
        return new GapClaimAllocation(state.getClaim(), claim, existingAllocation, newAllocation, state.getTill());
    }

    private void checkGapClaims(final Iterator<GapClaimAllocation> iterator, final Runnable onAccept) {
        if (iterator.hasNext()) {
            final GapClaimAllocation allocation = iterator.next();
            if (allocation.isAllocated()) {
                HelpContext help = this.getHelpContext().subtopic("payclaim");
                GapClaimAllocationDialog dialog = new GapClaimAllocationDialog(allocation, help);
                dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                    public void onOK() {
                        if (allocation.getTill() != null) {
                            ClaimState state = (ClaimState)AllocationDialog.this.claimsToState.get(allocation.getAct());
                            state.setTill(allocation.getTill());
                        }
                        AllocationDialog.this.checkGapClaims(iterator, onAccept);
                    }
                });
                dialog.show();
            } else {
                this.checkGapClaims(iterator, onAccept);
            }
        } else {
            onAccept.run();
        }
    }

    private void calculateAllocation() {
        BigDecimal available = this.total;
        for (FinancialAct debit : this.objects) {
            BigDecimal amount;
            BigDecimal allocatable = this.calculator.getAllocatable(debit);
            if (allocatable.compareTo(available) <= 0) {
                available = available.subtract(allocatable);
                amount = allocatable;
            } else {
                amount = available;
                available = BigDecimal.ZERO;
            }
            this.allocations.put(debit, amount);
        }
        this.gapClaimAllocations = null;
    }

    private void onSelected(FinancialAct selected) {
        this.container.removeAll();
        if (this.sequenced != null) {
            this.sequenced.enableNavigation(selected != null);
        }
        AllocationBlock block = this.blocked.get(selected);
        Component component = null;
        if (block != null) {
            component = this.getAllocationBlock(selected, block);
        }
        if (component != null) {
            this.container.add(component);
            this.pane.setSeparatorPosition(this.separator);
            this.pane.setResizable(true);
        } else {
            this.pane.setSeparatorPosition(new Extent(0));
            this.pane.setResizable(false);
        }
    }

    private ResultSet<FinancialAct> createResultSet() {
        return new ListResultSet(this.objects, 20);
    }

    private static class ClaimState {
        private final GapClaimImpl claim;
        private Entity till;

        ClaimState(FinancialAct claim, InsuranceFactory factory, LocationRules rules) {
            this.claim = (GapClaimImpl)factory.createClaim((Act)claim);
            Party location = this.claim.getLocationParty();
            this.till = rules.getGapBenefitTill(location);
        }

        public GapClaimImpl getClaim() {
            return this.claim;
        }

        Entity getTill() {
            return this.till;
        }

        void setTill(Entity till) {
            this.till = till;
        }
    }

    private static class ClaimTableModel
    extends DescriptorTableModel<FinancialAct> {
        private final InsuranceRules rules = (InsuranceRules)ServiceHelper.getBean(InsuranceRules.class);
        private int gapIndex;

        ClaimTableModel(LayoutContext context) {
            super(new String[]{"act.patientInsuranceClaim"}, context);
        }

        protected TableColumnModel createColumnModel(String[] shortNames, LayoutContext context) {
            TableColumnModel model = super.createColumnModel(shortNames, context);
            this.gapIndex = this.getNextModelIndex(model);
            TableColumn gapColumn = ClaimTableModel.createTableColumn((int)this.gapIndex, (String)"patient.insurance.pay.gap");
            model.addColumn(gapColumn);
            model.moveColumn(model.getColumnCount() - 1, this.getColumnOffset(model, "benefitNotes"));
            return model;
        }

        protected ArchetypeNodes getArchetypeNodes() {
            return ArchetypeNodes.onlySimple((String[])new String[]{"startTime", "patient", "insurerId", "createdBy", "amount", "status", "status2", "benefitAmount", "benefitNotes"}).hidden(true);
        }

        protected Object getValue(FinancialAct object, TableColumn column, int row) {
            if (column.getModelIndex() == this.gapIndex) {
                return this.getGapAmount(object);
            }
            return super.getValue((IMObject)object, column, row);
        }

        private Object getGapAmount(FinancialAct claim) {
            if (this.rules.hasBenefitAmount(claim)) {
                String result = NumberFormatter.formatCurrency((Number)this.rules.getGapAmount(claim));
                return TableHelper.rightAlign((String)result);
            }
            return null;
        }
    }
}

