/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.communication;

import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.web.component.mail.DefaultMailer;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.mail.Mailer;
import org.openvpms.web.component.mail.MailerFactory;
import org.openvpms.web.component.service.CurrentLocationMailService;
import org.openvpms.web.component.service.MailService;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.communication.CommunicationHelper;
import org.openvpms.web.workspace.customer.communication.CommunicationLogger;
import org.openvpms.web.workspace.customer.communication.LoggingMailer;
import org.springframework.mail.javamail.JavaMailSender;

public class LoggingMailerFactory
implements MailerFactory {
    private final DocumentHandlers handlers;
    private final CommunicationLogger logger;
    private final PracticeService practiceService;
    private final IArchetypeService service;

    public LoggingMailerFactory(DocumentHandlers handlers, CommunicationLogger logger, PracticeService practiceService, IArchetypeService service) {
        this.handlers = handlers;
        this.logger = logger;
        this.practiceService = practiceService;
        this.service = service;
    }

    public Mailer create(MailContext context) {
        Mailer result = this.isLoggingEnabled() ? this.createLoggingMailer(context, this.logger) : this.createMailer(context);
        return result;
    }

    public Mailer create(MailContext context, JavaMailSender sender) {
        Mailer result = this.isLoggingEnabled() ? this.createLoggingMailer(context, sender, this.logger) : this.createMailer(context, sender);
        return result;
    }

    protected LoggingMailer createLoggingMailer(MailContext context, CommunicationLogger logger) {
        return new LoggingMailer(context, (JavaMailSender)this.getMailService(), this.getDocumentHandlers(), logger);
    }

    protected LoggingMailer createLoggingMailer(MailContext context, JavaMailSender sender, CommunicationLogger logger) {
        return new LoggingMailer(context, sender, this.getDocumentHandlers(), logger);
    }

    protected Mailer createMailer(MailContext context) {
        return new DefaultMailer(context, (JavaMailSender)this.getMailService(), this.getDocumentHandlers());
    }

    protected Mailer createMailer(MailContext context, JavaMailSender sender) {
        return new DefaultMailer(context, sender, this.getDocumentHandlers());
    }

    protected MailService getMailService() {
        return (MailService)ServiceHelper.getBean(CurrentLocationMailService.class);
    }

    protected DocumentHandlers getDocumentHandlers() {
        return this.handlers;
    }

    private boolean isLoggingEnabled() {
        return CommunicationHelper.isLoggingEnabled(this.practiceService, this.service);
    }
}

