/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.system.common.cache.IMObjectCache;
import org.openvpms.hl7.pharmacy.Pharmacies;
import org.openvpms.web.system.ServiceHelper;

class PharmacyProducts {
    private final Pharmacies pharmacies;
    private final Party location;
    private final IMObjectCache cache;

    public PharmacyProducts(Pharmacies pharmacies, Party location, IMObjectCache cache) {
        this.pharmacies = pharmacies;
        this.location = location;
        this.cache = cache;
    }

    public Entity getPharmacy(Product product) {
        Entity pharmacy = null;
        if (TypeHelper.isA((IMObject)product, (String[])new String[]{"product.medication", "product.merchandise"})) {
            Entity type;
            IArchetypeRuleService service = ServiceHelper.getArchetypeService();
            IMObjectBean bean = service.getBean((IMObject)product);
            pharmacy = (Entity)this.cache.get(bean.getTargetRef("pharmacy"));
            if (pharmacy == null && (type = (Entity)this.cache.get(bean.getTargetRef("type"))) != null) {
                IMObjectBean typeBean = service.getBean((IMObject)type);
                pharmacy = (Entity)this.cache.get(typeBean.getTargetRef("pharmacy"));
            }
            if (pharmacy != null && pharmacy.isA("entity.HL7ServicePharmacyGroup")) {
                pharmacy = this.pharmacies.getService(pharmacy, this.location.getObjectReference());
            }
        }
        return pharmacy;
    }
}

