/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.doc.DocumentViewer;
import org.openvpms.web.component.im.doc.DocumentViewerFactory;
import org.openvpms.web.component.im.edit.IMObjectTableCollectionEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.table.DefaultDescriptorTableModel;
import org.openvpms.web.component.im.table.DescriptorTableColumn;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.view.IMObjectComponentFactory;
import org.openvpms.web.component.im.view.TableComponentFactory;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.echo.button.ButtonRow;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.charge.InvestigationManager;

public class InvestigationCollectionEditor
extends IMObjectTableCollectionEditor {
    private final InvestigationManager investigations;

    public InvestigationCollectionEditor(InvestigationManager investigations, IMObject object, LayoutContext context) {
        super(investigations.getEditor(), object, context);
        this.investigations = investigations;
        investigations.setReloadListener(this::reload);
    }

    public void dispose() {
        super.dispose();
        this.investigations.setReloadListener(null);
    }

    protected IMTableModel<IMObject> createTableModel(LayoutContext context) {
        context = new DefaultLayoutContext(context);
        context.setComponentFactory((IMObjectComponentFactory)new TableComponentFactory(context));
        return new InvestigationTableModel(context);
    }

    protected void addButtons(ButtonRow buttons) {
        super.addButtons(buttons);
        buttons.getButtons().remove("add");
    }

    protected void onModified(Modifiable modifiable) {
        super.onModified(modifiable);
        this.refresh();
    }

    private void reload() {
        IMObject object = this.getSelected();
        this.refresh(true);
        if (object != null) {
            this.removeCurrentEditor();
            this.edit(object);
        }
    }

    private class InvestigationTableModel
    extends DefaultDescriptorTableModel<IMObject> {
        private final DocumentViewerFactory factory;

        public InvestigationTableModel(LayoutContext context) {
            super(InvestigationCollectionEditor.this.getProperty().getArchetypeRange(), context, new String[]{"startTime", "investigationType", "status", "status2", "clinician", "document"});
            this.factory = (DocumentViewerFactory)ServiceHelper.getBean(DocumentViewerFactory.class);
        }

        protected Object getValue(IMObject object, DescriptorTableColumn column, int row) {
            Object result;
            if ("document".equals(column.getName())) {
                DocumentViewer viewer = this.factory.create((DocumentAct)object, true, InvestigationCollectionEditor.this.getContext());
                viewer.setShowNoDocument(false);
                result = viewer.getComponent();
            } else {
                result = super.getValue(object, column, row);
            }
            return result;
        }
    }
}

