/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.openvpms.archetype.rules.laboratory.LaboratoryRules;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.laboratory.internal.service.OrderValidationService;
import org.openvpms.web.component.im.edit.CollectionPropertyEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.util.IMObjectSorter;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.StockOnHand;
import org.openvpms.web.workspace.customer.charge.Alerts;
import org.openvpms.web.workspace.customer.charge.ChargeEditContext;
import org.openvpms.web.workspace.customer.charge.ChargeSaveContext;
import org.openvpms.web.workspace.customer.charge.InvestigationManager;
import org.openvpms.web.workspace.customer.charge.InvestigationManagerImpl;
import org.openvpms.web.workspace.patient.mr.Prescriptions;

public class CustomerChargeEditContext
extends ChargeEditContext {
    private final ChargeSaveContext saveContext;
    private final Alerts alerts;
    private final StockOnHand stock;
    private final ReminderRules reminderRules;
    private final InvestigationManager investigationManager;
    private Prescriptions prescriptions;

    public CustomerChargeEditContext(Party customer, Party location, LayoutContext context) {
        super(customer, location, context);
        IArchetypeRuleService archetypeService = ServiceHelper.getArchetypeService();
        this.saveContext = new ChargeSaveContext((IArchetypeService)archetypeService, context);
        this.investigationManager = new InvestigationManagerImpl((IArchetypeService)archetypeService, (LaboratoryRules)ServiceHelper.getBean(LaboratoryRules.class), (OrderValidationService)ServiceHelper.getBean(OrderValidationService.class), context);
        this.investigationManager.getEditor().setRemoveHandler((CollectionPropertyEditor.RemoveHandler)this.saveContext);
        this.reminderRules = new ReminderRules(this.getCachingArchetypeService(), (PatientRules)ServiceHelper.getBean(PatientRules.class));
        this.stock = new StockOnHand(this.getStockRules());
        this.alerts = new Alerts();
    }

    public ChargeSaveContext getSaveContext() {
        return this.saveContext;
    }

    public StockOnHand getStock() {
        return this.stock;
    }

    public void setPrescriptions(Prescriptions prescriptions) {
        this.prescriptions = prescriptions;
    }

    public Prescriptions getPrescriptions() {
        return this.prescriptions;
    }

    public Alerts getAlerts() {
        return this.alerts;
    }

    public Map<Entity, Relationship> getReminderTypes(Product product, Party patient) {
        String species = patient != null ? this.getCachingArchetypeService().getBean((IMObject)patient).getString("species") : null;
        Map map = this.reminderRules.getReminderTypes(product, species);
        TreeMap<Entity, Relationship> result = new TreeMap<Entity, Relationship>(IMObjectSorter.getNameComparator((boolean)true));
        result.putAll(map);
        return result;
    }

    public Date getReminderDueDate(Date startTime, Relationship relationship) {
        return this.reminderRules.calculateProductReminderDueDate(startTime, relationship);
    }

    public InvestigationManager getInvestigations() {
        return this.investigationManager;
    }
}

