/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.event.WindowPaneListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.bound.BoundProperty;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.edit.PropertyEditor;
import org.openvpms.web.component.im.edit.CollectionPropertyEditor;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.Quantity;
import org.openvpms.web.component.im.edit.act.ActRelationshipCollectionEditor;
import org.openvpms.web.component.im.edit.act.ParticipationCollectionEditor;
import org.openvpms.web.component.im.edit.act.ParticipationEditor;
import org.openvpms.web.component.im.edit.act.TemplateProduct;
import org.openvpms.web.component.im.edit.reminder.ReminderEditor;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.product.BatchParticipationEditor;
import org.openvpms.web.component.im.product.FixedPriceEditor;
import org.openvpms.web.component.im.product.ProductParticipationEditor;
import org.openvpms.web.component.im.util.LookupNameHelper;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.focus.FocusHelper;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.customer.PriceActItemEditor;
import org.openvpms.web.workspace.customer.charge.AlertActRelationshipCollectionEditor;
import org.openvpms.web.workspace.customer.charge.Alerts;
import org.openvpms.web.workspace.customer.charge.ChargeItemDocumentManager;
import org.openvpms.web.workspace.customer.charge.ChargeSaveContext;
import org.openvpms.web.workspace.customer.charge.CustomerChargeEditContext;
import org.openvpms.web.workspace.customer.charge.DispensingActRelationshipCollectionEditor;
import org.openvpms.web.workspace.customer.charge.EditorQueue;
import org.openvpms.web.workspace.customer.charge.InvestigationManager;
import org.openvpms.web.workspace.customer.charge.ReminderActRelationshipCollectionEditor;
import org.openvpms.web.workspace.customer.charge.StockQuantity;
import org.openvpms.web.workspace.customer.charge.TaskActRelationshipCollectionEditor;
import org.openvpms.web.workspace.customer.charge.department.DepartmentListener;
import org.openvpms.web.workspace.patient.PatientIdentityEditor;
import org.openvpms.web.workspace.patient.investigation.PatientInvestigationActEditor;
import org.openvpms.web.workspace.patient.mr.PatientAlertEditor;
import org.openvpms.web.workspace.patient.mr.PatientMedicationActEditor;
import org.openvpms.web.workspace.patient.mr.PrescriptionMedicationActEditor;
import org.openvpms.web.workspace.patient.mr.Prescriptions;
import org.openvpms.web.workspace.workflow.worklist.TaskActEditor;

public abstract class CustomerChargeActItemEditor
extends PriceActItemEditor {
    private final ParticipationCollectionEditor productCollectionEditor;
    private final ModifiableListener quantityListener;
    private final ModifiableListener calculationListener;
    private final ModifiableListener discountListener;
    private final ModifiableListener totalListener;
    private final ModifiableListener batchListener;
    private final Quantity quantity;
    private final StockQuantity stockQuantity;
    private final InvestigationManager investigations;
    private final DispensingActRelationshipCollectionEditor dispensing;
    private final ActRelationshipCollectionEditor reminders;
    private final ActRelationshipCollectionEditor alerts;
    private final TaskActRelationshipCollectionEditor tasks;
    private final ChargeItemDocumentManager documents;
    private final Label sellingUnits;
    private BigDecimal previousQuantity;
    private Button medicationButton;
    private boolean promptForPrescription = true;
    private boolean cancelPrescription;
    private DepartmentListener departmentListener;
    private static final Log log = LogFactory.getLog(CustomerChargeActItemEditor.class);
    private static final String DEPARTMENT = "department";
    private static final String DISPENSING = "dispensing";
    private static final String REMINDERS = "reminders";
    private static final String ALERTS = "alerts";
    private static final String TASKS = "tasks";
    private static final String RETURNED_QUANTITY = "returnedQuantity";
    private static final String RECEIVED_QUANTITY = "receivedQuantity";
    private static final String[] ORDER_NODES = new String[]{"receivedQuantity", "returnedQuantity"};
    private static final String INVESTIGATIONS = "investigations";
    private static final String DOCUMENTS = "documents";
    private static final String FIXED_COST = "fixedCost";
    private static final String UNIT_COST = "unitCost";
    private static final String TAX = "tax";
    private static final String TOTAL = "total";
    private static final String PRINT_AGGREGATE = "printAggregate";
    private static final String STOCK_LOCATION = "stockLocation";
    private static final String BATCH = "batch";
    private static final ArchetypeNodes TEMPLATE_NODES = new ArchetypeNodes().exclude(new String[]{"quantity", "fixedPrice", "unitPrice", "discount", "clinician", "total", "dispensing", "reminders", "alerts", "tasks", "batch"});
    private static final String PATIENT_IDENTITY = "patientIdentity";

    public CustomerChargeActItemEditor(FinancialAct act, Act parent, CustomerChargeEditContext context, LayoutContext layoutContext) {
        super((Act)act, parent, context, layoutContext);
        if (!act.isA(new String[]{"act.customerAccountInvoiceItem", "act.customerAccountCreditItem", "act.customerAccountCounterItem"})) {
            throw new IllegalArgumentException("Invalid act type:" + act.getArchetype());
        }
        Property quantityProperty = this.getProperty("quantity");
        LayoutContext layout = this.getLayoutContext();
        this.previousQuantity = quantityProperty.getBigDecimal(BigDecimal.ZERO);
        this.quantity = new Quantity(quantityProperty, (IMObject)act, layout);
        this.stockQuantity = new StockQuantity(act, context.getStock(), layout);
        this.productCollectionEditor = this.createProductCollectionEditor();
        this.dispensing = this.createDispensingCollectionEditor();
        this.reminders = this.createRemindersCollectionEditor();
        this.alerts = this.createAlertsCollectionEditor();
        this.tasks = this.createTaskCollectionEditor();
        this.documents = this.createDocumentsManager(context.getSaveContext());
        this.investigations = act.isA("act.customerAccountInvoiceItem") ? context.getInvestigations() : null;
        this.quantityListener = modifiable -> this.onQuantityChanged();
        if (this.dispensing != null) {
            this.dispensing.setPrescriptions(context.getPrescriptions());
            this.medicationButton = ButtonFactory.text((String)this.dispensing.getProperty().getDisplayName(), this::editMedication);
        }
        ChargeSaveContext saveContext = context.getSaveContext();
        if (this.dispensing != null) {
            this.dispensing.getEditor().setRemoveHandler((CollectionPropertyEditor.RemoveHandler)saveContext);
        }
        if (this.reminders != null) {
            this.reminders.getEditor().setRemoveHandler((CollectionPropertyEditor.RemoveHandler)saveContext);
        }
        if (this.alerts != null) {
            this.alerts.getEditor().setRemoveHandler((CollectionPropertyEditor.RemoveHandler)saveContext);
        }
        if (this.tasks != null) {
            this.tasks.getEditor().setRemoveHandler((CollectionPropertyEditor.RemoveHandler)saveContext);
        }
        this.sellingUnits = LabelFactory.create();
        if (act.isNew()) {
            act.setActivityStartTime(new Date());
        }
        this.calculateTotal();
        this.calculateTax();
        Product product = this.getProduct();
        if (product != null) {
            this.initStockLocation(product);
        }
        ArchetypeNodes nodes = this.getFilterForProduct(product, this.getQuantity(), this.updatePrint(product));
        this.setArchetypeNodes(nodes);
        this.discountListener = modifiable -> this.calculateTotal();
        this.getProperty("discount").addModifiableListener(this.discountListener);
        this.totalListener = modifiable -> this.onTotalChanged();
        this.getProperty(TOTAL).addModifiableListener(this.totalListener);
        this.calculationListener = this::recalculate;
        this.getProperty("fixedPrice").addModifiableListener(this.calculationListener);
        quantityProperty.addModifiableListener(this.calculationListener);
        this.getProperty("unitPrice").addModifiableListener(this.calculationListener);
        quantityProperty.addModifiableListener(this.quantityListener);
        this.batchListener = modifiable -> this.updateMedicationBatch(this.getStockLocationRef());
        this.updateOnHandQuantity();
        this.addStartEndTimeListeners();
    }

    public FinancialAct getObject() {
        return (FinancialAct)super.getObject();
    }

    @Override
    public void setProduct(TemplateProduct product, Product template, int group) {
        super.setProduct(product, template, group);
        if (product != null && !product.getPrint() && MathRules.isZero((BigDecimal)this.getTotal())) {
            this.setPrint(false);
        }
    }

    public Entity getBatch() {
        return this.getParticipant(BATCH);
    }

    public void setBatch(Entity batch) {
        this.setParticipant(BATCH, batch);
    }

    public boolean isDefaultQuantity() {
        return this.quantity.isDefault();
    }

    public Entity getDepartment() {
        return this.getParticipant(DEPARTMENT);
    }

    public void setDepartment(Entity department) {
        this.setParticipant(DEPARTMENT, department);
    }

    public Reference getDepartmentRef() {
        return this.getParticipantRef(DEPARTMENT);
    }

    public BigDecimal getTotal() {
        return this.getProperty(TOTAL).getBigDecimal(BigDecimal.ZERO);
    }

    public boolean isOrdered() {
        return this.getStatus() != null;
    }

    public BigDecimal getReceivedQuantity() {
        Property property = this.getProperty(RECEIVED_QUANTITY);
        return property != null ? property.getBigDecimal(BigDecimal.ZERO) : BigDecimal.ZERO;
    }

    public void setReceivedQuantity(BigDecimal quantity) {
        Property property = this.getProperty(RECEIVED_QUANTITY);
        if (property != null) {
            property.setValue((Object)quantity);
        }
    }

    public BigDecimal getReturnedQuantity() {
        Property property = this.getProperty(RETURNED_QUANTITY);
        return property != null ? property.getBigDecimal(BigDecimal.ZERO) : BigDecimal.ZERO;
    }

    public void setReturnedQuantity(BigDecimal quantity) {
        Property property = this.getProperty(RETURNED_QUANTITY);
        if (property != null) {
            property.setValue((Object)quantity);
        }
    }

    public Act getMedication() {
        List acts;
        Act result = null;
        if (this.dispensing != null && !(acts = this.dispensing.getActs()).isEmpty()) {
            result = (Act)acts.get(0);
        }
        return result;
    }

    public List<DocumentAct> getInvestigations() {
        return this.investigations != null ? this.investigations.getInvestigations(this.getObject()) : Collections.emptyList();
    }

    public List<Act> getDocuments() {
        return this.documents != null ? this.documents.getDocuments() : Collections.emptyList();
    }

    public PatientInvestigationActEditor getInvestigation(Reference investigationRef) {
        return this.investigations != null ? this.investigations.getEditor(investigationRef) : null;
    }

    public BigDecimal getStock() {
        return this.getEditContext().getStock().getAvailableStock(this.getObject());
    }

    public void dispose() {
        super.dispose();
        this.getProperty(TOTAL).removeModifiableListener(this.totalListener);
        this.getProperty("discount").removeModifiableListener(this.discountListener);
        this.getProperty("fixedPrice").removeModifiableListener(this.calculationListener);
        this.getProperty("quantity").removeModifiableListener(this.calculationListener);
        this.getProperty("unitPrice").removeModifiableListener(this.calculationListener);
        this.getProperty("quantity").removeModifiableListener(this.quantityListener);
    }

    public boolean validate(Validator validator) {
        EditorQueue queue = this.getEditorQueue();
        return (queue == null || queue.isComplete()) && super.validate(validator) && this.validateProduct(validator);
    }

    public void setEditorQueue(EditorQueue queue) {
        this.getEditContext().setEditorQueue(queue);
    }

    public EditorQueue getEditorQueue() {
        return this.getEditContext().getEditorQueue();
    }

    public Prescriptions getPrescriptions() {
        return this.getEditContext().getPrescriptions();
    }

    public void setPromptForPrescriptions(boolean prompt) {
        this.promptForPrescription = prompt;
    }

    public void setCancelPrescription(boolean cancel) {
        this.cancelPrescription = cancel;
    }

    public List<Act> getReminders() {
        return this.reminders != null ? this.reminders.getCurrentActs() : Collections.emptyList();
    }

    public Reference getStockLocationRef() {
        return this.getParticipantRef(STOCK_LOCATION);
    }

    public void ordered() {
        ProductParticipationEditor productEditor = this.getProductEditor();
        if (productEditor != null) {
            productEditor.setReadOnly(true);
        }
        this.updateLayout(true);
    }

    @Override
    public CustomerChargeEditContext getEditContext() {
        return (CustomerChargeEditContext)super.getEditContext();
    }

    public ChargeSaveContext getSaveContext() {
        return this.getEditContext().getSaveContext();
    }

    public void updateOnHandQuantity() {
        this.stockQuantity.refresh();
    }

    public void addInvestigation(PatientInvestigationActEditor editor) {
        DocumentAct investigation = editor.getObject();
        Reference investigationRef = investigation.getObjectReference();
        CollectionProperty property = this.getCollectionProperty(INVESTIGATIONS);
        boolean found = false;
        for (ActRelationship relationship : property.getValues(ActRelationship.class)) {
            if (!Objects.equals(investigationRef, relationship.getTarget())) continue;
            found = true;
            break;
        }
        if (!found) {
            ActRelationship relationship = (ActRelationship)this.create("actRelationship.invoiceItemInvestigation", ActRelationship.class);
            relationship.setSource(this.getObject().getObjectReference());
            relationship.setTarget(investigationRef);
            property.add((Object)relationship);
            editor.getCollectionProperty("invoiceItems").add((Object)relationship);
        }
    }

    public void setDepartmentListener(DepartmentListener listener) {
        this.departmentListener = listener;
    }

    protected ReminderEditor getReminderEditor(Reference reminder) {
        if (this.reminders != null) {
            for (ReminderEditor editor : this.getReminderEditors()) {
                if (!editor.getObject().getObjectReference().equals((Object)reminder)) continue;
                return editor;
            }
        }
        return null;
    }

    @Override
    protected boolean updateDiscount() {
        boolean updated = super.updateDiscount();
        BigDecimal discount = this.getProperty("discount").getBigDecimal(BigDecimal.ZERO);
        if (updated && discount.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal fixedPriceMaxDiscount = this.getFixedPriceMaxDiscount(null);
            BigDecimal unitPriceMaxDiscount = this.getUnitPriceMaxDiscount(null);
            if (fixedPriceMaxDiscount != null && !MathRules.equals((BigDecimal)fixedPriceMaxDiscount, (BigDecimal)MathRules.ONE_HUNDRED) || unitPriceMaxDiscount != null && !MathRules.equals((BigDecimal)unitPriceMaxDiscount, (BigDecimal)MathRules.ONE_HUNDRED)) {
                BigDecimal salePrice;
                BigDecimal quantity = this.getQuantity();
                BigDecimal fixedCost = this.getFixedCost();
                BigDecimal fixedPrice = this.getFixedPrice();
                BigDecimal unitCost = this.getUnitCost();
                BigDecimal unitPrice = this.getUnitPrice();
                BigDecimal costPrice = fixedCost.add(unitCost.multiply(quantity));
                if (costPrice.compareTo((salePrice = fixedPrice.add(unitPrice.multiply(quantity))).subtract(discount)) > 0) {
                    ConfirmationDialog dialog = new ConfirmationDialog(Messages.get((String)"customer.charge.discount.title"), Messages.get((String)"customer.charge.discount.message"), ConfirmationDialog.YES_NO);
                    dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                        public void onYes() {
                            CustomerChargeActItemEditor.this.getProperty("discount").setValue((Object)BigDecimal.ZERO);
                            super.onYes();
                        }
                    });
                    this.getEditorQueue().queue((IMObject)this.getObject(), (PopupDialog)dialog);
                }
            }
        }
        return updated;
    }

    @Override
    protected void doSave() {
        ChargeSaveContext saveContext;
        if (log.isDebugEnabled()) {
            log.debug((Object)("doSave: state=" + this.debugString()));
        }
        if (this.getObject().isA("act.customerAccountInvoiceItem") && (saveContext = this.getSaveContext()).getHistoryChanges() == null) {
            throw new IllegalStateException("PatientHistoryChanges haven't been registered");
        }
        super.doSave();
        this.getEditContext().getStock().remove(this.getObject());
    }

    protected ActRelationshipCollectionEditor getDispensingEditor() {
        return this.dispensing;
    }

    @Override
    protected IMObjectLayoutStrategy createLayoutStrategy(FixedPriceEditor fixedPrice, PriceActItemEditor.ServiceRatioEditor serviceRatioEditor) {
        return new CustomerChargeItemLayoutStrategy(fixedPrice, serviceRatioEditor);
    }

    @Override
    protected void onLayoutCompleted() {
        super.onLayoutCompleted();
        this.monitorParticipation("patient", this::updatePatientActsPatient);
        this.monitorParticipation("clinician", this::updatePatientActsClinician);
        if (this.getEditContext().useDepartments()) {
            this.monitorParticipation(DEPARTMENT, this::onDepartmentChanged);
        }
        Product product = this.getProduct();
        this.updateBatch(product, this.getStockLocationRef());
        Prescriptions prescriptions = this.getPrescriptions();
        PrescriptionMedicationActEditor medicationEditor = this.getMedicationEditor();
        if (prescriptions != null && medicationEditor != null) {
            medicationEditor.setPrescriptions(prescriptions);
        }
        this.showMedicationButton(product);
    }

    @Override
    protected void productModified(Product product) {
        BigDecimal dose;
        Party patient;
        this.getProperty("fixedPrice").removeModifiableListener(this.calculationListener);
        this.getProperty("quantity").removeModifiableListener(this.calculationListener);
        this.getProperty("unitPrice").removeModifiableListener(this.calculationListener);
        this.getProperty("discount").removeModifiableListener(this.discountListener);
        this.getProperty(TOTAL).removeModifiableListener(this.totalListener);
        super.productModified(product);
        boolean clearDefault = true;
        if (TypeHelper.isA((IMObject)product, (String)"product.medication") && (patient = this.getPatient()) != null && !MathRules.isZero((BigDecimal)(dose = this.getDose(product, patient)))) {
            this.quantity.setValue(dose, true);
            clearDefault = false;
        }
        if (clearDefault) {
            this.quantity.clearDefault();
        }
        Property discount = this.getProperty("discount");
        discount.setValue((Object)BigDecimal.ZERO);
        this.updatePrices(product);
        if (product != null && product.isA("product.template")) {
            this.updateSellingUnits(null);
        } else {
            Reference stockLocation = this.updateStockLocation(product);
            this.updateSellingUnits(product);
            this.updateBatch(product, stockLocation);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("productModified: " + this.debugString()));
        }
        this.getProperty("fixedPrice").addModifiableListener(this.calculationListener);
        this.getProperty("quantity").addModifiableListener(this.calculationListener);
        this.getProperty("unitPrice").addModifiableListener(this.calculationListener);
        this.getProperty("discount").addModifiableListener(this.discountListener);
        this.getProperty(TOTAL).addModifiableListener(this.totalListener);
        this.updateDependencies(product);
        ProductParticipationEditor productEditor = this.getProductEditor();
        if (productEditor != null) {
            productEditor.setReadOnly(this.isProductReadOnly());
        }
        this.updateLayout(product, false);
        this.notifyProductListener(product);
    }

    protected void onStartTimeChanged() {
        super.onStartTimeChanged();
        this.updateServiceRatio();
        this.updateActsStartTime();
    }

    @Override
    protected void serviceRatioModified() {
        super.serviceRatioModified();
        this.updatePrices(this.getProduct());
    }

    protected void updatePrices(Product product) {
        Property fixedPrice = this.getProperty("fixedPrice");
        Property unitPrice = this.getProperty("unitPrice");
        Property fixedCost = this.getProperty(FIXED_COST);
        Property unitCost = this.getProperty(UNIT_COST);
        ProductPrice fixedProductPrice = null;
        ProductPrice unitProductPrice = null;
        BigDecimal fixedPriceValue = BigDecimal.ZERO;
        BigDecimal fixedCostValue = BigDecimal.ZERO;
        BigDecimal unitPriceValue = BigDecimal.ZERO;
        BigDecimal unitCostValue = BigDecimal.ZERO;
        if (TypeHelper.isA((IMObject)product, (String)"product.template")) {
            fixedPrice.setValue((Object)fixedPriceValue);
            unitPrice.setValue((Object)unitPriceValue);
            fixedCost.setValue((Object)fixedCostValue);
            unitCost.setValue((Object)unitCostValue);
        } else {
            if (product != null) {
                fixedProductPrice = this.getDefaultFixedProductPrice(product);
                unitProductPrice = this.getDefaultUnitProductPrice(product);
            }
            BigDecimal serviceRatio = this.getServiceRatio();
            if (fixedProductPrice != null) {
                fixedPriceValue = this.getPrice(product, fixedProductPrice, serviceRatio);
                fixedCostValue = this.getCost(fixedProductPrice);
            }
            fixedPrice.setValue((Object)fixedPriceValue);
            fixedCost.setValue((Object)fixedCostValue);
            if (unitProductPrice != null) {
                unitPriceValue = this.getPrice(product, unitProductPrice, serviceRatio);
                unitCostValue = this.getCost(unitProductPrice);
            }
            unitPrice.setValue((Object)unitPriceValue);
            unitCost.setValue((Object)unitCostValue);
            this.updateDiscount();
        }
        this.calculateTotal();
        this.updateTaxAmount();
        if (log.isDebugEnabled()) {
            String fixedStr = fixedProductPrice != null ? "id=" + fixedProductPrice.getId() + ", price=" + fixedProductPrice.getPrice() : null;
            String unitStr = unitProductPrice != null ? "id=" + unitProductPrice.getId() + ", price=" + unitProductPrice.getPrice() : null;
            log.debug((Object)("fixedProductPrice=[" + fixedStr + "], unitProductPrice=[" + unitStr + "]"));
        }
    }

    protected void calculateTotal() {
        BigDecimal fixedPrice = this.getFixedPrice();
        BigDecimal discount = this.getDiscount();
        BigDecimal quantity = this.getQuantity();
        BigDecimal unitPrice = this.getUnitPrice();
        BigDecimal total = this.getEditContext().calculateTotal(fixedPrice, unitPrice, quantity, discount);
        this.getProperty(TOTAL).setValue((Object)total);
    }

    protected void calculateTax() {
        Party customer = this.getCustomer();
        if (customer != null && this.getProductRef() != null) {
            FinancialAct act = this.getObject();
            BigDecimal previousTax = act.getTaxAmount();
            BigDecimal tax = this.calculateTax(customer);
            if (tax.compareTo(previousTax) != 0) {
                Property property = this.getProperty(TAX);
                property.refresh();
            }
        }
    }

    protected BatchParticipationEditor getBatchEditor() {
        return this.getBatchEditor(true);
    }

    protected BatchParticipationEditor getBatchEditor(boolean create) {
        ParticipationEditor editor = this.getParticipationEditor(BATCH, create);
        return (BatchParticipationEditor)editor;
    }

    @Override
    protected boolean isProductReadOnly() {
        return this.isOrdered() || super.isProductReadOnly();
    }

    @Override
    protected BigDecimal getAvailableServiceRatio(Product product) {
        Entity department = null;
        if (this.getEditContext().useDepartments() && (department = this.getDepartment()) == null && this.getObject().isNew()) {
            department = this.getLayoutContext().getContext().getDepartment();
        }
        return this.getServiceRatio(product, department);
    }

    @Override
    protected BigDecimal getServiceRatio(Product product) {
        return this.getServiceRatio(product, this.getDepartment());
    }

    private boolean validateProduct(Validator validator) {
        Product product;
        boolean result = true;
        CustomerChargeEditContext editContext = this.getEditContext();
        if (this.getObject().isA("act.customerAccountCounterItem") && !editContext.sellRestrictedDrugsOTC() && (product = this.getProduct()) != null && editContext.isRestricted(product)) {
            validator.add((Modifiable)this, Messages.format((String)"customer.charge.medication.nosaleOTC", (Object[])new Object[]{product.getName()}));
            result = false;
        }
        return result;
    }

    private void showMedicationButton(Product product) {
        if (this.medicationButton != null) {
            boolean visible = product != null && product.isA("product.medication") && !this.quantity.isNegative();
            this.medicationButton.setVisible(visible);
        }
    }

    private void updateDependencies(Product product) {
        this.updatePatientMedication(product);
        this.updateInvestigations(product);
        this.updateReminders(product);
        this.updateAlerts(product);
        this.updateTasks(product);
        this.updateOnHandQuantity();
        if (product != null) {
            this.addPatientIdentity(product);
        }
        this.updateDocuments();
    }

    private void recalculate(Modifiable modifiable) {
        this.getProperty("discount").removeModifiableListener(this.discountListener);
        if (log.isDebugEnabled() && modifiable instanceof Property) {
            Property property = (Property)modifiable;
            Object value = property.getValue();
            this.updateDiscount();
            log.debug((Object)("Property updated, name=" + property.getName() + ", value=" + value + ", state=" + this.debugString()));
        } else {
            this.updateDiscount();
        }
        this.calculateTotal();
        this.getProperty("discount").addModifiableListener(this.discountListener);
    }

    private void onTotalChanged() {
        this.updateTaxAmount();
        this.updateLayout(false);
    }

    private void updateTaxAmount() {
        try {
            this.calculateTax();
        }
        catch (OpenVPMSException exception) {
            ErrorHelper.show((Throwable)exception);
        }
    }

    private void updateActsStartTime() {
        Product product;
        FinancialAct parent = this.getObject();
        PrescriptionMedicationActEditor medication = this.getMedicationEditor();
        if (medication != null) {
            medication.setStartTime(parent.getActivityStartTime());
        }
        if (this.investigations != null) {
            this.investigations.updateTime(parent);
        }
        for (ReminderEditor editor : this.getReminderEditors()) {
            editor.setInitialTime(parent.getActivityStartTime());
        }
        if (this.tasks != null && (product = this.getProduct()) != null) {
            this.tasks.updateStartTimes(parent.getActivityStartTime(), product);
            this.tasks.refresh();
        }
        if (this.reminders != null) {
            this.reminders.refresh();
        }
        if (this.alerts != null) {
            this.alerts.refresh();
        }
    }

    private void updatePatientMedication(Product product) {
        if (this.dispensing != null) {
            if (TypeHelper.isA((IMObject)product, (String)"product.medication")) {
                PrescriptionMedicationActEditor editor = this.getMedicationEditor();
                if (editor != null) {
                    editor.setProduct(product);
                    this.changePrescription(editor);
                } else {
                    Act act = (Act)this.dispensing.create();
                    if (act != null) {
                        Act prescription = this.getPrescription();
                        if (prescription != null) {
                            this.checkUsePrescription(prescription, product, act);
                        } else {
                            this.createMedicationEditor(product, act);
                        }
                    }
                }
            } else {
                this.removeAll(this.dispensing);
            }
        }
        this.showMedicationButton(product);
    }

    private Act getPrescription() {
        Party patient = this.getPatient();
        Product product = this.getProduct();
        Prescriptions prescriptions = this.getPrescriptions();
        return prescriptions != null && patient != null && product != null ? prescriptions.getPrescription(patient, product) : null;
    }

    private void checkUsePrescription(final Act prescription, final Product product, final Act medication) {
        if (this.promptForPrescription) {
            ConfirmationDialog dialog = new ConfirmationDialog(Messages.get((String)"customer.charge.prescription.title"), Messages.format((String)"customer.charge.prescription.message", (Object[])new Object[]{product.getName()}));
            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onOK() {
                    CustomerChargeActItemEditor.this.createPrescriptionMedicationEditor(medication, prescription);
                }

                public void onCancel() {
                    CustomerChargeActItemEditor.this.createMedicationEditor(product, medication);
                }
            });
            this.getEditorQueue().queue((IMObject)this.getObject(), (PopupDialog)dialog);
        } else {
            this.createPrescriptionMedicationEditor(medication, prescription);
        }
    }

    private void createPrescriptionMedicationEditor(Act medication, Act prescription) {
        PrescriptionMedicationActEditor editor = this.dispensing.createEditor((IMObject)medication, this.createLayoutContext(medication));
        editor.setPrescription(prescription);
        this.setQuantity(editor.getQuantity());
        this.dispensing.addEdited((IMObjectEditor)editor);
        this.queueMedicationEditor((IMObjectEditor)editor, this.cancelPrescription);
    }

    private void createMedicationEditor(Product product, Act act) {
        boolean dispensingLabel = this.hasDispensingLabel(product);
        IMObjectEditor editor = this.createEditor(act, this.dispensing);
        if (editor instanceof PatientMedicationActEditor) {
            PatientMedicationActEditor medicationEditor = (PatientMedicationActEditor)editor;
            medicationEditor.setQuantity(this.quantity);
            medicationEditor.setPrescriptions(this.getPrescriptions());
        }
        editor.getComponent();
        this.dispensing.addEdited(editor);
        if (dispensingLabel) {
            this.queueMedicationEditor(editor, false);
        }
    }

    private void queueMedicationEditor(IMObjectEditor editor, boolean cancel) {
        Act medication = (Act)editor.getObject();
        IMObjectBean bean = this.getBean((IMObject)medication);
        Reference oldClinician = bean.getTargetRef("clinician");
        Reference oldBatch = bean.getTargetRef(BATCH);
        BigDecimal oldQuantity = bean.getBigDecimal("quantity", BigDecimal.ZERO);
        this.queuePatientActEditor(editor, false, cancel, (CollectionPropertyEditor)this.dispensing.getEditor(), () -> {
            Reference newClinician = bean.getTargetRef("clinician");
            Reference newBatch = bean.getTargetRef(BATCH);
            BigDecimal newQuantity = bean.getBigDecimal("quantity", BigDecimal.ZERO);
            if (!Objects.equals(oldClinician, newClinician)) {
                this.setClinicianRef(newClinician);
            }
            if (!Objects.equals(oldBatch, newBatch)) {
                this.updateBatch(newBatch);
            }
            if (oldQuantity.compareTo(newQuantity) != 0) {
                this.updateQuantity(newQuantity);
            }
        });
    }

    private void editMedication() {
        Act medication = this.getMedication();
        if (medication != null) {
            IMObjectEditor editor = this.dispensing.getEditor((IMObject)medication);
            this.queueMedicationEditor(editor, false);
        }
    }

    private void updateInvestigations(Product product) {
        if (this.investigations != null) {
            List<PatientInvestigationActEditor> editors = this.investigations.updateProduct(this, product);
            EditorQueue queue = this.getEditorQueue();
            for (PatientInvestigationActEditor editor : editors) {
                if (queue.isQueued((IMObjectEditor)editor)) continue;
                this.queuePatientActEditor((IMObjectEditor)editor, true, false, this.investigations.getEditor(), null);
            }
        }
    }

    private void updateReminders(Product product) {
        if (this.reminders != null) {
            this.removeAll(this.reminders);
            if (product != null) {
                Party patient = this.getPatient();
                Map<Entity, Relationship> reminderTypes = this.getEditContext().getReminderTypes(product, patient);
                for (Map.Entry<Entity, Relationship> entry : reminderTypes.entrySet()) {
                    Entity reminderType = entry.getKey();
                    Relationship relationship = entry.getValue();
                    Act act = (Act)this.reminders.create();
                    if (act == null) continue;
                    IMObjectEditor editor = this.createEditor(act, this.reminders);
                    if (editor instanceof ReminderEditor) {
                        ReminderEditor reminder = (ReminderEditor)editor;
                        Date startTime = this.getStartTime();
                        reminder.setInitialTime(startTime);
                        reminder.setReminderType(reminderType);
                        reminder.setPatient(patient);
                        reminder.setProduct(product);
                        reminder.setMarkMatchingRemindersCompleted(false);
                        Date dueDate = this.getEditContext().getReminderDueDate(startTime, relationship);
                        reminder.setEndTime(dueDate);
                    }
                    this.reminders.addEdited(editor);
                    IMObjectBean bean = this.getBean((IMObject)relationship);
                    boolean interactive = bean.getBoolean("interactive");
                    if (!interactive) continue;
                    this.queuePatientActEditor(editor, true, false, (CollectionPropertyEditor)this.reminders.getEditor(), null);
                }
            }
        }
    }

    private void updateAlerts(Product product) {
        Alerts allAlerts = this.getEditContext().getAlerts();
        if (this.alerts != null) {
            for (Act act : this.alerts.getCurrentActs()) {
                this.alerts.remove((IMObject)act);
                allAlerts.remove(act);
            }
            if (product != null) {
                List<Entity> alertTypes = allAlerts.getAlertTypes(product);
                for (Entity alertType : alertTypes) {
                    Act act;
                    Party patient = this.getPatient();
                    if (patient == null || allAlerts.hasAlert(patient, alertType) || (act = (Act)this.alerts.create()) == null) continue;
                    IMObjectEditor editor = this.createEditor(act, this.alerts);
                    if (editor instanceof PatientAlertEditor) {
                        PatientAlertEditor alert = (PatientAlertEditor)editor;
                        alert.getComponent();
                        Date startTime = this.getStartTime();
                        alert.setStartTime(startTime);
                        alert.setPatient(patient);
                        alert.setAlertType(alertType);
                        alert.setProduct(product);
                        alert.setMarkMatchingAlertsCompleted(false);
                    }
                    this.alerts.addEdited(editor);
                    IMObjectBean bean = this.getBean((IMObject)alertType);
                    boolean interactive = bean.getBoolean("interactive");
                    if (!interactive) continue;
                    this.queuePatientActEditor(editor, true, false, (CollectionPropertyEditor)this.alerts.getEditor(), null);
                }
            }
        }
    }

    private void updateTasks(Product product) {
        if (this.tasks != null) {
            this.removeAll(this.tasks);
            Party patient = this.getPatient();
            Date startTime = this.getStartTime();
            if (product != null && patient != null && startTime != null) {
                List<TaskActRelationshipCollectionEditor.TaskType> tasksTypes = this.tasks.getTasksTypes(product);
                for (TaskActRelationshipCollectionEditor.TaskType taskType : tasksTypes) {
                    TaskActEditor editor = this.tasks.createEditor(taskType, patient, startTime);
                    if (editor == null || !taskType.isInteractive() && editor.isValid()) continue;
                    this.queuePatientActEditor((IMObjectEditor)editor, true, false, (CollectionPropertyEditor)this.tasks.getEditor(), null);
                }
            }
        }
    }

    private void updateDocuments() {
        if (this.documents != null) {
            this.documents.update();
        }
    }

    private IMObjectEditor createEditor(Act act, ActRelationshipCollectionEditor editors) {
        return editors.createEditor((IMObject)act, this.createLayoutContext(act));
    }

    private LayoutContext createLayoutContext(Act act) {
        LayoutContext context = this.getLayoutContext();
        return new DefaultLayoutContext(context, context.getHelpContext().topic((IMObject)act, "edit"));
    }

    private void updateLayout(boolean force) {
        Product product = this.getProduct();
        this.updateLayout(product, force);
    }

    private void updateLayout(Product product, boolean force) {
        boolean showPrint = this.updatePrint(product);
        this.updateLayout(product, this.getQuantity(), showPrint, force);
    }

    private void updateLayout(Product product, BigDecimal quantity, boolean showPrint, boolean force) {
        ArchetypeNodes currentNodes = this.getArchetypeNodes();
        ArchetypeNodes expectedFilter = this.getFilterForProduct(product, quantity, showPrint);
        if (force || !Objects.equals(currentNodes, expectedFilter)) {
            EditorQueue queue = this.getEditorQueue();
            Component popupFocus = null;
            Component focus = FocusHelper.getFocus();
            Property focusProperty = null;
            if (queue != null && !queue.isComplete()) {
                popupFocus = focus;
            } else if (focus instanceof BoundProperty) {
                focusProperty = ((BoundProperty)focus).getProperty();
            }
            this.changeLayout(expectedFilter);
            if (queue != null && queue.isComplete()) {
                if (focusProperty != null) {
                    if (!this.setFocus(focusProperty)) {
                        this.moveFocusToProduct();
                    }
                } else {
                    this.moveFocusToProduct();
                }
            } else {
                FocusHelper.setFocus((Component)popupFocus);
            }
        }
    }

    private void updateSellingUnits(Product product) {
        String node;
        IMObjectBean bean;
        String units = "";
        if (product != null && (bean = this.getBean((IMObject)product)).hasNode(node = "sellingUnits")) {
            units = LookupNameHelper.getName((IMObject)product, (String)node);
        }
        this.sellingUnits.setText(units);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBatch(Product product, Reference stockLocation) {
        BatchParticipationEditor batchEditor = this.getBatchEditor();
        if (batchEditor != null) {
            try {
                batchEditor.removeModifiableListener(this.batchListener);
                batchEditor.setStockLocation(stockLocation);
                batchEditor.setProduct(product);
                this.updateMedicationBatch(stockLocation);
            }
            finally {
                batchEditor.addModifiableListener(this.batchListener);
            }
        }
    }

    private void queuePatientActEditor(IMObjectEditor editor, boolean skip, boolean cancel, CollectionPropertyEditor collection, Runnable callback) {
        EditorQueue queue = this.getEditorQueue();
        if (queue != null) {
            queue.queue((IMObject)this.getObject(), editor, skip, cancel, (skipped, cancelled) -> {
                if (skipped || cancelled) {
                    collection.remove(editor.getObject());
                    if (collection.getProperty().isEmpty()) {
                        this.updateLayout(false);
                    }
                } else if (callback != null) {
                    callback.run();
                }
                this.onEditCompleted();
            });
        }
    }

    private void removeAll(ActRelationshipCollectionEditor collection) {
        if (collection != null) {
            EditorQueue queue = this.getEditorQueue();
            for (Act act : collection.getCurrentActs()) {
                collection.remove((IMObject)act);
                if (queue == null) continue;
                queue.cancel((IMObject)act);
            }
        }
    }

    private void onQuantityChanged() {
        BigDecimal newQuantity = this.getQuantity();
        if (!this.getObject().isNew() && (this.previousQuantity.signum() == -1 && newQuantity.signum() != -1 || this.previousQuantity.signum() != -1 && newQuantity.signum() == -1)) {
            this.setQuantity(this.previousQuantity);
            return;
        }
        if (this.quantity.getProperty().isValid()) {
            BigDecimal minimumQuantity;
            if (newQuantity.signum() < 0) {
                this.removeAll(this.dispensing);
                if (this.investigations != null) {
                    this.investigations.removeInvoiceItem(this);
                }
                this.removeAll(this.reminders);
                this.removeAll(this.alerts);
                this.removeAll(this.tasks);
                if (this.documents != null) {
                    this.documents.removeAll();
                }
                this.updateLayout(false);
            } else if (this.dispensing != null) {
                if (this.previousQuantity.signum() < 0) {
                    this.updateDependencies(this.getProduct());
                } else {
                    PrescriptionMedicationActEditor editor = this.getMedicationEditor();
                    if (editor != null) {
                        editor.setQuantity(newQuantity);
                    }
                }
            }
            this.previousQuantity = newQuantity;
            if (this.getEditContext().useMinimumQuantities() && this.getEditContext().overrideMinimumQuantities() && !MathRules.isZero((BigDecimal)(minimumQuantity = this.getMinimumQuantity())) && (newQuantity.compareTo(minimumQuantity) < 0 || MathRules.isZero((BigDecimal)newQuantity))) {
                this.setMinimumQuantity(newQuantity);
            }
        }
        this.updateOnHandQuantity();
    }

    private void updateQuantity(BigDecimal newQuantity) {
        this.setQuantity(newQuantity);
        this.updateOnHandQuantity();
    }

    private void updateMedicationBatch(Reference stockLocation) {
        PrescriptionMedicationActEditor editor;
        BatchParticipationEditor batchEditor = this.getBatchEditor();
        if (batchEditor != null && (editor = this.getMedicationEditor()) != null) {
            editor.setBatch(batchEditor.getEntity());
            editor.setStockLocation(stockLocation);
        }
    }

    private void updateBatch(Reference batch) {
        BatchParticipationEditor batchEditor = this.getBatchEditor();
        if (batchEditor != null) {
            batchEditor.removeModifiableListener(this.batchListener);
            try {
                batchEditor.setEntityRef(batch);
            }
            finally {
                batchEditor.addModifiableListener(this.batchListener);
            }
        }
    }

    private void updatePatientActsPatient(Party patient) {
        PrescriptionMedicationActEditor medication = this.getMedicationEditor();
        if (medication != null) {
            medication.setPatient(patient);
            this.changePrescription(medication);
        }
        this.updateInvestigations(patient);
        this.updateDocuments();
        Product product = this.getProduct();
        this.updateReminders(product);
        this.updateAlerts(product);
        this.updateTasks(product);
    }

    private void updateInvestigations(Party patient) {
        if (this.investigations != null) {
            List<PatientInvestigationActEditor> editors = this.investigations.updatePatient(this, patient);
            for (PatientInvestigationActEditor editor : editors) {
                this.queuePatientActEditor((IMObjectEditor)editor, true, false, this.investigations.getEditor(), null);
            }
        }
    }

    private void changePrescription(final PatientMedicationActEditor editor) {
        Act prescription = this.getPrescription();
        if (prescription != null) {
            final EditorQueue queue = this.getEditorQueue();
            if (this.promptForPrescription) {
                Product product = this.getProduct();
                String title = Messages.get((String)"customer.charge.prescription.title");
                String message = Messages.format((String)"customer.charge.prescription.message", (Object[])new Object[]{product.getName()});
                ConfirmationDialog dialog = new ConfirmationDialog(title, message);
                dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                    public void onOK() {
                        queue.queue((IMObject)CustomerChargeActItemEditor.this.getObject(), (IMObjectEditor)editor, true, CustomerChargeActItemEditor.this.cancelPrescription, null);
                    }
                });
                queue.queue((IMObject)this.getObject(), (PopupDialog)dialog);
            } else {
                queue.queue((IMObject)this.getObject(), (IMObjectEditor)editor, true, this.cancelPrescription, null);
            }
        }
    }

    private void updatePatientActsClinician(User clinician) {
        PrescriptionMedicationActEditor medication = this.getMedicationEditor();
        if (medication != null) {
            medication.setClinician(clinician);
        }
        if (this.investigations != null) {
            this.investigations.updateClinician(this.getObject(), clinician);
        }
        for (ReminderEditor editor : this.getReminderEditors()) {
            editor.setClinician(clinician);
        }
        this.updateDocuments();
    }

    private void onDepartmentChanged(Entity department) {
        this.updateServiceRatio();
        if (this.departmentListener != null) {
            this.departmentListener.departmentChanged(this, department);
        }
    }

    private void updateServiceRatio() {
        Product product = this.getProduct();
        if (this.updateServiceRatio(product)) {
            this.updatePrices(product);
        }
    }

    private PrescriptionMedicationActEditor getMedicationEditor() {
        List acts;
        PrescriptionMedicationActEditor editor = null;
        if (this.dispensing != null && (editor = (PrescriptionMedicationActEditor)this.dispensing.getCurrentEditor()) == null && !(acts = this.dispensing.getActs()).isEmpty()) {
            editor = (PrescriptionMedicationActEditor)this.dispensing.getEditor((IMObject)acts.get(0));
        }
        return editor;
    }

    private Set<ReminderEditor> getReminderEditors() {
        return this.getActEditors(this.reminders);
    }

    private <T extends IMObjectEditor> Set<T> getActEditors(ActRelationshipCollectionEditor editors) {
        HashSet<IMObjectEditor> result = new HashSet<IMObjectEditor>();
        if (editors != null) {
            for (Act act : editors.getCurrentActs()) {
                IMObjectEditor editor = editors.getEditor((IMObject)act);
                result.add(editor);
            }
        }
        return result;
    }

    private boolean hasDispensingLabel(Product product) {
        IMObjectBean bean = this.getBean((IMObject)product);
        return bean.getBoolean("label");
    }

    private void initStockLocation(Product product) {
        IMObjectBean bean;
        if (product.isA(new String[]{"product.medication", "product.merchandise"}) && (bean = this.getBean((IMObject)this.getObject())).getTargetRef(STOCK_LOCATION) == null) {
            this.updateStockLocation(product);
        }
    }

    private Reference updateStockLocation(Product product) {
        Party stockLocation = null;
        if (TypeHelper.isA((IMObject)product, (String[])new String[]{"product.medication", "product.merchandise"})) {
            stockLocation = this.getEditContext().getStockLocation(product);
        }
        IMObjectBean bean = this.getBean((IMObject)this.getObject());
        if (stockLocation != null) {
            bean.setTarget(STOCK_LOCATION, (IMObject)stockLocation);
        } else {
            bean.removeValues(STOCK_LOCATION);
        }
        return stockLocation != null ? stockLocation.getObjectReference() : null;
    }

    private void addPatientIdentity(Product product) {
        HelpContext help;
        Context context;
        PatientIdentityEditor editor;
        String archetype;
        IMObjectBean bean;
        Party patient = this.getPatient();
        if (patient != null && this.getObject().isA("act.customerAccountInvoiceItem") && (bean = this.getBean((IMObject)product)).hasNode(PATIENT_IDENTITY) && (archetype = bean.getString(PATIENT_IDENTITY)) != null && (editor = PatientIdentityEditor.create(patient, archetype, context = this.getLayoutContext().getContext(), help = this.getHelpContext())) != null) {
            EditorQueue queue = this.getEditorQueue();
            EditDialog dialog = editor.edit(true);
            queue.queue((IMObject)this.getObject(), (PopupDialog)dialog, this::onEditCompleted);
        }
    }

    private void onEditCompleted() {
        EditorQueue queue = this.getEditorQueue();
        if (queue != null && queue.isComplete()) {
            this.moveFocusToProduct();
            this.getListeners().notifyListeners((Modifiable)this);
        }
    }

    private BigDecimal getCost(ProductPrice price) {
        IMObjectBean bean = this.getBean((IMObject)price);
        return bean.getBigDecimal("cost", BigDecimal.ZERO);
    }

    private ArchetypeNodes getFilterForProduct(Product product, BigDecimal quantity, boolean showPrint) {
        ArchetypeNodes result;
        boolean negative;
        boolean bl = negative = quantity.signum() == -1;
        if (TypeHelper.isA((IMObject)product, (String)"product.template")) {
            result = TEMPLATE_NODES;
        } else {
            ArrayList<String> filter = new ArrayList<String>();
            filter.add(DISPENSING);
            filter.add(REMINDERS);
            filter.add(ALERTS);
            filter.add(TASKS);
            if (this.disableDiscounts()) {
                filter.add("discount");
            }
            if (!negative) {
                if (this.reminders != null && !this.reminders.getCollection().isEmpty()) {
                    filter.remove(REMINDERS);
                }
                if (this.alerts != null && !this.alerts.getCollection().isEmpty()) {
                    filter.remove(ALERTS);
                }
                if (this.tasks != null && !this.tasks.getCollection().isEmpty()) {
                    filter.remove(TASKS);
                }
            }
            result = new ArchetypeNodes().exclude(filter);
            if (showPrint) {
                result.simple(new String[]{"print"}).order("print", TAX);
            }
            if (this.isOrdered() && this.hasReceivedOrReturnedQuantity()) {
                if (result == null) {
                    result = new ArchetypeNodes();
                }
                result.simple(ORDER_NODES);
            }
            if (this.showServiceRatio()) {
                if (result == null) {
                    result = new ArchetypeNodes();
                }
                result.hidden(true).simple(new String[]{"serviceRatio"});
            }
        }
        return result;
    }

    private boolean hasReceivedOrReturnedQuantity() {
        Property received = this.getProperty(RECEIVED_QUANTITY);
        Property returned = this.getProperty(RETURNED_QUANTITY);
        return received != null && received.getBigDecimal() != null || returned != null && returned.getBigDecimal() != null;
    }

    private boolean updatePrint(Product product) {
        boolean result = false;
        if (product != null) {
            BigDecimal total = this.getTotal();
            result = MathRules.equals((BigDecimal)total, (BigDecimal)BigDecimal.ZERO);
            if (result) {
                Product template = this.getTemplate();
                if (template != null) {
                    IMObjectBean bean = this.getBean((IMObject)template);
                    result = !bean.getBoolean(PRINT_AGGREGATE);
                }
            } else {
                this.setPrint(true);
            }
        }
        return result;
    }

    private ParticipationCollectionEditor createProductCollectionEditor() {
        ProductParticipationEditor productEditor;
        ParticipationCollectionEditor editor = new ParticipationCollectionEditor(this.getCollectionProperty("product"), (IMObject)this.getObject(), this.getLayoutContext());
        editor.getComponent();
        this.addEditor((Editor)editor);
        if (this.isProductReadOnly() && (productEditor = this.getProductEditor(false)) != null) {
            productEditor.setReadOnly(true);
        }
        return editor;
    }

    private DispensingActRelationshipCollectionEditor createDispensingCollectionEditor() {
        DispensingActRelationshipCollectionEditor editor = null;
        CollectionProperty collection = (CollectionProperty)this.getProperty(DISPENSING);
        if (collection != null && !collection.isHidden()) {
            editor = new DispensingActRelationshipCollectionEditor(collection, (Act)this.getObject(), (LayoutContext)new DefaultLayoutContext(this.getLayoutContext()));
            editor.getComponent();
            this.addEditor((Editor)editor);
        }
        return editor;
    }

    private ActRelationshipCollectionEditor createRemindersCollectionEditor() {
        ReminderActRelationshipCollectionEditor editor = null;
        CollectionProperty collection = (CollectionProperty)this.getProperty(REMINDERS);
        if (collection != null && !collection.isHidden()) {
            editor = new ReminderActRelationshipCollectionEditor(collection, (Act)this.getObject(), (LayoutContext)new DefaultLayoutContext(this.getLayoutContext()));
            this.addEditor((Editor)editor);
        }
        return editor;
    }

    private ActRelationshipCollectionEditor createAlertsCollectionEditor() {
        AlertActRelationshipCollectionEditor editor = null;
        CollectionProperty collection = (CollectionProperty)this.getProperty(ALERTS);
        if (collection != null && !collection.isHidden()) {
            editor = new AlertActRelationshipCollectionEditor(collection, (Act)this.getObject(), (LayoutContext)new DefaultLayoutContext(this.getLayoutContext()));
            editor.setAlerts(this.getEditContext().getAlerts());
            this.addEditor((Editor)editor);
        }
        return editor;
    }

    private TaskActRelationshipCollectionEditor createTaskCollectionEditor() {
        TaskActRelationshipCollectionEditor editor = null;
        CollectionProperty collection = (CollectionProperty)this.getProperty(TASKS);
        if (collection != null) {
            editor = new TaskActRelationshipCollectionEditor(collection, (Act)this.getObject(), (LayoutContext)new DefaultLayoutContext(this.getLayoutContext()));
            this.addEditor((Editor)editor);
        }
        return editor;
    }

    private ChargeItemDocumentManager createDocumentsManager(ChargeSaveContext saveContext) {
        ChargeItemDocumentManager result = null;
        CollectionProperty property = this.getCollectionProperty(DOCUMENTS);
        if (property != null) {
            result = new ChargeItemDocumentManager(this, property, saveContext, this.getLayoutContext());
            this.addEditor((Editor)result);
        }
        return result;
    }

    private String debugString() {
        Product product = this.getProduct();
        Party patient = this.getPatient();
        String productStr = product != null ? "id=" + product.getId() + ", name=" + product.getName() : null;
        User user = this.getLayoutContext().getContext().getUser();
        String patientStr = patient != null ? "id=" + patient.getId() + ", name=" + patient.getName() : null;
        User clinician = this.getClinician();
        return "product=[" + productStr + "], fixedCost=" + this.getFixedCost() + ", fixedPrice=" + this.getFixedPrice() + ", unitCost=" + this.getUnitCost() + ", unitPrice=" + this.getUnitPrice() + ", serviceRatio=" + this.getServiceRatio() + ", quantity=" + this.getQuantity() + ", discount=" + this.getProperty("discount").getBigDecimal() + ", tax=" + this.getProperty(TAX).getBigDecimal() + ", total=" + this.getTotal() + ", clinician=" + (clinician != null ? clinician.getUsername() : null) + ", patient=[" + patientStr + "], user=" + (user != null ? user.getUsername() : null) + ", act=" + this.getObject().getObjectReference() + ", parent=" + (this.getParent() != null ? this.getParent().getObjectReference() : null);
    }

    protected class CustomerChargeItemLayoutStrategy
    extends PriceActItemEditor.PriceItemLayoutStrategy {
        public CustomerChargeItemLayoutStrategy(FixedPriceEditor fixedPrice, PriceActItemEditor.ServiceRatioEditor serviceRatio) {
            super(CustomerChargeActItemEditor.this, fixedPrice, (PropertyEditor)serviceRatio);
        }

        @Override
        public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
            if (!CustomerChargeActItemEditor.this.getEditContext().useDepartments()) {
                ArchetypeNodes nodes = new ArchetypeNodes(super.getArchetypeNodes()).exclude(new String[]{CustomerChargeActItemEditor.DEPARTMENT});
                this.setArchetypeNodes(nodes);
            }
            Row onHand = RowFactory.create((String)"CellSpacing", (LayoutData)RowFactory.rightAlign(), (Component[])new Component[]{CustomerChargeActItemEditor.this.stockQuantity.getComponent().getLabel(), CustomerChargeActItemEditor.this.stockQuantity.getComponent().getComponent()});
            Row row = RowFactory.create((String)"WideCellSpacing", (Component[])new Component[]{RowFactory.create((String)"CellSpacing", (Component[])new Component[]{CustomerChargeActItemEditor.this.quantity.getComponent(), CustomerChargeActItemEditor.this.sellingUnits}), onHand});
            this.addComponent(new ComponentState((PropertyEditor)CustomerChargeActItemEditor.this.productCollectionEditor));
            this.addComponent(new ComponentState((Component)row, CustomerChargeActItemEditor.this.quantity.getProperty()));
            if (CustomerChargeActItemEditor.this.reminders != null) {
                this.addComponent(new ComponentState((PropertyEditor)CustomerChargeActItemEditor.this.reminders));
            }
            if (CustomerChargeActItemEditor.this.alerts != null) {
                this.addComponent(new ComponentState((PropertyEditor)CustomerChargeActItemEditor.this.alerts));
            }
            if (CustomerChargeActItemEditor.this.tasks != null) {
                this.addComponent(new ComponentState((PropertyEditor)CustomerChargeActItemEditor.this.tasks));
            }
            if (CustomerChargeActItemEditor.this.isOrdered()) {
                this.addComponent(this.createComponent(this.createReadOnly(properties.get("patient")), parent, context));
            }
            return super.apply(object, properties, parent, context);
        }

        protected ComponentGrid createGrid(IMObject object, List<Property> properties, LayoutContext context) {
            ComponentGrid grid = super.createGrid(object, properties, context);
            if (CustomerChargeActItemEditor.this.medicationButton != null) {
                grid.set(0, grid.getColumns(), (Component)ColumnFactory.create((Component[])new Component[]{CustomerChargeActItemEditor.this.medicationButton}));
            }
            return grid;
        }
    }
}

