/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.edit.AbstractRemoveConfirmationHandler;
import org.openvpms.web.component.im.edit.IMObjectCollectionEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.PriceActItemEditor;
import org.openvpms.web.workspace.customer.charge.AbstractChargeItemRelationshipCollectionEditor;
import org.openvpms.web.workspace.customer.charge.ChargeRemovalStates;
import org.openvpms.web.workspace.customer.charge.PriceActEditContext;

public abstract class ChargeRemoveConfirmationHandler
extends AbstractRemoveConfirmationHandler {
    private final Context context;
    private final HelpContext help;

    public ChargeRemoveConfirmationHandler(Context context, HelpContext help) {
        this.context = context;
        this.help = help;
    }

    public void remove(IMObject object, IMObjectCollectionEditor collection) {
        AbstractChargeItemRelationshipCollectionEditor chargeCollection = (AbstractChargeItemRelationshipCollectionEditor)collection;
        ChargeRemovalStates states = this.getRemovalStates(Collections.singletonList(object), chargeCollection);
        if (states.prompt()) {
            this.promptRemoval(states, chargeCollection);
        } else {
            super.remove(object, collection);
        }
    }

    public void remove(final List<IMObject> objects, final AbstractChargeItemRelationshipCollectionEditor collection) {
        if (objects.size() == 1) {
            this.remove(objects.get(0), (IMObjectCollectionEditor)collection);
        } else if (objects.size() > 1) {
            ChargeRemovalStates states = this.getRemovalStates(objects, collection);
            if (states.prompt()) {
                this.promptRemoval(states, collection);
            } else {
                String displayName = collection.getProperty().getDisplayName();
                String title = Messages.format((String)"imobject.collection.deletes.title", (Object[])new Object[]{displayName});
                String message = Messages.format((String)"imobject.collection.deletes.message", (Object[])new Object[]{objects.size(), displayName});
                ConfirmationDialog dialog = new ConfirmationDialog(title, message, ConfirmationDialog.YES_NO);
                dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                    public void onYes() {
                        ChargeRemoveConfirmationHandler.this.removeAll(objects, collection);
                    }

                    public void onNo() {
                        ChargeRemoveConfirmationHandler.this.cancelRemove((IMObjectCollectionEditor)collection);
                    }
                });
                dialog.show();
            }
        }
    }

    protected ChargeRemovalStates getRemovalStates(List<IMObject> objects, AbstractChargeItemRelationshipCollectionEditor collection) {
        ChargeRemovalStates result = new ChargeRemovalStates();
        for (IMObject object : objects) {
            this.checkRemovalState((Act)object, collection, result);
        }
        return result;
    }

    protected boolean checkRemovalState(Act object, AbstractChargeItemRelationshipCollectionEditor collection, ChargeRemovalStates states) {
        PriceActItemEditor editor;
        BigDecimal quantity;
        IMObjectEditor chargeEditor;
        ChargeRemovalStates.Status status = ChargeRemovalStates.Status.OK;
        PriceActEditContext editContext = collection.getEditContext();
        if (editContext.useMinimumQuantities() && (chargeEditor = collection.getEditor((IMObject)object)) instanceof PriceActItemEditor && (quantity = (editor = (PriceActItemEditor)chargeEditor).getMinimumQuantity()).compareTo(BigDecimal.ZERO) > 0) {
            String message;
            String name = this.getDisplayName(editor);
            if (editContext.overrideMinimumQuantities()) {
                status = ChargeRemovalStates.Status.OVERRIDE;
                message = Messages.format((String)"customer.charge.delete.minquantity", (Object[])new Object[]{name, quantity});
            } else {
                status = ChargeRemovalStates.Status.FORBIDDEN;
                message = Messages.format((String)"customer.charge.delete.minquantity.forbidden", (Object[])new Object[]{name, quantity});
            }
            states.addStatus(object, status, message);
        }
        return status != ChargeRemovalStates.Status.FORBIDDEN;
    }

    protected void cancelRemove(IMObjectCollectionEditor collection) {
        ((AbstractChargeItemRelationshipCollectionEditor)collection).unmarkAll();
    }

    protected String getDisplayName(IMObject object, IMObjectCollectionEditor collection) {
        AbstractChargeItemRelationshipCollectionEditor chargeCollection = (AbstractChargeItemRelationshipCollectionEditor)collection;
        IMObjectEditor chargeEditor = chargeCollection.getEditor(object);
        String result = chargeEditor instanceof PriceActItemEditor ? this.getDisplayName((PriceActItemEditor)chargeEditor) : super.getDisplayName(object, collection);
        return result;
    }

    private void promptRemoval(ChargeRemovalStates states, AbstractChargeItemRelationshipCollectionEditor chargeCollection) {
        Consumer<Collection<Act>> remover = acts -> {
            this.removeAll(new ArrayList<IMObject>((Collection<IMObject>)acts), chargeCollection);
            this.cancelRemove((IMObjectCollectionEditor)chargeCollection);
        };
        Runnable canceller = () -> this.cancelRemove((IMObjectCollectionEditor)chargeCollection);
        states.show(chargeCollection.getProperty().getDisplayName(), remover, canceller, (LayoutContext)new DefaultLayoutContext(this.context, this.help));
    }

    private void removeAll(List<IMObject> objects, AbstractChargeItemRelationshipCollectionEditor collection) {
        for (IMObject object : objects) {
            this.apply(object, (IMObjectCollectionEditor)collection);
        }
    }

    private String getDisplayName(PriceActItemEditor editor) {
        Product product = editor.getProduct();
        String result = product != null ? product.getName() : DescriptorHelper.getDisplayName((IMObject)editor.getObject(), (ArchetypeService)ServiceHelper.getArchetypeService());
        return result;
    }
}

