/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.table.DelegatingIMTableModel;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.component.im.view.act.ActRelationshipCollectionViewer;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.echo.button.CheckBox;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.CheckBoxFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.charge.ChargeItemTableModel;

public class ChargeItemRelationshipCollectionViewer
extends ActRelationshipCollectionViewer {
    static final String SHOW_BATCH = "showBatch";
    static final String SHOW_TEMPLATE = "showTemplate";
    static final String SHOW_PRODUCT_TYPE = "showProductType";
    private static final String SHOW_DEPARTMENT = "showDepartment";

    public ChargeItemRelationshipCollectionViewer(CollectionProperty property, Act act, LayoutContext context) {
        super(property, (IMObject)act, context);
    }

    protected Component doLayout() {
        Component component = super.doLayout();
        component.add((Component)this.createControls(), 0);
        return component;
    }

    protected Row createControls() {
        Row row = RowFactory.create((String)"CellSpacing", (Component[])new Component[0]);
        final Preferences prefs = this.getLayoutContext().getPreferences();
        boolean showBatch = prefs.getBoolean("entity.preferenceGroupCharge", SHOW_BATCH, false);
        boolean showTemplate = prefs.getBoolean("entity.preferenceGroupCharge", SHOW_TEMPLATE, false);
        boolean showProductType = prefs.getBoolean("entity.preferenceGroupCharge", SHOW_PRODUCT_TYPE, false);
        boolean showDepartment = prefs.getBoolean("entity.preferenceGroupCharge", SHOW_DEPARTMENT, false);
        final ChargeItemTableModel<?> model = this.getModel();
        if (model != null) {
            if (model.hasBatch()) {
                final CheckBox batch = CheckBoxFactory.create((String)"customer.charge.show.batch", (boolean)showBatch);
                batch.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                    public void onAction(ActionEvent event) {
                        boolean selected = batch.isSelected();
                        prefs.setPreference("entity.preferenceGroupCharge", ChargeItemRelationshipCollectionViewer.SHOW_BATCH, (Object)selected);
                        model.setShowBatch(prefs.getBoolean("entity.preferenceGroupCharge", ChargeItemRelationshipCollectionViewer.SHOW_BATCH, false));
                    }
                });
                row.add((Component)batch);
            }
            final CheckBox template = CheckBoxFactory.create((String)"customer.charge.show.template", (boolean)showTemplate);
            final CheckBox productType = CheckBoxFactory.create((String)"customer.charge.show.productType", (boolean)showProductType);
            template.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent event) {
                    boolean selected = template.isSelected();
                    prefs.setPreference("entity.preferenceGroupCharge", ChargeItemRelationshipCollectionViewer.SHOW_TEMPLATE, (Object)selected);
                    model.setShowTemplate(selected);
                }
            });
            productType.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent event) {
                    boolean selected = productType.isSelected();
                    prefs.setPreference("entity.preferenceGroupCharge", ChargeItemRelationshipCollectionViewer.SHOW_PRODUCT_TYPE, (Object)selected);
                    model.setShowProductType(selected);
                }
            });
            row.add((Component)template);
            row.add((Component)productType);
            Party practice = this.getLayoutContext().getContext().getPractice();
            if (practice != null && ((PracticeRules)ServiceHelper.getBean(PracticeRules.class)).departmentsEnabled(practice)) {
                final CheckBox department = CheckBoxFactory.create((String)"customer.charge.show.department", (boolean)showDepartment);
                department.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                    public void onAction(ActionEvent event) {
                        boolean selected = department.isSelected();
                        prefs.setPreference("entity.preferenceGroupCharge", ChargeItemRelationshipCollectionViewer.SHOW_DEPARTMENT, (Object)selected);
                        ChargeItemRelationshipCollectionViewer.this.getModel().setShowDepartment(prefs.getBoolean("entity.preferenceGroupCharge", ChargeItemRelationshipCollectionViewer.SHOW_DEPARTMENT, false));
                    }
                });
                row.add((Component)department);
            }
        }
        return row;
    }

    protected PagedIMTable<IMObject> getTable() {
        return super.getTable();
    }

    protected ChargeItemTableModel<?> getModel() {
        IMTableModel result = null;
        IMTableModel relationshipModel = this.getTable().getModel().getModel();
        if (relationshipModel instanceof DelegatingIMTableModel) {
            result = ((DelegatingIMTableModel)relationshipModel).getModel();
        }
        return result instanceof ChargeItemTableModel ? (ChargeItemTableModel)result : null;
    }
}

