/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.rules.doc.DocumentRules;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.util.Variables;
import org.openvpms.report.ReportFactory;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.doc.FileNameFormatter;
import org.openvpms.web.component.im.doc.ParameterDialog;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.report.DocumentActReporter;
import org.openvpms.web.component.im.report.ReportContextFactory;
import org.openvpms.web.component.macro.MacroVariables;
import org.openvpms.web.component.print.BatchPrinter;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.charge.ChargeItemRelationshipCollectionEditor;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActEditor;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActItemEditor;
import org.openvpms.web.workspace.customer.charge.EditorQueue;

public class ChargeDocumentManager {
    private final CustomerChargeActEditor editor;
    private final LayoutContext layoutContext;
    private final IArchetypeService service;
    private final FileNameFormatter formatter;
    private final DocumentRules rules;
    private final LookupService lookups;
    private final ReportFactory reportFactory;
    private final Set<Reference> excludeUngenerated = new HashSet<Reference>();
    private final Set<Reference> excludeUnprinted = new HashSet<Reference>();

    public ChargeDocumentManager(CustomerChargeActEditor editor, LayoutContext layoutContext) {
        this.editor = editor;
        this.layoutContext = layoutContext;
        this.service = (IArchetypeService)ServiceHelper.getBean(IArchetypeService.class);
        this.formatter = (FileNameFormatter)ServiceHelper.getBean(FileNameFormatter.class);
        this.rules = new DocumentRules((ArchetypeService)this.service);
        this.lookups = ServiceHelper.getLookupService();
        this.reportFactory = (ReportFactory)ServiceHelper.getBean(ReportFactory.class);
        this.addReferences(this.getUngeneratedLetters(), this.excludeUngenerated);
        this.addReferences(this.getUnprintedDocuments(), this.excludeUnprinted);
    }

    public void process(EditorQueue queue) {
        this.generateLetters(queue);
        queue.queue(completed -> {
            this.printNew(queue);
            completed.run();
        });
    }

    private void generateLetters(EditorQueue queue) {
        Map<DocumentAct, FinancialAct> documents = this.getUngeneratedLetters();
        if (!documents.isEmpty()) {
            this.addReferences(documents, this.excludeUngenerated);
            for (Map.Entry<DocumentAct, FinancialAct> entry : documents.entrySet()) {
                DocumentAct document = entry.getKey();
                FinancialAct invoiceItem = entry.getValue();
                DocumentTemplate template = this.getTemplate(document);
                if (template == null) continue;
                this.addLetter((IMObject)invoiceItem, document, template, queue);
            }
        }
    }

    private void addLetter(IMObject invoiceItem, final DocumentAct document, DocumentTemplate template, EditorQueue queue) {
        Context context = this.layoutContext.getContext();
        HelpContext help = this.layoutContext.getHelpContext();
        final DocumentActReporter reporter = new DocumentActReporter(document, template, this.formatter, (ArchetypeService)this.service, this.lookups, this.reportFactory);
        reporter.setFields(ReportContextFactory.create((Context)context));
        Set parameters = reporter.getParameterTypes();
        if (!parameters.isEmpty()) {
            String title = Messages.format((String)"document.input.parameters", (Object[])new Object[]{template.getName()});
            MacroVariables variables = new MacroVariables(context, (ArchetypeService)this.service, this.lookups);
            final ParameterDialog dialog = new ParameterDialog(title, parameters, (IMObject)document, context, help.subtopic("document"), (Variables)variables, true, true);
            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onOK() {
                    reporter.setParameters(dialog.getValues());
                    ChargeDocumentManager.this.addLetter(document, reporter);
                    super.onOK();
                }
            });
            queue.queue(invoiceItem, (PopupDialog)dialog);
        } else {
            this.addLetter(document, reporter);
        }
    }

    private void printNew(EditorQueue queue) {
        Map<DocumentAct, FinancialAct> documents = this.getUnprintedDocuments();
        if (!documents.isEmpty()) {
            queue.queue(completed -> this.print(documents, (Runnable)completed));
        }
    }

    private void print(Map<DocumentAct, FinancialAct> documents, final Runnable listener) {
        LocalContext context = new LocalContext();
        context.setCustomer(this.editor.getCustomer());
        context.setLocation(this.editor.getLocation());
        this.addReferences(documents, this.excludeUnprinted);
        BatchPrinter<DocumentAct> printer = new BatchPrinter<DocumentAct>(new ArrayList<DocumentAct>(documents.keySet()), (Context)context, this.editor.getHelpContext()){

            public void failed(Throwable cause) {
                ErrorHelper.show((Throwable)cause, () -> (this).print());
            }

            protected void completed() {
                listener.run();
            }
        };
        printer.print();
    }

    private Map<DocumentAct, FinancialAct> getUngeneratedLetters() {
        return this.getDocuments(this::isUngeneratedLetter, this.excludeUngenerated);
    }

    private Map<DocumentAct, FinancialAct> getUnprintedDocuments() {
        return this.getDocuments(this::isPrintImmediate, this.excludeUnprinted);
    }

    private boolean isUngeneratedLetter(DocumentAct document) {
        return document.isA("act.patientDocumentLetter") && document.getDocument() == null;
    }

    private Map<DocumentAct, FinancialAct> getDocuments(Predicate<DocumentAct> predicate, Set<Reference> exclude) {
        LinkedHashMap<DocumentAct, FinancialAct> result = new LinkedHashMap<DocumentAct, FinancialAct>();
        ChargeItemRelationshipCollectionEditor items = this.editor.getItems();
        for (Act item : items.getActs()) {
            CustomerChargeActItemEditor itemEditor = items.getEditor((IMObject)item);
            for (Act act : itemEditor.getDocuments()) {
                DocumentAct document = (DocumentAct)act;
                if (exclude.contains(document.getObjectReference()) || !predicate.test(document)) continue;
                result.put(document, itemEditor.getObject());
            }
        }
        return result;
    }

    private void addReferences(Map<DocumentAct, FinancialAct> documents, Set<Reference> set) {
        for (DocumentAct document : documents.keySet()) {
            set.add(document.getObjectReference());
        }
    }

    private boolean isPrintImmediate(DocumentAct document) {
        DocumentTemplate template;
        boolean result = false;
        if (!document.isPrinted() && (template = this.getTemplate(document)) != null) {
            result = template.getPrintMode() == DocumentTemplate.PrintMode.IMMEDIATE;
        }
        return result;
    }

    private DocumentTemplate getTemplate(DocumentAct document) {
        Entity entity;
        DocumentTemplate template = null;
        IMObjectBean bean = this.service.getBean((IMObject)document);
        if (bean.hasNode("documentTemplate") && (entity = (Entity)this.layoutContext.getCache().get(bean.getTargetRef("documentTemplate"))) != null) {
            template = new DocumentTemplate(entity, (ArchetypeService)this.service);
        }
        return template;
    }

    private void addLetter(DocumentAct act, DocumentActReporter reporter) {
        Document document = reporter.getDocument();
        List changes = this.rules.addDocument(act, document, false);
        this.service.save((Collection)changes);
    }
}

