/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.system.ServiceHelper;

public class Alerts {
    private final Map<Reference, Act> alerts = new HashMap<Reference, Act>();
    private final ArchetypeService service = ServiceHelper.getArchetypeService();

    public void add(Act alert) {
        this.alerts.put(alert.getObjectReference(), alert);
    }

    public void remove(Act alert) {
        this.alerts.remove(alert.getObjectReference());
    }

    public List<Act> getNewAlerts() {
        ArrayList<Act> result = new ArrayList<Act>();
        for (Act alert : this.alerts.values()) {
            if (!alert.isNew()) continue;
            result.add(alert);
        }
        return result;
    }

    public List<Entity> getAlertTypes(Product product) {
        IMObjectBean bean = this.service.getBean((IMObject)product);
        List result = bean.hasNode("alerts") ? bean.getTargets("alerts", Entity.class, Policies.active()) : Collections.emptyList();
        return result;
    }

    public boolean hasAlert(Party patient, Entity alertType) {
        Reference patientRef = patient.getObjectReference();
        Reference alertRef = alertType.getObjectReference();
        Date now = new Date();
        for (Act alert : this.alerts.values()) {
            IMObjectBean bean = this.service.getBean((IMObject)alert);
            if (!"IN_PROGRESS".equals(alert.getStatus()) || alert.getActivityEndTime() != null && DateRules.compareTo((Date)alert.getActivityEndTime(), (Date)now) <= 0 || !Objects.equals(patientRef, bean.getTargetRef("patient")) || !Objects.equals(alertRef, bean.getTargetRef("alertType"))) continue;
            return true;
        }
        return false;
    }

    public void removeItem(FinancialAct item) {
        IMObjectBean bean = this.service.getBean((IMObject)item);
        if (bean.hasNode("alerts")) {
            for (Reference alert : bean.getTargetRefs("alerts")) {
                this.alerts.remove(alert);
            }
        }
    }
}

