/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import nextapp.echo2.app.Button;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.finance.reminder.AccountReminderRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.IMObjectActions;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.CustomerActCRUDWindow;
import org.openvpms.web.workspace.customer.account.AccountActActions;

public class AbstractChargeCRUDWindow
extends CustomerActCRUDWindow<FinancialAct> {
    private final CustomerAccountRules rules = (CustomerAccountRules)ServiceHelper.getBean(CustomerAccountRules.class);
    private final AccountReminderRules reminderRules = (AccountReminderRules)ServiceHelper.getBean(AccountReminderRules.class);
    private static final String ENABLE_REMINDERS_ID = "button.enableReminders";
    private static final String DISABLE_REMINDERS_ID = "button.disableReminders";

    public AbstractChargeCRUDWindow(Archetypes<FinancialAct> archetypes, Context context, HelpContext help) {
        super(archetypes, null, context, help);
        PracticeService practiceService = (PracticeService)ServiceHelper.getBean(PracticeService.class);
        this.setActions((IMObjectActions)new AccountActActions(this.rules, this.reminderRules, practiceService, (ArchetypeService)this.getService()));
    }

    protected AccountActActions getActions() {
        return (AccountActActions)super.getActions();
    }

    protected void enableDisableReminderButtons(ButtonSet buttons, boolean enable) {
        buttons.setEnabled(ENABLE_REMINDERS_ID, enable && this.getActions().canEnableReminders((FinancialAct)this.getObject()));
        buttons.setEnabled(DISABLE_REMINDERS_ID, enable && this.getActions().canDisableReminders((FinancialAct)this.getObject()));
    }

    protected Button createEnableRemindersButton() {
        return ButtonFactory.create((String)ENABLE_REMINDERS_ID, (Runnable)this.action(this::enableReminders, arg_0 -> ((AccountReminderRules)this.reminderRules).canEnableReminders(arg_0), true, Messages.get((String)"customer.charge.enableReminders")));
    }

    protected Button createDisableRemindersButton() {
        return ButtonFactory.create((String)DISABLE_REMINDERS_ID, (Runnable)this.action(this::disableReminders, arg_0 -> ((AccountReminderRules)this.reminderRules).canDisableReminders(arg_0), true, Messages.get((String)"customer.charge.disableReminders")));
    }

    protected CustomerAccountRules getRules() {
        return this.rules;
    }

    private void enableReminders(FinancialAct act) {
        this.reminderRules.enableReminders(act);
        this.onRefresh((IMObject)act);
    }

    private void disableReminders(FinancialAct act) {
        this.reminderRules.disableReminders(act);
        this.onRefresh((IMObject)act);
    }
}

