/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.account;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import org.openvpms.archetype.rules.finance.account.CustomerAccountArchetypes;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.ShortNameConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.patient.PatientQuery;
import org.openvpms.web.component.im.query.ActResultSet;
import org.openvpms.web.component.im.query.ActStatuses;
import org.openvpms.web.component.im.query.DateRangeActQuery;
import org.openvpms.web.component.im.query.ListResultSet;
import org.openvpms.web.component.im.query.ParticipantConstraint;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.select.AbstractSelectorListener;
import org.openvpms.web.component.im.select.IMObjectSelector;
import org.openvpms.web.component.im.select.SelectorListener;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.system.ServiceHelper;

public class CustomerAccountQuery<T extends Act>
extends DateRangeActQuery<T> {
    private final IMObjectSelector<Party> patientSelector;
    private static final ActStatuses STATUSES;
    private static final String[] ACCOUNT_ACTS;

    public CustomerAccountQuery(Party customer, LayoutContext context) {
        super((Entity)customer, "customer", "participation.customer", ACCOUNT_ACTS, STATUSES, FinancialAct.class);
        this.patientSelector = this.createPatientSelector(customer, context);
    }

    public CustomerAccountQuery(Party customer, String[] statuses, LayoutContext context) {
        super((Entity)customer, "customer", "participation.customer", ACCOUNT_ACTS, statuses, FinancialAct.class);
        this.patientSelector = this.createPatientSelector(customer, context);
    }

    public CustomerAccountQuery(Party customer, String[] archetypes, ActStatuses statuses, LayoutContext context) {
        super((Entity)customer, "customer", "participation.customer", archetypes, statuses, FinancialAct.class);
        this.patientSelector = this.createPatientSelector(customer, context);
    }

    public void setPatient(Party patient) {
        this.patientSelector.setObject((Object)patient);
    }

    protected IMObjectSelector<Party> createPatientSelector(final Party customer, LayoutContext context) {
        IMObjectSelector<Party> selector = new IMObjectSelector<Party>(DescriptorHelper.getDisplayName((String)"party.patientpet", (ArchetypeService)ServiceHelper.getArchetypeService()), context, new String[]{"party.patientpet"}){

            protected Query<Party> createQuery(String value) {
                PatientQuery query = new PatientQuery(customer);
                query.setValue(value);
                return query;
            }
        };
        selector.getTextField().setWidth(new Extent(20, 128));
        selector.setListener((SelectorListener)new AbstractSelectorListener<Party>(){

            public void selected(Party object) {
                CustomerAccountQuery.this.onQuery();
            }
        });
        return selector;
    }

    protected void doLayout(Component container) {
        super.doLayout(container);
        String displayName = DescriptorHelper.getDisplayName((String)"act.customerAccountInvoiceItem", (String)"patient", (ArchetypeService)this.getService());
        container.add((Component)LabelFactory.text((String)displayName));
        container.add(this.patientSelector.getComponent());
    }

    protected ResultSet<T> createResultSet(SortConstraint[] sort) {
        Object result = null;
        ShortNameConstraint constraint = this.getArchetypeConstraint();
        Party patient = (Party)this.patientSelector.getObject();
        if (patient != null) {
            List<String> original = Arrays.asList(constraint.getShortNames());
            ArrayList<String> archetypes = new ArrayList<String>(original);
            archetypes.removeIf(archetype -> !archetype.equals("act.customerAccountChargesInvoice") && !archetype.equals("act.customerAccountChargesCredit"));
            if (archetypes.isEmpty()) {
                result = new ListResultSet(Collections.emptyList(), this.getMaxResults());
            } else if (!original.equals(archetypes)) {
                constraint = new ShortNameConstraint(constraint.getAlias(), archetypes.toArray(new String[0]), true, true);
            }
        }
        if (result == null) {
            result = new AccountActResultSet(constraint, this.getParticipantConstraint(), this.getFrom(), this.getTo(), this.getStatuses(), this.excludeStatuses(), this.getConstraints(), this.getMaxResults(), sort);
        }
        return result;
    }

    static {
        ACCOUNT_ACTS = CustomerAccountArchetypes.ACCOUNT_ACTS.toArray(new String[0]);
        STATUSES = new ActStatuses("act.customerAccountChargesInvoice");
        STATUSES.setDefault((String)null);
    }

    private class AccountActResultSet
    extends ActResultSet<T> {
        public AccountActResultSet(ShortNameConstraint archetypes, ParticipantConstraint participants, Date from, Date to, String[] statuses, boolean exclude, IConstraint constraints, int pageSize, SortConstraint[] sort) {
            super(archetypes, participants, from, to, statuses, exclude, constraints, pageSize, sort);
        }

        protected ArchetypeQuery createQuery() {
            ShortNameConstraint archetypes = this.getArchetypes();
            IArchetypeRuleService service = ServiceHelper.getArchetypeService();
            String[] relationships = DescriptorHelper.getNodeShortNames((String[])archetypes.getShortNames(), (String)"items", (ArchetypeService)service);
            ArchetypeQuery query = super.createQuery();
            Party patient = (Party)CustomerAccountQuery.this.patientSelector.getObject();
            if (patient != null) {
                query.add((IConstraint)Constraints.exists((ArchetypeQuery)Constraints.subQuery((String[])relationships, (String)"items").add((IConstraint)Constraints.idEq((String)"act", (String)"source")).add((IConstraint)Constraints.join((String)"target").add((IConstraint)Constraints.join((String)"patient").add((IConstraint)Constraints.eq((String)"entity", (Object)patient))))));
            }
            return query;
        }
    }
}

