/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.account;

import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import org.openvpms.archetype.rules.finance.account.BalanceCalculator;
import org.openvpms.component.business.domain.im.datatypes.quantity.Money;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.im.view.IMObjectComponentFactory;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.customer.charge.ChargeArchetypeNodesFactory;

public class CustomerAccountLayoutStrategy
extends AbstractLayoutStrategy {
    private static final String HIDE = "hide";

    public CustomerAccountLayoutStrategy() {
        this.setArchetypeNodes(ArchetypeNodes.all());
    }

    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        FinancialAct act = (FinancialAct)object;
        if (!context.isEdit() && act.getStatus().equals("POSTED")) {
            this.getArchetypeNodes().complex(new String[]{"allocation"});
            this.addComponent(this.getAllocation(act, properties, context));
        }
        return super.apply(object, properties, parent, context);
    }

    protected ArchetypeNodes getArchetypeNodes(IMObject object, LayoutContext context) {
        ArchetypeNodes nodes = super.getArchetypeNodes(object, context);
        IMObjectBean bean = this.getBean(object);
        if (object.isA(new String[]{"act.customerAccountChargesInvoice", "act.customerAccountChargesCounter", "act.customerAccountChargesCredit"})) {
            ChargeArchetypeNodesFactory.apply(nodes);
        }
        if (bean.getBoolean(HIDE)) {
            nodes.simple(new String[]{HIDE});
        }
        return nodes;
    }

    private ComponentState getAllocation(FinancialAct act, PropertySet properties, LayoutContext context) {
        CollectionProperty allocation = (CollectionProperty)properties.get("allocation");
        Property allocated = properties.get("allocatedAmount");
        SimpleProperty unallocated = new SimpleProperty("unallocatedAmount", null, Money.class, Messages.get((String)"customer.account.unallocated"), true);
        BalanceCalculator calculator = new BalanceCalculator((IArchetypeService)this.getService());
        unallocated.setValue((Object)calculator.getAllocatable(act));
        IMObjectComponentFactory factory = context.getComponentFactory();
        ComponentGrid grid = new ComponentGrid();
        grid.add(new ComponentState[]{factory.create(allocated, (IMObject)act), factory.create((Property)unallocated, (IMObject)act)});
        Column column = ColumnFactory.create((String)"CellSpacing", (Component[])new Component[]{grid.createGrid()});
        if (!allocation.getValues().isEmpty()) {
            column.add(factory.create((Property)allocation, (IMObject)act).getComponent());
        }
        return new ComponentState((Component)column, (Property)allocation);
    }
}

