/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.account;

import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.finance.account.PostStatus;
import org.openvpms.archetype.rules.finance.reminder.AccountReminderRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.paymentprocessor.internal.service.PaymentProcessorTransactionChecker;
import org.openvpms.web.component.im.edit.FinancialActions;
import org.openvpms.web.component.im.util.DefaultIMObjectSaveListener;
import org.openvpms.web.component.im.util.UserHelper;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.dialog.InformationDialogBuilder;
import org.openvpms.web.system.ServiceHelper;

public class AccountActActions
extends FinancialActions<FinancialAct> {
    private final CustomerAccountRules rules;
    private final AccountReminderRules reminderRules;
    private final PracticeService practiceService;
    private final ArchetypeService service;

    public AccountActActions(CustomerAccountRules rules, AccountReminderRules reminderRules, PracticeService practiceService, ArchetypeService service) {
        this.rules = rules;
        this.reminderRules = reminderRules;
        this.practiceService = practiceService;
        this.service = service;
    }

    public boolean canPost(FinancialAct act) {
        boolean result = super.canPost((Act)act);
        if (result && act.isA(new String[]{"act.customerAccountPayment", "act.customerAccountRefund"})) {
            String displayName;
            PaymentProcessorTransactionChecker checker;
            PostStatus postStatus = this.rules.getPostStatus(act);
            if (postStatus.hasOutstandingPaymentProcessorTransaction() && (checker = this.getPaymentProcessorTransactionChecker()).check(act)) {
                postStatus = this.rules.getPostStatus(act);
            }
            if (postStatus.hasOutstandingEFTPOSTransaction()) {
                result = false;
                displayName = DescriptorHelper.getDisplayName((IMObject)act, (ArchetypeService)this.service);
                ((InformationDialogBuilder)((InformationDialogBuilder)InformationDialog.newDialog().titleKey("act.post.title", new Object[]{displayName})).messageKey("customer.account.post.incompleteEFT", new Object[]{displayName})).show();
            } else if (postStatus.hasUnsubmittedPaymentProcessorTransaction()) {
                result = false;
                displayName = DescriptorHelper.getDisplayName((IMObject)act, (ArchetypeService)this.service);
                String name = this.getPaymentProcessorName(postStatus);
                ((InformationDialogBuilder)((InformationDialogBuilder)InformationDialog.newDialog().titleKey("act.post.title", new Object[]{displayName})).messageKey("customer.account.post.unsubmittedPP", new Object[]{displayName, name})).show();
            } else if (postStatus.hasOutstandingPaymentProcessorTransaction()) {
                result = false;
                displayName = DescriptorHelper.getDisplayName((IMObject)act, (ArchetypeService)this.service);
                String name = this.getPaymentProcessorName(postStatus);
                ((InformationDialogBuilder)((InformationDialogBuilder)InformationDialog.newDialog().titleKey("act.post.title", new Object[]{displayName})).messageKey("customer.account.post.incompletePP", new Object[]{displayName, name})).show();
            }
        }
        return result;
    }

    public boolean post(FinancialAct act) {
        boolean result = false;
        if (this.canPost(act)) {
            try {
                this.rules.post(act);
                result = true;
            }
            catch (Throwable exception) {
                DefaultIMObjectSaveListener.INSTANCE.error((IMObject)act, exception);
            }
        }
        return result;
    }

    public boolean canAdminPayment(FinancialAct act, User user) {
        return act != null && act.isA("act.customerAccountPayment") && this.isAdmin(user);
    }

    public boolean canUnhide(FinancialAct act, User user) {
        return act != null && this.isAdmin(user) && this.rules.isHidden((Act)act);
    }

    public boolean canHide(FinancialAct act, User user) {
        return act != null && this.isAdmin(user) && this.rules.canHide(act) && !this.rules.isHidden((Act)act);
    }

    public boolean canEnableReminders(FinancialAct act) {
        return act != null && this.practiceService.accountRemindersEnabled() && this.reminderRules.canEnableReminders(act);
    }

    public boolean canDisableReminders(FinancialAct act) {
        return act != null && this.practiceService.accountRemindersEnabled() && this.reminderRules.canDisableReminders(act);
    }

    protected CustomerAccountRules getCustomerAccountRules() {
        return this.rules;
    }

    protected PaymentProcessorTransactionChecker getPaymentProcessorTransactionChecker() {
        return (PaymentProcessorTransactionChecker)ServiceHelper.getBean(PaymentProcessorTransactionChecker.class);
    }

    private boolean isAdmin(User user) {
        return UserHelper.isAdmin((User)user);
    }

    private String getPaymentProcessorName(PostStatus postStatus) {
        IMObjectBean bean = this.getBean((IMObject)postStatus.getItem());
        IMObject paymentProcessor = bean.getTarget("paymentProcessor");
        return paymentProcessor != null ? paymentProcessor.getName() : "<unknown>";
    }
}

