/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer;

import java.util.Date;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.component.business.domain.im.common.PeriodRelationship;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.query.ArchetypeSortConstraint;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.relationship.RelationshipState;
import org.openvpms.web.component.im.relationship.RelationshipStateTableModel;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.workspace.customer.PatientRelationshipState;

public class PatientRelationshipStateTableModel
extends RelationshipStateTableModel {
    private static final int TYPE_INDEX = 5;
    private static final int START_TIME_INDEX = 6;
    private static final int END_TIME_INDEX = 7;

    public PatientRelationshipStateTableModel(LayoutContext context, boolean displayTarget) {
        super(context, displayTarget);
    }

    public SortConstraint[] getSortConstraints(int column, boolean ascending) {
        TableColumn col = this.getColumn(column);
        SortConstraint[] sort = col.getModelIndex() == 5 ? new SortConstraint[]{new ArchetypeSortConstraint(ascending), this.getNameSortConstraint(true)} : (col.getModelIndex() == 6 ? new SortConstraint[]{new NodeSortConstraint("activeStartTime", ascending), this.getNameSortConstraint(true)} : (col.getModelIndex() == 7 ? new SortConstraint[]{new NodeSortConstraint("activeEndTime", ascending), this.getNameSortConstraint(true)} : super.getSortConstraints(column, ascending)));
        return sort;
    }

    protected Object getValue(RelationshipState object, TableColumn column, int row) {
        Object result;
        switch (column.getModelIndex()) {
            case 5: {
                result = this.getDisplayName((IMObject)object.getRelationship());
                break;
            }
            case 6: {
                result = this.getDate(((PeriodRelationship)object.getRelationship()).getActiveStartTime());
                break;
            }
            case 7: {
                result = this.getDate(((PeriodRelationship)object.getRelationship()).getActiveEndTime());
                break;
            }
            default: {
                result = super.getValue(object, column, row);
            }
        }
        return result;
    }

    protected TableColumnModel createTableColumnModel() {
        DefaultTableColumnModel model = new DefaultTableColumnModel();
        TableColumn startTime = new TableColumn(6);
        startTime.setHeaderValue((Object)this.getDisplayName("entityRelationship.patientOwner", "activeStartTime"));
        TableColumn endTime = new TableColumn(7);
        endTime.setHeaderValue((Object)this.getDisplayName("entityRelationship.patientOwner", "activeEndTime"));
        model.addColumn(PatientRelationshipStateTableModel.createTableColumn((int)1, (String)"table.imobject.name"));
        model.addColumn(PatientRelationshipStateTableModel.createTableColumn((int)5, (String)"table.imobject.archetype"));
        model.addColumn(PatientRelationshipStateTableModel.createTableColumn((int)2, (String)"table.imobject.description"));
        model.addColumn(startTime);
        model.addColumn(endTime);
        if (this.getShowActive()) {
            model.addColumn(PatientRelationshipStateTableModel.createTableColumn((int)4, (String)"table.imobject.active"));
        }
        return model;
    }

    protected Object getDescription(RelationshipState state) {
        Object result;
        Reference ref;
        PatientRelationshipState p = (PatientRelationshipState)state;
        Reference reference = ref = this.displayTarget() ? state.getTarget() : state.getSource();
        if (TypeHelper.isA((Reference)ref, (String)"party.patientpet") && p.isDeceased()) {
            String desc = this.displayTarget() ? state.getTargetDescription() : state.getSourceDescription();
            Label label = LabelFactory.create();
            label.setText(desc);
            Label deceased = LabelFactory.create((String)"patient.deceased", (String)"Patient.Deceased");
            result = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{label, deceased});
        } else {
            result = super.getDescription(state);
        }
        return result;
    }

    private String getDate(Date date) {
        return date != null ? DateFormatter.formatDate((Date)date, (boolean)false) : null;
    }
}

