/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer;

import org.openvpms.component.business.service.archetype.ArchetypeServiceHelper;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.ActActions;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.component.workspace.ActCRUDWindow;
import org.openvpms.web.echo.help.HelpContext;

public abstract class CustomerActCRUDWindow<T extends Act>
extends ActCRUDWindow<T> {
    public CustomerActCRUDWindow(Archetypes<T> archetypes, ActActions<T> actions, Context context, HelpContext help) {
        super(archetypes, actions, context, help);
    }

    protected void onCreated(T act) {
        Party customer = this.getContext().getCustomer();
        if (customer != null) {
            try {
                IArchetypeService service = ArchetypeServiceHelper.getArchetypeService();
                Participation participation = (Participation)service.create("participation.customer", Participation.class);
                participation.setEntity(customer.getObjectReference());
                participation.setAct(act.getObjectReference());
                act.addParticipation(participation);
            }
            catch (OpenVPMSException exception) {
                ErrorHelper.show((Throwable)exception);
            }
        }
        super.onCreated(act);
    }

    protected void onPosted(T act) {
        this.print((Act)act);
    }
}

