/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.alert;

import java.util.List;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.SplitPane;
import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import nextapp.echo2.app.layout.ColumnLayoutData;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.alert.Alert;
import org.openvpms.web.component.alert.AlertManager;
import org.openvpms.web.component.alert.AlertViewer;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.EditDialogFactory;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.echo.dialog.ModalDialog;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.SplitPaneFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.alert.AlertHelper;

public class AlertsViewer
extends ModalDialog {
    private final Party party;
    private final Context context;
    private final SplitPane pane;
    private final Column buttons;
    private final Column container;
    private List<Alert> alerts;
    private Alert selected;
    private static final String EDIT_ID = "button.edit";

    public AlertsViewer(Party party, List<Alert> alerts, Context context, HelpContext help) {
        super(Messages.get((String)"alerts.title"), "AlertsViewer", CLOSE, help);
        this.party = party;
        this.context = context;
        this.alerts = alerts;
        this.addButton(EDIT_ID, this::onEdit);
        this.buttons = ColumnFactory.create((String)"Inset");
        this.container = ColumnFactory.create((String)"Inset");
        this.pane = SplitPaneFactory.create((int)3, (String)"AlertsViewer.Layout", (Component[])new Component[]{this.buttons, this.container});
        this.getLayout().add((Component)this.pane);
    }

    protected void doLayout() {
        this.layoutButtons();
        if (!this.alerts.isEmpty()) {
            this.show(this.alerts.get(0));
        } else {
            this.noAlerts();
        }
    }

    private void layoutButtons() {
        this.buttons.removeAll();
        for (Alert alert : this.alerts) {
            Button button = AlertHelper.createButton(alert, () -> this.show(alert));
            this.buttons.add((Component)button);
        }
    }

    private void show(Alert alert) {
        this.selected = alert;
        this.getButtons().setEnabled(EDIT_ID, alert.getAlert() != null);
        this.container.removeAll();
        AlertViewer viewer = new AlertViewer(alert, this.context, this.getHelpContext());
        this.container.add(viewer.getComponent());
    }

    private void noAlerts() {
        this.getButtons().setEnabled(EDIT_ID, false);
        this.pane.setSeparatorPosition(new Extent(0));
        this.pane.setResizable(false);
        this.buttons.removeAll();
        this.container.removeAll();
        ColumnLayoutData layout = new ColumnLayoutData();
        layout.setAlignment(new Alignment(4, 4));
        Label empty = LabelFactory.create((String)"alert.nomorealerts", (String)"bold");
        empty.setLayoutData((LayoutData)layout);
        this.container.add((Component)ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{empty}));
    }

    private void refresh() {
        this.alerts = ((AlertManager)ServiceHelper.getBean(AlertManager.class)).getAlerts(this.party);
        if (!this.alerts.isEmpty()) {
            this.layoutButtons();
            Alert show = null;
            if (this.selected != null) {
                show = this.alerts.stream().filter(alert -> alert.equals((Object)this.selected)).findFirst().orElse(null);
            }
            if (show == null) {
                show = this.alerts.get(0);
            }
            this.show(show);
        } else {
            this.noAlerts();
        }
    }

    private void onEdit() {
        IMObject object;
        IMObject iMObject = object = this.selected != null ? IMObjectHelper.reload((IMObject)this.selected.getAlert()) : null;
        if (object != null) {
            DefaultLayoutContext layoutContext = new DefaultLayoutContext(this.context, this.getHelpContext());
            IMObjectEditor editor = layoutContext.getEditorFactory().create(object, (LayoutContext)layoutContext);
            EditDialog dialog = ((EditDialogFactory)ServiceHelper.getBean(EditDialogFactory.class)).create(editor, this.context);
            dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

                public void onClose(WindowPaneEvent event) {
                    AlertsViewer.this.refresh();
                }
            });
            dialog.show();
        } else {
            this.refresh();
        }
    }
}

