/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.user;

import java.util.List;
import nextapp.echo2.app.Component;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.party.Contacts;
import org.openvpms.archetype.rules.user.PasswordValidator;
import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.bound.BoundPasswordField;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.edit.PropertyComponentEditor;
import org.openvpms.web.component.edit.PropertyEditor;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.ComponentSet;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.user.SignatureEditor;
import org.openvpms.web.workspace.admin.user.UserLayoutStrategy;

public class UserEditor
extends AbstractIMObjectEditor {
    private final Property confirm;
    private final UserRules rules = (UserRules)ServiceHelper.getBean(UserRules.class);
    private final PasswordValidator passwordValidator = (PasswordValidator)ServiceHelper.getBean(PasswordValidator.class);
    private final Contacts contacts = new Contacts((ArchetypeService)this.getService());
    private final PropertyComponentEditor passwordEditor;
    private final BoundPasswordField passwordField;
    private final PropertyComponentEditor confirmEditor;
    private final BoundPasswordField confirmField;
    private final SignatureEditor signatureEditor;

    public UserEditor(User object, IMObject parent, LayoutContext context) {
        super((IMObject)object, parent, context);
        Property password = this.getPassword();
        this.confirm = new SimpleProperty("confirm", (Object)password.getString(), String.class, Messages.format((String)"admin.user.password.confirm", (Object[])new Object[]{password.getDisplayName()}));
        this.passwordField = this.createPassword(password);
        this.passwordEditor = new PropertyComponentEditor(password, (Component)this.passwordField);
        this.addEditor((Editor)this.passwordEditor);
        this.confirmField = this.createPassword(this.confirm);
        this.confirm.clearModified();
        this.confirmEditor = new PropertyComponentEditor(this.confirm, (Component)this.confirmField);
        this.addEditor((Editor)this.confirmEditor);
        this.signatureEditor = new SignatureEditor(this.getSignature(object), object, this.getLayoutContext());
        this.addEditor((Editor)this.signatureEditor);
    }

    public void setName(String name) {
        this.getProperty("name").setValue((Object)name);
    }

    public IMObjectEditor newInstance() {
        this.signatureEditor.cancel();
        return new UserEditor((User)this.reload(this.getObject()), this.getParent(), this.getLayoutContext());
    }

    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && this.validateUniqueUserName(validator) && this.validatePassword(validator) && this.validateConnectFromAnywhere(validator) && this.validateActive(validator);
    }

    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return new LayoutStrategy();
    }

    private BoundPasswordField createPassword(Property property) {
        BoundPasswordField result = new BoundPasswordField(property);
        result.setStyleName(this.getLayoutContext().getComponentFactory().getStyle());
        return result;
    }

    private boolean validateActive(Validator validator) {
        Entity job;
        boolean valid = true;
        IMObject object = this.getObject();
        if (!object.isNew() && !this.getProperty("active").getBoolean() && (job = this.rules.getJobUsedBy((User)object)) != null) {
            valid = false;
            validator.add((Modifiable)this, new ValidatorError(Messages.format((String)"admin.user.requiredbyjob", (Object[])new Object[]{job.getName()})));
        }
        return valid;
    }

    private boolean validateConnectFromAnywhere(Validator validator) {
        String email;
        boolean valid = true;
        if (this.getProperty("connectFromAnywhere").getBoolean() && (email = this.contacts.getEmail((Party)((User)this.getObject()))) == null) {
            valid = false;
            validator.add((Modifiable)this, new ValidatorError(Messages.get((String)"admin.user.emailrequired")));
        }
        return valid;
    }

    private boolean validateUniqueUserName(Validator validator) {
        boolean valid = true;
        Property username = this.getProperty("username");
        String name = username.getString();
        if (name != null && this.rules.exists(name, (User)this.getObject())) {
            String message = Messages.format((String)"admin.user.duplicate", (Object[])new Object[]{name});
            ValidatorError error = new ValidatorError(this.getObject().getArchetype(), username.getName(), message);
            validator.add((Modifiable)username, error);
            valid = false;
        }
        return valid;
    }

    private boolean validatePassword(Validator validator) {
        boolean valid = false;
        Property password = this.getPassword();
        if (!password.isModified() && !this.confirm.isModified()) {
            valid = true;
        } else if (this.passwordField.matches(this.confirmField)) {
            valid = this.checkPolicy(validator);
        } else {
            ValidatorError error = new ValidatorError(this.getObject().getArchetype(), password.getName(), Messages.get((String)"admin.user.password.mismatch"));
            validator.add((Modifiable)password, error);
        }
        return valid;
    }

    private boolean checkPolicy(Validator validator) {
        List errors;
        boolean result = false;
        String password = this.passwordField.getPlainText();
        if (password == null) {
            password = "";
        }
        if (!(errors = this.passwordValidator.validate(password)).isEmpty()) {
            String message = StringUtils.join((Iterable)errors, (String)"\n");
            validator.add((Modifiable)this.passwordEditor, message);
        } else {
            result = true;
        }
        return result;
    }

    private Property getPassword() {
        return this.getProperty("password");
    }

    private DocumentAct getSignature(User user) {
        DocumentAct signature = this.rules.getSignature(user);
        if (signature == null) {
            signature = (DocumentAct)this.create("act.documentSignature", DocumentAct.class);
        }
        return signature;
    }

    private class LayoutStrategy
    extends UserLayoutStrategy {
        private LayoutStrategy() {
        }

        @Override
        public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
            this.addComponent(new ComponentState((PropertyEditor)UserEditor.this.passwordEditor));
            return super.apply(object, properties, parent, context);
        }

        @Override
        protected ComponentSet createComponentSet(IMObject object, List<Property> properties, LayoutContext context) {
            ComponentSet set = super.createComponentSet(object, properties, context);
            int index = set.indexOf("password");
            if (index != -1) {
                set.add(index + 1, new ComponentState((PropertyEditor)UserEditor.this.confirmEditor));
            }
            return set;
        }

        @Override
        protected ComponentState getSignature(User user, LayoutContext context) {
            return new ComponentState(UserEditor.this.signatureEditor.getComponent(), null, UserEditor.this.signatureEditor.getFocusGroup(), Messages.get((String)"admin.user.signature"));
        }
    }
}

