/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.type;

import org.openvpms.archetype.rules.patient.reminder.ReminderRules;
import org.openvpms.component.business.service.archetype.helper.IMObjectGraph;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.workspace.ResultSetCRUDWindow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.type.ReminderTypeEditor;

class TypeCRUDWindow
extends ResultSetCRUDWindow<Entity> {
    private static final String COPY_ID = "button.copy";

    public TypeCRUDWindow(Archetypes<Entity> archetypes, Query<Entity> query, ResultSet<Entity> set, Context context, HelpContext help) {
        super(archetypes, query, set, context, help);
    }

    protected void layoutButtons(ButtonSet buttons) {
        super.layoutButtons(buttons);
        buttons.add(COPY_ID, this.action("entity.reminderType", this::copyReminderType, null));
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
        super.enableButtons(buttons, enable);
        buttons.setEnabled(COPY_ID, enable && TypeHelper.isA((IMObject)this.getObject(), (String)"entity.reminderType"));
    }

    private void copyReminderType(Entity reminderType) {
        ReminderRules rules = (ReminderRules)ServiceHelper.getBean(ReminderRules.class);
        IMObjectGraph graph = rules.copyReminderType(reminderType);
        HelpContext edit = this.createEditTopic((IMObject)reminderType);
        LayoutContext context = this.createLayoutContext(edit);
        graph.getPrimary().setName(Messages.format((String)"imobject.copyof", (Object[])new Object[]{reminderType.getName()}));
        ReminderTypeEditor editor = new ReminderTypeEditor(graph, context);
        this.edit((IMObjectEditor)editor);
    }
}

