/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.type;

import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.archetype.rules.patient.reminder.ReminderRule;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditor;
import org.openvpms.web.component.im.edit.EditableIMObjectCollectionEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.resource.i18n.Messages;

public class ReminderCountEditor
extends AbstractIMObjectEditor {
    private static final String RULES = "rules";
    private static final String TEMPLATE = "template";

    public ReminderCountEditor(IMObject object, IMObject parent, LayoutContext layoutContext) {
        super(object, parent, layoutContext);
    }

    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && this.checkRules(validator);
    }

    private boolean checkRules(Validator validator) {
        EditableIMObjectCollectionEditor rules = (EditableIMObjectCollectionEditor)this.getEditor(RULES);
        DocumentTemplate template = this.getTemplate();
        if (rules != null) {
            IArchetypeService service = this.getService();
            for (IMObject object : rules.getCurrentObjects()) {
                ReminderRule rule = new ReminderRule(object, (ArchetypeService)service);
                if (rule.canPrint() && template == null) {
                    this.addTemplateRequired(validator);
                    break;
                }
                if (rule.canEmail() && (template == null || template.getEmailTemplate() == null)) {
                    if (template == null) {
                        this.addTemplateRequired(validator);
                        break;
                    }
                    this.addTemplateRequired(template, "reminder.count.email.required", validator);
                    break;
                }
                if (!rule.canSMS() || template != null && template.getSMSTemplate() != null) continue;
                if (template == null) {
                    this.addTemplateRequired(validator);
                    break;
                }
                this.addTemplateRequired(template, "reminder.count.sms.required", validator);
                break;
            }
        }
        return validator.isValid();
    }

    private void addTemplateRequired(Validator validator) {
        Property property = this.getProperty(TEMPLATE);
        this.reportRequired(property, validator);
    }

    private void addTemplateRequired(DocumentTemplate template, String key, Validator validator) {
        Property property = this.getProperty(TEMPLATE);
        String message = Messages.format((String)key, (Object[])new Object[]{template.getName()});
        validator.add((Modifiable)property, new ValidatorError(property, message));
    }

    private DocumentTemplate getTemplate() {
        IMObjectBean bean = this.getBean(this.getObject());
        Entity template = (Entity)this.getObject(bean.getTargetRef(TEMPLATE));
        return template != null ? new DocumentTemplate(template, (ArchetypeService)this.getService()) : null;
    }
}

