/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.template.letterhead;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.doc.LogoEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.admin.organisation.AbstractOrganisationEditor;
import org.openvpms.web.workspace.admin.template.LetterheadLayoutStrategy;

public class LetterheadEditor
extends AbstractOrganisationEditor {
    public LetterheadEditor(Entity object, IMObject parent, LayoutContext layoutContext) {
        super(object, parent, layoutContext);
    }

    public void setLogo(Document document) {
        this.getLogoEditor().setImage(document);
    }

    public IMObjectEditor newInstance() {
        this.getLogoEditor().cancel();
        return new LetterheadEditor((Entity)this.reload(this.getObject()), this.getParent(), this.getLayoutContext());
    }

    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && this.validateLogo(validator);
    }

    protected boolean validateLogo(Validator validator) {
        boolean result = true;
        Property logoFile = this.getProperty("logoFile");
        String logo = logoFile.getString();
        if (logo != null) {
            Path path = Paths.get(logo, new String[0]);
            if (!Files.isRegularFile(path, new LinkOption[0]) || !Files.isReadable(path)) {
                validator.add((Modifiable)logoFile, new ValidatorError(logoFile, Messages.format((String)"file.notfound", (Object[])new Object[]{logo})));
                result = false;
            }
        } else if (!this.getLogoEditor().hasImage()) {
            validator.add((Modifiable)logoFile, new ValidatorError(logoFile, Messages.get((String)"admin.template.letterhead.nologo")));
            result = false;
        }
        return result;
    }

    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return new Layout();
    }

    private class Layout
    extends LetterheadLayoutStrategy {
        private Layout() {
        }

        @Override
        protected ComponentState getLogo(IMObject object, LayoutContext context) {
            LogoEditor logoEditor = LetterheadEditor.this.getLogoEditor();
            return new ComponentState(logoEditor.getComponent(), null, logoEditor.getFocusGroup(), Messages.get((String)"admin.practice.logo"));
        }
    }
}

