/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.template;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.edit.DefaultIMObjectReferenceEditor;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.util.IMObjectCreator;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.template.CustomerPatientSMSTemplateSampler;
import org.openvpms.web.workspace.reporting.reminder.ReminderSMSEvaluator;

public class SMSReminderTemplateSampler
extends CustomerPatientSMSTemplateSampler {
    private final SimpleProperty reminderType = new SimpleProperty("reminderType", null, IMObjectReference.class, DescriptorHelper.getDisplayName((String)"act.patientReminder", (String)"reminderType", (ArchetypeService)ServiceHelper.getArchetypeService()));
    private final ReminderSMSEvaluator evaluator = (ReminderSMSEvaluator)ServiceHelper.getBean(ReminderSMSEvaluator.class);

    public SMSReminderTemplateSampler(Entity template, LayoutContext layoutContext) {
        super(template, layoutContext);
        this.reminderType.setArchetypeRange(new String[]{"entity.reminderType"});
        ModifiableListener listener = modifiable -> this.evaluate();
        this.reminderType.addModifiableListener(listener);
    }

    @Override
    protected String evaluate(Entity template, Context context) {
        String result = null;
        Party customer = (Party)IMObjectHelper.getObject((Reference)this.getCustomer(), (Context)this.getContext().getContext());
        Party patient = (Party)IMObjectHelper.getObject((Reference)this.getPatient(), (Context)this.getContext().getContext());
        Entity type = this.getReminderType();
        if (customer != null && patient != null && type != null) {
            Act reminder = (Act)IMObjectCreator.create((String)"act.patientReminder");
            IMObjectBean bean = ServiceHelper.getArchetypeService().getBean((IMObject)reminder);
            bean.setTarget("patient", (IMObject)patient);
            bean.setTarget("reminderType", (IMObject)type);
            result = this.evaluator.evaluate(template, reminder, customer, patient, context.getLocation(), context.getPractice());
        }
        return result;
    }

    @Override
    protected void layoutFields(ComponentGrid grid, FocusGroup group, LayoutContext context) {
        super.layoutFields(grid, group, context);
        DefaultIMObjectReferenceEditor selector = new DefaultIMObjectReferenceEditor((Property)this.reminderType, null, context);
        Label label = LabelFactory.create();
        label.setText(this.reminderType.getDisplayName());
        grid.add(new Component[]{label, selector.getComponent()});
        group.add(selector.getFocusGroup());
    }

    protected Entity getReminderType() {
        return (Entity)IMObjectHelper.getObject((Reference)this.reminderType.getReference());
    }
}

