/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.template;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.archetype.rules.doc.DocumentTemplatePrinter;
import org.openvpms.archetype.rules.doc.PrinterReference;
import org.openvpms.archetype.rules.practice.LocationRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.criteria.TypedQueryIterator;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

class PrinterUseManager {
    private final ArchetypeService service;
    private final PracticeService practiceService;
    private final LocationRules locationRules;
    private final TransactionTemplate transactionTemplate;
    private final Map<PrinterReference, PrinterUse> usage = new HashMap<PrinterReference, PrinterUse>();
    private static final String DEFAULT_PRINTER = "defaultPrinter";
    private static final String PRINTERS = "printers";
    private static final String PRINTER = "printer";

    public PrinterUseManager(ArchetypeService service, PracticeService practiceService, LocationRules locationRules, PlatformTransactionManager transactionManager) {
        this.service = service;
        this.practiceService = practiceService;
        this.locationRules = locationRules;
        this.transactionTemplate = new TransactionTemplate(transactionManager);
    }

    public void refresh() {
        this.usage.clear();
        Iterator<Entity> iterator = this.getTemplates();
        while (iterator.hasNext()) {
            DocumentTemplate template = new DocumentTemplate(iterator.next(), this.service);
            for (DocumentTemplatePrinter printer : template.getPrinters()) {
                PrinterReference reference = printer.getPrinter();
                if (reference == null) continue;
                PrinterUse use = this.getOrCreate(reference);
                use.addPrinter(printer, template);
            }
        }
        for (Party location : this.getLocations()) {
            PrinterReference defaultPrinter = this.locationRules.getDefaultPrinter(location);
            if (defaultPrinter != null) {
                this.addPrinter(location, defaultPrinter);
            }
            for (PrinterReference reference : this.locationRules.getPrinters(location)) {
                this.addPrinter(location, reference);
            }
        }
    }

    public boolean hasPrinters() {
        return !this.usage.isEmpty();
    }

    public List<PrinterReference> getPrinters() {
        return new ArrayList<PrinterReference>(this.usage.keySet());
    }

    public void replace(PrinterReference from, PrinterReference to) {
        PrinterUse use = this.usage.get(from);
        if (use != null) {
            use.change(to);
        }
    }

    public void remove(PrinterReference printer) {
        PrinterUse use = this.usage.get(printer);
        if (use != null) {
            use.remove();
        }
    }

    public List<Entity> getUse(PrinterReference reference) {
        ArrayList<Entity> result = new ArrayList<Entity>();
        PrinterUse use = this.usage.get(reference);
        if (use != null) {
            result.addAll(use.getLocations());
            for (DocumentTemplate template : use.getTemplates()) {
                result.add(template.getEntity());
            }
        }
        return result;
    }

    protected List<Party> getLocations() {
        return this.practiceService.getLocations();
    }

    protected Iterator<Entity> getTemplates() {
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Entity.class);
        Root from = query.from(Entity.class, new String[]{"entity.documentTemplate"});
        query.where((Expression)builder.equal((Expression)from.get("active"), (Object)true));
        query.orderBy(new Order[]{builder.asc((Expression)from.get("id"))});
        return new TypedQueryIterator(this.service.createQuery(query), 500);
    }

    private void addPrinter(Party location, PrinterReference reference) {
        PrinterUse use = this.getOrCreate(reference);
        use.addLocation(location);
    }

    private PrinterUse getOrCreate(PrinterReference reference) {
        return this.usage.computeIfAbsent(reference, x$0 -> new PrinterUse((PrinterReference)x$0));
    }

    private class PrinterUse {
        private final PrinterReference reference;
        private final Set<Party> locations = new HashSet<Party>();
        private final Map<DocumentTemplatePrinter, DocumentTemplate> printers = new HashMap<DocumentTemplatePrinter, DocumentTemplate>();

        public PrinterUse(PrinterReference reference) {
            this.reference = reference;
        }

        public void addLocation(Party location) {
            this.locations.add(location);
        }

        public void addPrinter(DocumentTemplatePrinter printer, DocumentTemplate template) {
            this.printers.put(printer, template);
        }

        public Set<Party> getLocations() {
            return this.locations;
        }

        public Collection<DocumentTemplate> getTemplates() {
            return this.printers.values();
        }

        public void change(PrinterReference to) {
            for (Party party : this.locations) {
                IMObjectBean bean = PrinterUseManager.this.service.getBean((IMObject)party);
                this.updateDefaultPrinter(bean, to);
                List printers = bean.getTargets(PrinterUseManager.PRINTERS, Entity.class);
                Entity from = this.getPrinter(printers, this.reference);
                Entity existing = this.getPrinter(printers, to);
                if (from == null) continue;
                if (existing == null) {
                    IMObjectBean fromBean = PrinterUseManager.this.service.getBean((IMObject)from);
                    fromBean.setValue(PrinterUseManager.PRINTER, (Object)to.toString());
                    fromBean.save();
                    continue;
                }
                this.remove(bean, from);
            }
            for (Map.Entry entry : this.printers.entrySet()) {
                DocumentTemplatePrinter printer = (DocumentTemplatePrinter)entry.getKey();
                printer.setPrinter(to.toString());
                PrinterUseManager.this.service.save((IMObject)((DocumentTemplate)entry.getValue()).getEntity());
            }
        }

        public void remove() {
            for (Party party : this.locations) {
                IMObjectBean bean = PrinterUseManager.this.service.getBean((IMObject)party);
                this.updateDefaultPrinter(bean, null);
                List printers = bean.getTargets(PrinterUseManager.PRINTERS, Entity.class);
                Entity printer = this.getPrinter(printers, this.reference);
                if (printer == null) continue;
                this.remove(bean, printer);
            }
            for (Map.Entry entry : this.printers.entrySet()) {
                DocumentTemplatePrinter printer = (DocumentTemplatePrinter)entry.getKey();
                Entity template = ((DocumentTemplate)entry.getValue()).getEntity();
                template.removeEntityRelationship(printer.getRelationship());
                PrinterUseManager.this.service.save((IMObject)template);
            }
        }

        private void updateDefaultPrinter(IMObjectBean bean, PrinterReference to) {
            PrinterReference defaultPrinter = PrinterReference.fromString((String)bean.getString(PrinterUseManager.DEFAULT_PRINTER));
            if (defaultPrinter != null && defaultPrinter.equals((Object)this.reference)) {
                bean.setValue(PrinterUseManager.DEFAULT_PRINTER, (Object)(to != null ? to.toString() : null));
                bean.save();
            }
        }

        private void remove(final IMObjectBean bean, final Entity printer) {
            PrinterUseManager.this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                    bean.removeTarget(PrinterUseManager.PRINTERS, (IMObject)printer);
                    bean.save();
                    PrinterUseManager.this.service.remove((IMObject)printer);
                }
            });
        }

        private Entity getPrinter(List<Entity> printers, PrinterReference reference) {
            String str = reference.toString();
            for (Entity printer : printers) {
                IMObjectBean bean = PrinterUseManager.this.service.getBean((IMObject)printer);
                if (!Objects.equals(str, bean.getString(PrinterUseManager.PRINTER))) continue;
                return printer;
            }
            return null;
        }
    }
}

