/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.system.smartflow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.SplitPane;
import nextapp.echo2.app.event.WindowPaneListener;
import org.apache.commons.lang3.ObjectUtils;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.model.party.Party;
import org.openvpms.smartflow.client.FlowSheetServiceFactory;
import org.openvpms.smartflow.event.SmartFlowSheetEventService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.AbstractBrowserListener;
import org.openvpms.web.component.im.query.AbstractQueryBrowser;
import org.openvpms.web.component.im.query.BrowserListener;
import org.openvpms.web.component.im.query.ListQuery;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.im.view.ReadOnlyComponentFactory;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ModalDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.SplitPaneFactory;
import org.openvpms.web.echo.factory.TextComponentFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.text.TextArea;
import org.openvpms.web.echo.text.TextComponent;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.system.smartflow.Status;
import org.openvpms.web.workspace.admin.system.smartflow.StatusTableModel;

public class SmartFlowSheetAdminDialog
extends ModalDialog {
    private final SmartFlowSheetEventService service;
    private final StatusBrowser browser;
    private final List<Status> statuses;
    private final Column container;
    private final ReadOnlyComponentFactory componentFactory;

    public SmartFlowSheetAdminDialog(Context context, HelpContext help) {
        super(Messages.get((String)"admin.system.smartflow.title"), "BrowserDialog", OK);
        List<Party> locations;
        PracticeRules rules = (PracticeRules)ServiceHelper.getBean(PracticeRules.class);
        this.service = (SmartFlowSheetEventService)ServiceHelper.getBean(SmartFlowSheetEventService.class);
        FlowSheetServiceFactory factory = (FlowSheetServiceFactory)ServiceHelper.getBean(FlowSheetServiceFactory.class);
        PracticeService practiceService = (PracticeService)ServiceHelper.getBean(PracticeService.class);
        Party practice = context.getPractice();
        if (practice != null) {
            locations = new ArrayList<Party>(rules.getLocations(practice));
            locations.sort((o1, o2) -> ObjectUtils.compare((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName())));
        } else {
            locations = Collections.emptyList();
        }
        this.statuses = new ArrayList<Status>();
        for (Party location : locations) {
            this.statuses.add(new Status(location, this.service, factory, practiceService));
        }
        ListQuery query = new ListQuery(this.statuses, "party.organisationLocation", Status.class);
        DefaultLayoutContext layout = new DefaultLayoutContext(context, help);
        this.componentFactory = new ReadOnlyComponentFactory((LayoutContext)new DefaultLayoutContext((LayoutContext)layout));
        this.browser = new StatusBrowser((Query<Status>)query, (LayoutContext)layout);
        this.browser.addBrowserListener((BrowserListener)new AbstractBrowserListener<Status>(){

            public void selected(Status object) {
                SmartFlowSheetAdminDialog.this.onSelected(object);
            }
        });
        this.container = ColumnFactory.create((String)"Inset.Large");
        SplitPane pane = SplitPaneFactory.create((int)5, (String)"BrowserCRUDWorkspace.Layout", (Component[])new Component[]{this.browser.getComponent(), this.container});
        this.getLayout().add((Component)pane);
        ButtonSet buttons = this.getButtons();
        buttons.add("button.refresh", this::refresh);
        buttons.add("button.restartsfs", this::onRestart);
    }

    private void onSelected(Status object) {
        this.container.removeAll();
        Property id = this.createProperty("id", object.getId(), Long.class, "table.imobject.id");
        Property name = this.createProperty("name", object.getName(), String.class, "table.imobject.name");
        Property key = this.createProperty("key", object.getDisplayKey(), String.class, "admin.system.smartflow.key");
        Property apiStatus = this.createProperty("apistatus", object.getAPIStatusName(), String.class, "admin.system.smartflow.apistatus");
        Property queueStatus = this.createProperty("queuestatus", object.getQueueStatusName(), String.class, "admin.system.smartflow.queuestatus");
        String receivedTime = object.getEventReceived() != null ? DateFormatter.formatDateTimeAbbrev((Date)object.getEventReceived()) : null;
        Property received = this.createProperty("received", receivedTime, String.class, "admin.system.smartflow.received");
        ComponentGrid grid = new ComponentGrid();
        grid.add(new ComponentState[]{this.createComponent(id)});
        grid.add(new ComponentState[]{this.createComponent(name)});
        grid.add(new ComponentState[]{this.createComponent(key, 10)});
        ComponentState apiComponent = this.createComponent(apiStatus, 20);
        if (object.getAPIStatus() == Status.ComponentStatus.ERROR) {
            grid.add(new Component[]{apiComponent.getLabel(), this.createError(object.getAPIError())});
        } else {
            grid.add(new ComponentState[]{apiComponent});
        }
        if (object.getQueueStatus() == Status.ComponentStatus.CONNECTED || object.getQueueStatus() == Status.ComponentStatus.ERROR) {
            ComponentState queueComponent = this.createComponent(queueStatus, 20);
            if (object.getQueueStatus() == Status.ComponentStatus.ERROR) {
                grid.add(new Component[]{queueComponent.getLabel(), this.createError(object.getQueueError())});
            } else {
                grid.add(new ComponentState[]{queueComponent});
            }
            grid.add(new ComponentState[]{this.createComponent(received, 10)});
        }
        this.container.add((Component)grid.createGrid());
    }

    private Component createError(String message) {
        TextArea area = TextComponentFactory.createTextArea((int)80, (int)4);
        area.setText(message);
        area.setEnabled(false);
        return area;
    }

    private ComponentState createComponent(Property property, int length) {
        ComponentState state = new ComponentState(this.componentFactory.create(property), property);
        if (state.getComponent() instanceof TextComponent) {
            ((TextComponent)state.getComponent()).setWidth(new Extent(length, 64));
        }
        return state;
    }

    private ComponentState createComponent(Property property) {
        return new ComponentState(this.componentFactory.create(property), property);
    }

    private Property createProperty(String name, Object value, Class<?> type, String key) {
        return new SimpleProperty(name, value, type, Messages.get((String)key), true);
    }

    private void onRestart() {
        ConfirmationDialog.show((String)Messages.get((String)"admin.system.smartflow.restartqueue.title"), (String)Messages.get((String)"admin.system.smartflow.restartqueue.message"), (String[])ConfirmationDialog.YES_NO, (WindowPaneListener)new PopupDialogListener(){

            public void onYes() {
                SmartFlowSheetAdminDialog.this.service.restart();
                SmartFlowSheetAdminDialog.this.refresh();
            }
        });
    }

    private void refresh() {
        for (Status status : this.statuses) {
            status.refresh();
        }
        this.browser.query();
    }

    private static class StatusBrowser
    extends AbstractQueryBrowser<Status> {
        public StatusBrowser(Query<Status> query, LayoutContext context) {
            super(query, null, (IMTableModel)new StatusTableModel(), context);
        }
    }
}

