/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.system.settings;

import nextapp.echo2.app.Component;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.report.openoffice.OpenOfficeService;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ConfirmationDialogBuilder;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.system.openoffice.OpenOfficeStatus;
import org.openvpms.web.workspace.admin.system.settings.SettingsTab;

public class OpenOfficeSettings
extends SettingsTab {
    private final OpenOfficeStatus status = new OpenOfficeStatus((OpenOfficeService)ServiceHelper.getBean(OpenOfficeService.class), (ArchetypeService)ServiceHelper.getArchetypeService());
    private static final String REFRESH_ID = "button.refresh";
    private static final String RESTART_ID = "button.restartopenoffice";
    private static final String[] BUTTONS = new String[]{"button.refresh", "button.restartopenoffice"};

    public OpenOfficeSettings(HelpContext help) {
        super("entity.globalSettingsOpenOffice", help, BUTTONS);
    }

    @Override
    public void show() {
        Component component = this.getComponent();
        component.removeAll();
        component.add((Component)ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{this.status.getComponent()}));
    }

    @Override
    public void onButton(String button) {
        if (REFRESH_ID.equals(button)) {
            this.status.refresh();
        } else if (RESTART_ID.equals(button)) {
            this.restart();
        }
    }

    public static boolean isAvailable() {
        return ServiceHelper.getContext().getBeanNamesForType(OpenOfficeService.class).length > 0;
    }

    @Override
    protected void onChanged(Entity settings) {
        super.onChanged(settings);
        this.restart();
    }

    private void restart() {
        ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().title(Messages.get((String)"admin.system.openoffice.title"))).message(Messages.get((String)"admin.system.openoffice.restart"))).yesNo()).yes(() -> {
            ((OpenOfficeService)ServiceHelper.getBean(OpenOfficeService.class)).restart();
            this.show();
        })).show();
    }
}

