/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.system.openoffice;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.jodconverter.local.office.LocalOfficeUtils;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.report.openoffice.OpenOfficeConfig;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.resource.i18n.Messages;

public class OpenOfficeEditor
extends AbstractIMObjectEditor {
    public OpenOfficeEditor(Entity settings, IMObject parent, LayoutContext context) {
        super((IMObject)settings, parent, context);
        Property maxTasks;
        Property ports;
        Property home = this.getProperty("path");
        if (StringUtils.isEmpty((CharSequence)home.getString())) {
            home.setValue((Object)OpenOfficeConfig.getDefaultPath());
        }
        if (StringUtils.isEmpty((CharSequence)(ports = this.getProperty("ports")).getString())) {
            ports.setValue((Object)8100);
        }
        if ((maxTasks = this.getProperty("maxTasksPerProcess")).getValue() == null) {
            maxTasks.setValue((Object)200);
        }
    }

    public String getTitle() {
        return Messages.get((String)"admin.system.openoffice.config");
    }

    public IMObjectEditor newInstance() {
        return new OpenOfficeEditor((Entity)this.reload(this.getObject()), this.getParent(), this.getLayoutContext());
    }

    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && this.validateHome(validator) && this.validatePorts(validator);
    }

    protected boolean validateHome(Validator validator) {
        boolean result = false;
        Property home = this.getProperty("path");
        String string = home.getString();
        if (StringUtils.isEmpty((CharSequence)string)) {
            validator.add((Modifiable)home, Messages.format((String)"admin.openoffice.home.invalid", (Object[])new Object[]{home.getDisplayName()}));
        } else {
            File file = new File(string);
            if (!file.isDirectory()) {
                validator.add((Modifiable)home, Messages.format((String)"admin.openoffice.home.invalid", (Object[])new Object[]{home.getDisplayName()}));
            } else {
                File executable = LocalOfficeUtils.getOfficeExecutable((File)file);
                if (executable.isFile()) {
                    result = true;
                } else {
                    validator.add((Modifiable)home, Messages.format((String)"admin.openoffice.home.noexecutable", (Object[])new Object[]{home.getDisplayName()}));
                }
            }
        }
        return result;
    }

    protected boolean validatePorts(Validator validator) {
        boolean result = false;
        Property property = this.getProperty("ports");
        String string = property.getString();
        if (!StringUtils.isEmpty((CharSequence)string) && string.matches("^\\d+(\\s*,\\s*\\d+)*$")) {
            result = true;
        } else {
            validator.add((Modifiable)property, Messages.get((String)"admin.openoffice.ports.invalid"));
        }
        return result;
    }
}

