/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.system.diagnostics;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.table.DefaultTableModel;
import nextapp.echo2.app.table.TableModel;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.plugin.manager.PluginManager;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.factory.TableFactory;
import org.openvpms.web.echo.table.DefaultTableHeaderRenderer;
import org.openvpms.web.echo.table.KeyTable;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.system.diagnostics.AbstractDiagnosticTab;
import org.openvpms.web.workspace.admin.system.plugin.BundleHelper;
import org.osgi.framework.Bundle;

class PluginViewer
extends AbstractDiagnosticTab {
    private final String[] columns = new String[]{Messages.get((String)"admin.system.plugin.id"), Messages.get((String)"admin.system.plugin.name"), Messages.get((String)"admin.system.plugin.version"), Messages.get((String)"admin.system.plugin.status")};
    private String[][] snapshot;

    PluginViewer() {
        super("admin.system.diagnostic.plugin");
    }

    @Override
    public Document getDocument() {
        Document result = null;
        String[][] data = this.getData(false);
        if (data != null) {
            result = this.toCSV("plugins.csv", this.columns, data);
        }
        return result;
    }

    @Override
    protected Component getContent() {
        KeyTable result = null;
        Object[][] data = this.getData(true);
        if (data != null) {
            DefaultTableModel model = new DefaultTableModel(data, (Object[])this.columns);
            KeyTable table = TableFactory.create((TableModel)model);
            table.setDefaultHeaderRenderer(DefaultTableHeaderRenderer.DEFAULT);
            table.setHeaderFixed(true);
            result = table;
        }
        return result;
    }

    private String[][] getData(boolean refresh) {
        if (this.snapshot == null || refresh) {
            try {
                PluginManager pluginManager = (PluginManager)ServiceHelper.getBean(PluginManager.class);
                Bundle[] bundles = pluginManager.getBundles();
                this.snapshot = new String[bundles.length][];
                for (int i = 0; i < bundles.length; ++i) {
                    Bundle bundle = bundles[i];
                    String[] row = new String[]{Long.toString(bundle.getBundleId()), BundleHelper.getName(bundle), bundle.getVersion().toString(), BundleHelper.getState(bundle)};
                    this.snapshot[i] = row;
                }
            }
            catch (Throwable exception) {
                this.snapshot = null;
                ErrorHelper.show((Throwable)exception);
            }
        }
        return this.snapshot;
    }
}

